/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.support.MonotonicClock;

public class DefaultMessageHistory
implements MessageHistory {
    private final String routeId;
    private final NamedNode node;
    private final String nodeId;
    private final MonotonicClock clock = new MonotonicClock();
    private final Message message;
    private boolean acceptDebugger;
    private long elapsed;

    public DefaultMessageHistory(String routeId, NamedNode node) {
        this(routeId, node, null);
    }

    public DefaultMessageHistory(String routeId, NamedNode node, Message message) {
        this.routeId = routeId;
        this.node = node;
        this.nodeId = node.getId();
        this.message = message;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public NamedNode getNode() {
        return this.node;
    }

    @Override
    public long getTime() {
        return this.clock.getCreated();
    }

    @Override
    public long getElapsed() {
        return this.elapsed;
    }

    @Override
    public void nodeProcessingDone() {
        this.elapsed = this.clock.elapsed();
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public void setAcceptDebugger(boolean acceptDebugger) {
        this.acceptDebugger = acceptDebugger;
    }

    @Override
    public boolean isAcceptDebugger() {
        return this.acceptDebugger;
    }

    public String toString() {
        return "DefaultMessageHistory[routeId=" + this.routeId + ", node=" + this.nodeId + "]";
    }
}

