/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pdf;

import org.apache.camel.CamelContext;
import org.apache.camel.component.pdf.PdfEndpoint;
import org.apache.camel.component.pdf.TextProcessingFactory;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class PdfEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        PdfEndpoint target = (PdfEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "font": {
                target.getPdfConfiguration().setFont(PdfEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "fontsize": 
            case "fontSize": {
                target.getPdfConfiguration().setFontSize(PdfEndpointConfigurer.property(camelContext, Float.TYPE, value).floatValue());
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(PdfEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "marginbottom": 
            case "marginBottom": {
                target.getPdfConfiguration().setMarginBottom(PdfEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "marginleft": 
            case "marginLeft": {
                target.getPdfConfiguration().setMarginLeft(PdfEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "marginright": 
            case "marginRight": {
                target.getPdfConfiguration().setMarginRight(PdfEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "margintop": 
            case "marginTop": {
                target.getPdfConfiguration().setMarginTop(PdfEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "pagesize": 
            case "pageSize": {
                target.getPdfConfiguration().setPageSize(PdfEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "textprocessingfactory": 
            case "textProcessingFactory": {
                target.getPdfConfiguration().setTextProcessingFactory(PdfEndpointConfigurer.property(camelContext, TextProcessingFactory.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "font": {
                return String.class;
            }
            case "fontsize": 
            case "fontSize": {
                return Float.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "marginbottom": 
            case "marginBottom": {
                return Integer.TYPE;
            }
            case "marginleft": 
            case "marginLeft": {
                return Integer.TYPE;
            }
            case "marginright": 
            case "marginRight": {
                return Integer.TYPE;
            }
            case "margintop": 
            case "marginTop": {
                return Integer.TYPE;
            }
            case "pagesize": 
            case "pageSize": {
                return String.class;
            }
            case "textprocessingfactory": 
            case "textProcessingFactory": {
                return TextProcessingFactory.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        PdfEndpoint target = (PdfEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "font": {
                return target.getPdfConfiguration().getFont();
            }
            case "fontsize": 
            case "fontSize": {
                return Float.valueOf(target.getPdfConfiguration().getFontSize());
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "marginbottom": 
            case "marginBottom": {
                return target.getPdfConfiguration().getMarginBottom();
            }
            case "marginleft": 
            case "marginLeft": {
                return target.getPdfConfiguration().getMarginLeft();
            }
            case "marginright": 
            case "marginRight": {
                return target.getPdfConfiguration().getMarginRight();
            }
            case "margintop": 
            case "marginTop": {
                return target.getPdfConfiguration().getMarginTop();
            }
            case "pagesize": 
            case "pageSize": {
                return target.getPdfConfiguration().getPageSize();
            }
            case "textprocessingfactory": 
            case "textProcessingFactory": {
                return target.getPdfConfiguration().getTextProcessingFactory();
            }
        }
        return null;
    }
}

