/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.FontHeaders;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.util.autodetect.FontFileFinder;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdmodel.font.CIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.FontCache;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.FontInfo;
import org.apache.pdfbox.pdmodel.font.FontProvider;
import org.apache.pdfbox.pdmodel.font.PDPanoseClassification;

final class FileSystemFontProvider
extends FontProvider {
    private static final Log LOG = LogFactory.getLog(FileSystemFontProvider.class);
    private static final boolean SKIP_CHECKSUMS = "true".equals(System.getProperty("pdfbox.fontcache.skipchecksums"));
    private static final String CHECKSUM_PLACEHOLDER = "-";
    private final List<FSFontInfo> fontInfoList = new ArrayList<FSFontInfo>();
    private final FontCache cache;

    private FSFontInfo createFSIgnored(File file, FontFormat format, String postScriptName) {
        String hash;
        try {
            hash = SKIP_CHECKSUMS ? CHECKSUM_PLACEHOLDER : FileSystemFontProvider.computeHash(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (IOException ex) {
            hash = "";
        }
        return new FSFontInfo(file, format, postScriptName, null, 0, 0, 0, 0, 0, null, null, hash, file.lastModified());
    }

    FileSystemFontProvider(FontCache cache) {
        this.cache = cache;
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Will search the local system for fonts");
            }
            FontFileFinder fontFileFinder = new FontFileFinder();
            List<URI> fonts = fontFileFinder.find();
            ArrayList<File> files = new ArrayList<File>(fonts.size());
            for (URI font : fonts) {
                files.add(new File(font));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found " + files.size() + " fonts on the local system"));
            }
            if (!files.isEmpty()) {
                List<FSFontInfo> cachedInfos = this.loadDiskCache(files);
                if (cachedInfos != null && !cachedInfos.isEmpty()) {
                    this.fontInfoList.addAll(cachedInfos);
                } else {
                    LOG.warn((Object)"Building on-disk font cache, this may take a while");
                    this.scanFonts(files);
                    this.saveDiskCache();
                    LOG.warn((Object)("Finished building on-disk font cache, found " + this.fontInfoList.size() + " fonts"));
                }
            }
        }
        catch (AccessControlException e) {
            LOG.error((Object)"Error accessing the file system", (Throwable)e);
        }
    }

    private void scanFonts(List<File> files) {
        for (File file : files) {
            String filePath = file.getPath().toLowerCase();
            if (filePath.endsWith(".ttf") || filePath.endsWith(".otf")) {
                this.addTrueTypeFont(file);
                continue;
            }
            if (filePath.endsWith(".ttc") || filePath.endsWith(".otc")) {
                this.addTrueTypeCollection(file);
                continue;
            }
            if (!filePath.endsWith(".pfb")) continue;
            this.addType1Font(file);
        }
    }

    private File getDiskCacheFile() {
        String path = System.getProperty("pdfbox.fontcache");
        if (FileSystemFontProvider.isBadPath(path) && FileSystemFontProvider.isBadPath(path = System.getProperty("user.home"))) {
            path = System.getProperty("java.io.tmpdir");
        }
        return new File(path, ".pdfbox.cache");
    }

    private static boolean isBadPath(String path) {
        return path == null || !new File(path).isDirectory() || !new File(path).canWrite();
    }

    private void saveDiskCache() {
        try {
            File file = this.getDiskCacheFile();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (FSFontInfo fontInfo : this.fontInfoList) {
                    this.writeFontInfo(writer, fontInfo);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Could not write to font cache", (Throwable)e);
                LOG.warn((Object)"Installed fonts information will have to be reloaded for each start");
                LOG.warn((Object)"You can assign a directory to the 'pdfbox.fontcache' property");
            }
        }
        catch (SecurityException e) {
            LOG.debug((Object)"Couldn't create writer for font cache file", (Throwable)e);
        }
    }

    private void writeFontInfo(BufferedWriter writer, FSFontInfo fontInfo) throws IOException {
        writer.write(fontInfo.postScriptName.trim());
        writer.write("|");
        writer.write(fontInfo.format.toString());
        writer.write("|");
        if (fontInfo.cidSystemInfo != null) {
            writer.write(fontInfo.cidSystemInfo.getRegistry() + '-' + fontInfo.cidSystemInfo.getOrdering() + '-' + fontInfo.cidSystemInfo.getSupplement());
        }
        writer.write("|");
        if (fontInfo.usWeightClass > -1) {
            writer.write(Integer.toHexString(fontInfo.usWeightClass));
        }
        writer.write("|");
        if (fontInfo.sFamilyClass > -1) {
            writer.write(Integer.toHexString(fontInfo.sFamilyClass));
        }
        writer.write("|");
        writer.write(Integer.toHexString(fontInfo.ulCodePageRange1));
        writer.write("|");
        writer.write(Integer.toHexString(fontInfo.ulCodePageRange2));
        writer.write("|");
        if (fontInfo.macStyle > -1) {
            writer.write(Integer.toHexString(fontInfo.macStyle));
        }
        writer.write("|");
        if (fontInfo.panose != null) {
            byte[] bytes = fontInfo.panose.getBytes();
            for (int i = 0; i < 10; ++i) {
                String str = Integer.toHexString(bytes[i]);
                if (str.length() == 1) {
                    writer.write(48);
                }
                writer.write(str);
            }
        }
        writer.write("|");
        writer.write(fontInfo.file.getAbsolutePath());
        writer.write("|");
        writer.write(fontInfo.hash);
        writer.write("|");
        writer.write(Long.toString(fontInfo.file.lastModified()));
        writer.newLine();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<FSFontInfo> loadDiskCache(List<File> files) {
        HashSet<String> pending = new HashSet<String>(files.size());
        for (File file : files) {
            pending.add(file.getAbsolutePath());
        }
        ArrayList<FSFontInfo> results = new ArrayList<FSFontInfo>();
        File diskCacheFile = null;
        boolean fileExists = false;
        try {
            diskCacheFile = this.getDiskCacheFile();
            fileExists = diskCacheFile.exists();
        }
        catch (SecurityException e) {
            LOG.debug((Object)"Error checking for file existence", (Throwable)e);
        }
        if (fileExists) {
            try (BufferedReader reader = new BufferedReader(new FileReader(diskCacheFile));){
                String line;
                File lastFile = null;
                String lastHash = null;
                while ((line = reader.readLine()) != null) {
                    File fontFile;
                    block37: {
                        String[] parts = line.split("\\|", 12);
                        if (parts.length < 10) {
                            LOG.warn((Object)("Incorrect line '" + line + "' in font disk cache is skipped"));
                            continue;
                        }
                        CIDSystemInfo cidSystemInfo = null;
                        int usWeightClass = -1;
                        int sFamilyClass = -1;
                        int macStyle = -1;
                        byte[] panose = null;
                        String hash = "";
                        long lastModified = 0L;
                        String postScriptName = parts[0];
                        FontFormat format = FontFormat.valueOf(parts[1]);
                        if (parts[2].length() > 0) {
                            String[] ros = parts[2].split(CHECKSUM_PLACEHOLDER);
                            cidSystemInfo = new CIDSystemInfo(ros[0], ros[1], Integer.parseInt(ros[2]));
                        }
                        if (parts[3].length() > 0) {
                            usWeightClass = (int)Long.parseLong(parts[3], 16);
                        }
                        if (parts[4].length() > 0) {
                            sFamilyClass = (int)Long.parseLong(parts[4], 16);
                        }
                        int ulCodePageRange1 = (int)Long.parseLong(parts[5], 16);
                        int ulCodePageRange2 = (int)Long.parseLong(parts[6], 16);
                        if (parts[7].length() > 0) {
                            macStyle = (int)Long.parseLong(parts[7], 16);
                        }
                        if (parts[8].length() > 0) {
                            panose = new byte[10];
                            for (int i = 0; i < 10; ++i) {
                                String str = parts[8].substring(i * 2, i * 2 + 2);
                                int b = Integer.parseInt(str, 16);
                                panose[i] = (byte)(b & 0xFF);
                            }
                        }
                        fontFile = new File(parts[9]);
                        if (parts.length >= 12 && !parts[10].isEmpty() && !parts[11].isEmpty()) {
                            hash = parts[10];
                            lastModified = Long.parseLong(parts[11]);
                        }
                        if (fontFile.exists()) {
                            boolean keep;
                            boolean bl = keep = fontFile.lastModified() == lastModified;
                            if (!keep && !SKIP_CHECKSUMS) {
                                String newHash;
                                if (hash.equals(lastHash) && fontFile.equals(lastFile)) {
                                    newHash = lastHash;
                                } else {
                                    try {
                                        newHash = FileSystemFontProvider.computeHash(Files.newInputStream(fontFile.toPath(), new OpenOption[0]));
                                        lastFile = fontFile;
                                        lastHash = newHash;
                                    }
                                    catch (IOException ex) {
                                        LOG.debug((Object)("Error reading font file " + fontFile.getAbsolutePath()), (Throwable)ex);
                                        newHash = "<err>";
                                    }
                                }
                                if (hash.equals(newHash)) {
                                    keep = true;
                                    lastModified = fontFile.lastModified();
                                }
                            }
                            if (keep) {
                                FSFontInfo info = new FSFontInfo(fontFile, format, postScriptName, cidSystemInfo, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this, hash, lastModified);
                                results.add(info);
                                break block37;
                            } else {
                                LOG.debug((Object)("Font file " + fontFile.getAbsolutePath() + " is different"));
                                continue;
                            }
                        }
                        LOG.debug((Object)("Font file " + fontFile.getAbsolutePath() + " not found, skipped"));
                    }
                    pending.remove(fontFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Error loading font cache, will be re-built", (Throwable)e);
                return null;
            }
        }
        if (!pending.isEmpty()) {
            LOG.warn((Object)(pending.size() + " new fonts found, font cache will be re-built"));
            return null;
        }
        return results;
    }

    private void addTrueTypeCollection(File ttcFile) {
        try {
            String hash = SKIP_CHECKSUMS ? CHECKSUM_PLACEHOLDER : FileSystemFontProvider.computeHash(Files.newInputStream(ttcFile.toPath(), new OpenOption[0]));
            TrueTypeCollection.processAllFontHeaders(ttcFile, fontHeaders -> this.addTrueTypeFontImpl(fontHeaders, ttcFile, hash));
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not load font file: " + ttcFile), (Throwable)e);
            this.fontInfoList.add(this.createFSIgnored(ttcFile, FontFormat.TTF, "*skipexception*"));
        }
    }

    private void addTrueTypeFont(File ttfFile) {
        FontFormat fontFormat = null;
        try {
            TTFParser parser;
            if (ttfFile.getPath().toLowerCase().endsWith(".otf")) {
                fontFormat = FontFormat.OTF;
                parser = new OTFParser(false);
            } else {
                fontFormat = FontFormat.TTF;
                parser = new TTFParser(false);
            }
            FontHeaders headers = parser.parseTableHeaders(new RandomAccessReadBufferedFile(ttfFile));
            this.addTrueTypeFontImpl(headers, ttfFile, SKIP_CHECKSUMS ? CHECKSUM_PLACEHOLDER : FileSystemFontProvider.computeHash(Files.newInputStream(ttfFile.toPath(), new OpenOption[0])));
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not load font file: " + ttfFile), (Throwable)e);
            this.fontInfoList.add(this.createFSIgnored(ttfFile, fontFormat, "*skipexception*"));
        }
    }

    private void addTrueTypeFontImpl(FontHeaders fontHeaders, File file, String hash) {
        String error = fontHeaders.getError();
        if (error == null) {
            String name = fontHeaders.getName();
            if (name != null && name.contains("|")) {
                this.fontInfoList.add(this.createFSIgnored(file, FontFormat.TTF, "*skippipeinname*"));
                LOG.warn((Object)("Skipping font with '|' in name " + name + " in file " + file));
            } else if (name != null) {
                FontFormat format;
                Integer macStyle = fontHeaders.getHeaderMacStyle();
                if (macStyle == null) {
                    this.fontInfoList.add(this.createFSIgnored(file, FontFormat.TTF, name));
                    return;
                }
                int sFamilyClass = -1;
                int usWeightClass = -1;
                int ulCodePageRange1 = 0;
                int ulCodePageRange2 = 0;
                byte[] panose = null;
                OS2WindowsMetricsTable os2WindowsMetricsTable = fontHeaders.getOS2Windows();
                if (os2WindowsMetricsTable != null) {
                    sFamilyClass = os2WindowsMetricsTable.getFamilyClass();
                    usWeightClass = os2WindowsMetricsTable.getWeightClass();
                    ulCodePageRange1 = (int)os2WindowsMetricsTable.getCodePageRange1();
                    ulCodePageRange2 = (int)os2WindowsMetricsTable.getCodePageRange2();
                    panose = os2WindowsMetricsTable.getPanose();
                }
                CIDSystemInfo ros = null;
                if (fontHeaders.isOpenTypePostScript()) {
                    format = FontFormat.OTF;
                    String registry = fontHeaders.getOtfRegistry();
                    String ordering = fontHeaders.getOtfOrdering();
                    if (registry != null || ordering != null) {
                        ros = new CIDSystemInfo(registry, ordering, fontHeaders.getOtfSupplement());
                    }
                } else {
                    byte[] bytes = fontHeaders.getNonOtfTableGCID142();
                    if (bytes != null) {
                        String reg = new String(bytes, 10, 64, StandardCharsets.US_ASCII);
                        String registryName = reg.substring(0, reg.indexOf(0));
                        String ord = new String(bytes, 76, 64, StandardCharsets.US_ASCII);
                        String orderName = ord.substring(0, ord.indexOf(0));
                        int supplementVersion = bytes[140] << 8 & (bytes[141] & 0xFF);
                        ros = new CIDSystemInfo(registryName, orderName, supplementVersion);
                    }
                    format = FontFormat.TTF;
                }
                this.fontInfoList.add(new FSFontInfo(file, format, name, ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this, hash, file.lastModified()));
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(format.name() + ": '" + name + "' / '" + fontHeaders.getFontFamily() + "' / '" + fontHeaders.getFontSubFamily() + "'"));
                }
            } else {
                this.fontInfoList.add(this.createFSIgnored(file, FontFormat.TTF, "*skipnoname*"));
                LOG.warn((Object)("Missing 'name' entry for PostScript name in font " + file));
            }
        } else {
            this.fontInfoList.add(this.createFSIgnored(file, FontFormat.TTF, "*skipexception*"));
            LOG.warn((Object)("Could not load font file '" + file + "': " + error));
        }
    }

    private void addType1Font(File pfbFile) {
        try (FileInputStream input = new FileInputStream(pfbFile);){
            Type1Font type1 = Type1Font.createWithPFB(input);
            if (type1.getName() == null) {
                this.fontInfoList.add(this.createFSIgnored(pfbFile, FontFormat.PFB, "*skipnoname*"));
                LOG.warn((Object)("Missing 'name' entry for PostScript name in font " + pfbFile));
                return;
            }
            if (type1.getName().contains("|")) {
                this.fontInfoList.add(this.createFSIgnored(pfbFile, FontFormat.PFB, "*skippipeinname*"));
                LOG.warn((Object)("Skipping font with '|' in name " + type1.getName() + " in file " + pfbFile));
                return;
            }
            String hash = SKIP_CHECKSUMS ? CHECKSUM_PLACEHOLDER : FileSystemFontProvider.computeHash(Files.newInputStream(pfbFile.toPath(), new OpenOption[0]));
            this.fontInfoList.add(new FSFontInfo(pfbFile, FontFormat.PFB, type1.getName(), null, -1, -1, 0, 0, -1, null, this, hash, pfbFile.lastModified()));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("PFB: '" + type1.getName() + "' / '" + type1.getFamilyName() + "' / '" + type1.getWeight() + "'"));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not load font file: " + pfbFile), (Throwable)e);
        }
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        for (FSFontInfo info : this.fontInfoList) {
            sb.append((Object)info.getFormat());
            sb.append(": ");
            sb.append(info.getPostScriptName());
            sb.append(": ");
            sb.append(info.file.getPath());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public List<? extends FontInfo> getFontInfo() {
        return this.fontInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String computeHash(InputStream is) throws IOException {
        CRC32 crc = new CRC32();
        try {
            int readBytes;
            byte[] buffer = new byte[4096];
            while ((readBytes = is.read(buffer)) != -1) {
                crc.update(buffer, 0, readBytes);
            }
            long hash = crc.getValue();
            String string = Long.toHexString(hash);
            return string;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    private static class FSFontInfo
    extends FontInfo {
        private final String postScriptName;
        private final FontFormat format;
        private final CIDSystemInfo cidSystemInfo;
        private final int usWeightClass;
        private final int sFamilyClass;
        private final int ulCodePageRange1;
        private final int ulCodePageRange2;
        private final int macStyle;
        private final PDPanoseClassification panose;
        private final File file;
        private final FileSystemFontProvider parent;
        private final String hash;
        private final long lastModified;

        private FSFontInfo(File file, FontFormat format, String postScriptName, CIDSystemInfo cidSystemInfo, int usWeightClass, int sFamilyClass, int ulCodePageRange1, int ulCodePageRange2, int macStyle, byte[] panose, FileSystemFontProvider parent, String hash, long lastModified) {
            this.file = file;
            this.format = format;
            this.postScriptName = postScriptName;
            this.cidSystemInfo = cidSystemInfo;
            this.usWeightClass = usWeightClass;
            this.sFamilyClass = sFamilyClass;
            this.ulCodePageRange1 = ulCodePageRange1;
            this.ulCodePageRange2 = ulCodePageRange2;
            this.macStyle = macStyle;
            this.panose = panose != null && panose.length >= 10 ? new PDPanoseClassification(panose) : null;
            this.parent = parent;
            this.hash = hash;
            this.lastModified = lastModified;
        }

        @Override
        public String getPostScriptName() {
            return this.postScriptName;
        }

        @Override
        public FontFormat getFormat() {
            return this.format;
        }

        @Override
        public CIDSystemInfo getCIDSystemInfo() {
            return this.cidSystemInfo;
        }

        @Override
        public synchronized FontBoxFont getFont() {
            FontBoxFont font;
            FontBoxFont cached = this.parent.cache.getFont(this);
            if (cached != null) {
                return cached;
            }
            switch (this.format) {
                case PFB: {
                    font = this.getType1Font(this.postScriptName, this.file);
                    break;
                }
                case TTF: {
                    font = this.getTrueTypeFont(this.postScriptName, this.file);
                    break;
                }
                case OTF: {
                    font = this.getOTFFont(this.postScriptName, this.file);
                    break;
                }
                default: {
                    throw new RuntimeException("can't happen");
                }
            }
            if (font != null) {
                this.parent.cache.addFont(this, font);
            }
            return font;
        }

        @Override
        public int getFamilyClass() {
            return this.sFamilyClass;
        }

        @Override
        public int getWeightClass() {
            return this.usWeightClass;
        }

        @Override
        public int getCodePageRange1() {
            return this.ulCodePageRange1;
        }

        @Override
        public int getCodePageRange2() {
            return this.ulCodePageRange2;
        }

        @Override
        public int getMacStyle() {
            return this.macStyle;
        }

        @Override
        public PDPanoseClassification getPanose() {
            return this.panose;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.file + " " + this.hash + " " + this.lastModified;
        }

        private TrueTypeFont getTrueTypeFont(String postScriptName, File file) {
            try {
                TrueTypeFont ttf = this.readTrueTypeFont(postScriptName, file);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                return ttf;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }

        private TrueTypeFont readTrueTypeFont(String postScriptName, File file) throws IOException {
            if (file.getName().toLowerCase().endsWith(".ttc")) {
                TrueTypeFont ttf;
                TrueTypeCollection ttc = new TrueTypeCollection(file);
                try {
                    ttf = ttc.getFontByName(postScriptName);
                }
                catch (IOException ex) {
                    ttc.close();
                    throw ex;
                }
                if (ttf == null) {
                    ttc.close();
                    throw new IOException("Font " + postScriptName + " not found in " + file);
                }
                return ttf;
            }
            TTFParser ttfParser = new TTFParser(false);
            return ttfParser.parse(new RandomAccessReadBufferedFile(file));
        }

        private OpenTypeFont getOTFFont(String postScriptName, File file) {
            try {
                if (file.getName().toLowerCase().endsWith(".ttc")) {
                    TrueTypeFont ttf;
                    TrueTypeCollection ttc = new TrueTypeCollection(file);
                    try {
                        ttf = ttc.getFontByName(postScriptName);
                    }
                    catch (IOException ex) {
                        LOG.error((Object)ex.getMessage(), (Throwable)ex);
                        ttc.close();
                        return null;
                    }
                    if (ttf == null) {
                        ttc.close();
                        throw new IOException("Font " + postScriptName + " not found in " + file);
                    }
                    return (OpenTypeFont)ttf;
                }
                OTFParser parser = new OTFParser(false);
                OpenTypeFont otf = parser.parse(new RandomAccessReadBufferedFile(file));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                return otf;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Type1Font getType1Font(String postScriptName, File file) {
            try (FileInputStream input = new FileInputStream(file);){
                Type1Font type1 = Type1Font.createWithPFB(input);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                Type1Font type1Font = type1;
                return type1Font;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }
    }
}

