/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.api.data;

import com.impossibl.postgres.utils.guava.Preconditions;
import com.impossibl.postgres.utils.guava.Strings;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ACLItem {
    public static final String ALL_PRIVILEGES = "arwdDxtXUCTc";
    public static final char[] ALL_PRIVILEGE_CHARS = "arwdDxtXUCTc".toCharArray();
    public static final Right[] ALL_RIGHTS = ACLItem._rightsOf("arwdDxtXUCTc");
    private String user;
    private Right[] rights;
    private String grantor;
    private static final Pattern ACL_PATTERN = Pattern.compile("(.*)=((?:\\w\\*?)*)/(.*)");

    public static boolean isPrivilege(char ch) {
        for (int c = 0; c < ALL_PRIVILEGE_CHARS.length; ++c) {
            if (ALL_PRIVILEGE_CHARS[c] != ch) continue;
            return true;
        }
        return false;
    }

    public static Right[] rightsOf(String rightsOrPrivileges) throws ParseException {
        if (rightsOrPrivileges == null) {
            return null;
        }
        ArrayList<Right> rights = new ArrayList<Right>();
        for (int c = 0; c < rightsOrPrivileges.length(); ++c) {
            char privilege = rightsOrPrivileges.charAt(c);
            if (!ACLItem.isPrivilege(privilege)) {
                throw new ParseException("Invalid rights strings, unrecognized privilege", c);
            }
            boolean grantOption = false;
            int nc = c + 1;
            if (nc < rightsOrPrivileges.length() && rightsOrPrivileges.charAt(nc) == '*') {
                ++c;
                grantOption = true;
            }
            rights.add(new Right(privilege, grantOption));
        }
        return rights.toArray(new Right[0]);
    }

    private static Right[] _rightsOf(String rightsOrPrivileges) {
        try {
            return ACLItem.rightsOf(rightsOrPrivileges);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static char[] privilegesOf(Right[] rights) {
        if (rights == null) {
            return null;
        }
        char[] privileges = new char[rights.length];
        for (int c = 0; c < rights.length; ++c) {
            privileges[c] = rights[c].privilege;
        }
        return privileges;
    }

    public ACLItem(String user, String rightsOrPrivileges, String grantor) {
        this(user, ACLItem._rightsOf(rightsOrPrivileges), grantor);
    }

    public ACLItem(String user, Right[] rights, String grantor) {
        this.user = user;
        this.rights = rights;
        this.grantor = grantor;
    }

    private ACLItem() {
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPrivileges() {
        char[] privileges = ACLItem.privilegesOf(this.rights);
        if (privileges == null) {
            return null;
        }
        return new String(privileges);
    }

    public void setPrivileges(String privileges) {
        try {
            this.setRights(privileges);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Right[] getRights() {
        return this.rights;
    }

    public void setRights(Right[] rights) {
        this.rights = rights;
    }

    public void setRights(String rights) throws ParseException {
        this.rights = ACLItem.rightsOf(rights);
    }

    public String getGrantor() {
        return this.grantor;
    }

    public void setGrantor(String grantor) {
        this.grantor = grantor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.user != null && !this.user.equals("PUBLIC")) {
            sb.append(this.user);
        }
        sb.append('=');
        if (this.rights != null) {
            for (Right right : this.rights) {
                sb.append(right);
            }
        }
        sb.append('/');
        if (this.grantor != null) {
            sb.append(this.grantor);
        }
        return sb.toString();
    }

    public static ACLItem parse(String aclItemStr) throws ParseException {
        ACLItem aclItem = null;
        Matcher aclMatcher = ACL_PATTERN.matcher(aclItemStr);
        if (aclMatcher.matches()) {
            aclItem = new ACLItem();
            aclItem.user = aclMatcher.group(1);
            if (Strings.isNullOrEmpty(aclItem.user)) {
                aclItem.user = "PUBLIC";
            }
            aclItem.rights = ACLItem.rightsOf(aclMatcher.group(2));
            aclItem.grantor = aclMatcher.group(3);
        }
        return aclItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ACLItem aclItem = (ACLItem)o;
        return Objects.equals(this.user, aclItem.user) && Arrays.equals(this.rights, aclItem.rights) && Objects.equals(this.grantor, aclItem.grantor);
    }

    public int hashCode() {
        int result = Objects.hash(this.user, this.grantor);
        result = 31 * result + Arrays.hashCode(this.rights);
        return result;
    }

    public static class Right {
        private char privilege;
        private boolean grantOption;

        public Right(char privilege, boolean grantOption) {
            Preconditions.checkArgument(ACLItem.isPrivilege(privilege));
            this.privilege = privilege;
            this.grantOption = grantOption;
        }

        public char getPrivilege() {
            return this.privilege;
        }

        public boolean isGrantOption() {
            return this.grantOption;
        }

        public String toString() {
            return this.privilege + (this.grantOption ? "*" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Right right = (Right)o;
            return this.privilege == right.privilege && this.grantOption == right.grantOption;
        }

        public int hashCode() {
            return Objects.hash(Character.valueOf(this.privilege), this.grantOption);
        }
    }
}

