/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.DataSourceSettings;
import com.impossibl.postgres.system.Setting;
import java.util.function.Function;

interface DataSourceSettingsInit {
    public static void init() {
        DataSourceSettings.DS.init("jdbc-ds", "JDBC DataSource Settings", true);
        DataSourceSettings.DATASOURCE_NAME.init("jdbc-ds", "Name of data source.", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"data-source.name", "dataSourceName"});
        DataSourceSettings.SERVER_NAME.init("jdbc-ds", "Host name for TCP connections.", String.class, "localhost", Setting.Converter.identity(), Function.identity(), new String[]{"server.name", "serverName"});
        DataSourceSettings.PORT_NUMBER.init("jdbc-ds", "Port number for TCP connections.", Integer.class, "5432", str -> DataSourceSettingsInit.checkRange("port.number", Integer.parseInt(str), 1, 65535), Object::toString, new String[]{"port.number", "portNumber"});
        DataSourceSettings.LOCAL_SERVER_NAME.init("jdbc-ds", "Unix socket name for local server connections.", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"server.local-name", "localServerName"});
        DataSourceSettings.SERVER_ADDRESSES.init("jdbc-ds", "Comma separated list of server addresses for which a connection will be attempted in order.\n\nSupports providing DNS, IPv4, IPv6 & Unix socket addresses. DNS & IP addresses are specified in `host[:port]?` format while Unix socket addresses must contain a `/` to valid. Additionally IPv6 host names must be enclosed in `[]`.\n\nNOTE: Specifying a list of addresses takes precedence over `server.name`, `port.number` & `server.local-name' and will cause those settings to be ignored.", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"server.addresses", "serverAddresses"});
        DataSourceSettings.LOGIN_TIMEOUT.init("jdbc-ds", "Maximum time to wait for a connection to be established.", Integer.class, "0", str -> DataSourceSettingsInit.checkRange("login.timeout", Integer.parseInt(str), 0, null), Object::toString, new String[]{"login.timeout", "loginTimeout"});
    }

    public static Integer checkRange(String name, Integer value, Integer min, Integer max) {
        if (min != null && value < min) {
            throw new IllegalArgumentException("Setting '" + name + "' is below minimum value of " + min);
        }
        if (max != null && value > max) {
            throw new IllegalArgumentException("Setting '" + name + "' is above maximum value of " + max);
        }
        return value;
    }
}

