/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.JDBCTypeMapping;
import com.impossibl.postgres.jdbc.JDBCTypeMetaData;
import com.impossibl.postgres.system.CustomTypes;
import com.impossibl.postgres.types.Type;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.Map;

public class PGParameterMetaData
implements ParameterMetaData {
    private Type[] parameterTypes;
    private Map<String, Class<?>> typeMap;

    PGParameterMetaData(Type[] parameterTypes, Map<String, Class<?>> typeMap) {
        this.parameterTypes = parameterTypes;
        this.typeMap = typeMap;
    }

    private void checkParamIndex(int paramIndex) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.parameterTypes.length) {
            throw Exceptions.PARAMETER_INDEX_OUT_OF_BOUNDS;
        }
    }

    private Type getType(int paramIndex) throws SQLException {
        this.checkParamIndex(paramIndex);
        return this.parameterTypes[paramIndex - 1];
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        Type paramType = this.getType(param);
        return paramType.isNullable() != null ? (paramType.isNullable().booleanValue() ? 1 : 0) : 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        Type type = this.getType(param);
        return JDBCTypeMetaData.isSigned(type);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        Type paramType = this.getType(param);
        return JDBCTypeMetaData.getPrecision(paramType, 0, 0);
    }

    @Override
    public int getScale(int param) throws SQLException {
        Type paramType = this.getType(param);
        return JDBCTypeMetaData.getScale(paramType, 0);
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        Type paramType = this.getType(param);
        return JDBCTypeMapping.getJDBCTypeCode(paramType);
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        Type paramType = this.getType(param);
        return paramType.getName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        Type paramType = this.getType(param);
        Class<?> defaultClass = paramType.getCodec(paramType.getParameterFormat()).getDecoder().getDefaultClass();
        Class<?> paramClass = CustomTypes.lookupCustomType(paramType, this.typeMap, defaultClass);
        return paramClass.getName();
    }

    @Override
    public int getParameterMode(int param) {
        return 1;
    }
}

