/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.Await;
import com.impossibl.postgres.utils.BlockingReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class RequestExecutorHandlers {

    public static class CompositeQueryResults
    extends SynchronizedResult
    implements RequestExecutor.QueryHandler {
        private List<ResultBatch> resultBatches = new ArrayList<ResultBatch>();

        public List<ResultBatch> getBatches() {
            return this.resultBatches;
        }

        @Override
        public void handleComplete(String command, Long rowsAffected, Long insertedOid, TypeRef[] parameterTypes, ResultField[] resultFields, RowDataSet rows, List<Notice> notices) {
            this.resultBatches.add(new ResultBatch(command, rowsAffected, insertedOid, resultFields, ReferenceCountUtil.retain(rows)));
            this.notices.addAll(notices);
        }
    }

    public static class ExecuteResult
    extends AnyQueryResult
    implements RequestExecutor.ExecuteHandler {
        private boolean synced;
        private boolean suspended;
        private ResultField[] describedResultFields;
        private ResultBatch resultBatch;

        public ExecuteResult(ResultField[] describedResultFields) {
            this(true, describedResultFields);
        }

        public ExecuteResult(boolean synced, ResultField[] describedResultFields) {
            this.synced = synced;
            this.describedResultFields = describedResultFields;
        }

        @Override
        public boolean isSuspended() {
            return this.suspended;
        }

        @Override
        public ResultBatch getBatch() {
            this.checkCompleted();
            return this.resultBatch;
        }

        @Override
        public void handleComplete(String command, Long rowsAffected, Long insertedOid, RowDataSet rows, List<Notice> notices) {
            this.resultBatch = new ResultBatch(command, rowsAffected, insertedOid, this.describedResultFields, ReferenceCountUtil.retain(rows));
            this.notices = notices;
            if (!this.synced) {
                this.completed.countDown();
            }
        }

        @Override
        public void handleSuspend(RowDataSet rows, List<Notice> notices) {
            this.resultBatch = new ResultBatch(null, null, null, this.describedResultFields, ReferenceCountUtil.retain(rows));
            this.suspended = true;
            this.completed.countDown();
        }
    }

    public static class QueryResult
    extends AnyQueryResult
    implements RequestExecutor.ExtendedQueryHandler {
        private boolean synced;
        private boolean suspended;
        private ResultBatch resultBatch;

        public QueryResult() {
            this(true);
        }

        public QueryResult(boolean synced) {
            this.synced = synced;
        }

        @Override
        public boolean isSuspended() {
            return this.suspended;
        }

        @Override
        public ResultBatch getBatch() {
            this.checkCompleted();
            return this.resultBatch;
        }

        @Override
        public void handleComplete(String command, Long rowsAffected, Long insertedOid, TypeRef[] parameterTypes, ResultField[] resultFields, RowDataSet rows, List<Notice> notices) {
            this.resultBatch = new ResultBatch(command, rowsAffected, insertedOid, resultFields, ReferenceCountUtil.retain(rows));
            this.notices = notices;
            if (!this.synced) {
                this.completed.countDown();
            }
        }

        @Override
        public void handleSuspend(TypeRef[] parameterTypes, ResultField[] resultFields, RowDataSet rows, List<Notice> notices) {
            this.resultBatch = new ResultBatch(null, null, null, resultFields, ReferenceCountUtil.retain(rows));
            this.notices = notices;
            this.suspended = true;
            this.completed.countDown();
        }
    }

    public static abstract class AnyQueryResult
    extends SynchronizedResult {
        public abstract boolean isSuspended();

        public abstract ResultBatch getBatch();
    }

    public static class PrepareResult
    extends Result
    implements RequestExecutor.PrepareHandler {
        private TypeRef[] describedParameterTypes;
        private ResultField[] describedResultFields;

        public Type[] getDescribedParameterTypes(Context context) throws IOException {
            this.checkCompleted();
            ArrayList<Type> list = new ArrayList<Type>();
            for (TypeRef ref : this.describedParameterTypes) {
                Type resolve = context.getRegistry().resolve(ref);
                list.add(resolve);
            }
            return list.toArray(new Type[0]);
        }

        public ResultField[] getDescribedResultFields() {
            this.checkCompleted();
            return this.describedResultFields;
        }

        @Override
        public void handleComplete(TypeRef[] parameterTypes, ResultField[] resultFields, List<Notice> notices) {
            this.describedParameterTypes = parameterTypes;
            this.describedResultFields = resultFields;
            this.notices = notices;
            this.completed.countDown();
        }
    }

    public static class SynchronizedResult
    extends Result
    implements RequestExecutor.SynchronizedHandler {
        @Override
        public void handleReady(TransactionStatus transactionStatus) {
            this.completed.countDown();
        }
    }

    public static abstract class Result
    implements RequestExecutor.ErrorHandler {
        protected Throwable error;
        protected List<Notice> notices = new ArrayList<Notice>();
        protected CountDownLatch completed = new CountDownLatch(1);

        public boolean isValid() {
            this.checkCompleted();
            return this.error != null;
        }

        public Throwable getError() {
            this.checkCompleted();
            return this.error;
        }

        public List<Notice> getNotices() {
            this.checkCompleted();
            return this.notices;
        }

        @Override
        public void handleError(Throwable error, List<Notice> notices) {
            this.error = error;
            this.notices = notices;
            this.completed.countDown();
        }

        public boolean isCompleted() {
            try {
                return this.completed.await(0L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignored) {
                return false;
            }
        }

        void checkCompleted() {
            try {
                if (this.completed.await(0L, TimeUnit.SECONDS)) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new IllegalStateException("Result has not completed.");
        }

        private void rethrowError() throws IOException {
            if (this.error == null) {
                return;
            }
            if (this.error instanceof IOException) {
                throw (IOException)this.error;
            }
            if (this.error instanceof RuntimeException) {
                throw (RuntimeException)this.error;
            }
            throw new RuntimeException(this.error);
        }

        public void await(long timeout, TimeUnit unit) throws IOException {
            if (!Await.awaitUninterruptibly(timeout, unit, this.completed::await)) {
                throw new BlockingReadTimeoutException();
            }
            this.rethrowError();
        }
    }
}

