/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.sasl.scram.gssapi;

import com.impossibl.postgres.protocol.sasl.scram.ScramAttributes;
import com.impossibl.postgres.protocol.sasl.scram.gssapi.Gs2CbindFlag;
import com.impossibl.postgres.protocol.sasl.scram.util.CharAttribute;

public enum Gs2Attributes implements CharAttribute
{
    CLIENT_NOT(Gs2CbindFlag.DISABLED.getChar()),
    CLIENT_YES_SERVER_NOT(Gs2CbindFlag.NO_SERVER_SUPPORT.getChar()),
    CHANNEL_BINDING_REQUIRED(Gs2CbindFlag.ENABLED.getChar()),
    AUTHZID(ScramAttributes.AUTHZID.getChar());

    private final char flag;

    private Gs2Attributes(char flag) {
        this.flag = flag;
    }

    @Override
    public char getChar() {
        return this.flag;
    }

    public static Gs2Attributes byChar(char c) {
        switch (c) {
            case 'n': {
                return CLIENT_NOT;
            }
            case 'y': {
                return CLIENT_YES_SERVER_NOT;
            }
            case 'p': {
                return CHANNEL_BINDING_REQUIRED;
            }
            case 'a': {
                return AUTHZID;
            }
        }
        throw new IllegalArgumentException("Invalid GS2Attribute character '" + c + "'");
    }

    public static Gs2Attributes byGS2CbindFlag(Gs2CbindFlag cbindFlag) {
        return Gs2Attributes.byChar(cbindFlag.getChar());
    }
}

