/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.NoticeException;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FunctionCallRequest
implements ServerRequest {
    private int functionId;
    private FieldFormatRef[] parameterFormats;
    private ByteBuf[] parameterBuffers;
    private RequestExecutor.FunctionCallHandler handler;
    private List<Notice> notices;

    public FunctionCallRequest(int functionId, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers, RequestExecutor.FunctionCallHandler handler) {
        this.functionId = functionId;
        this.parameterFormats = parameterFormats;
        this.parameterBuffers = parameterBuffers;
        this.handler = handler;
        this.notices = new ArrayList<Notice>();
    }

    @Override
    public ProtocolHandler createHandler() {
        return new Handler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeFunctionCall(this.functionId, this.parameterFormats, this.parameterBuffers).flush();
    }

    private class Handler
    implements ProtocolHandler.FunctionResult,
    ProtocolHandler.CommandError,
    ProtocolHandler.ReportNotice {
        private Handler() {
        }

        public String toString() {
            return "Function Call";
        }

        @Override
        public ProtocolHandler.Action notice(Notice notice) {
            FunctionCallRequest.this.notices.add(notice);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action functionResult(ByteBuf value) {
            FunctionCallRequest.this.handler.handleComplete(value, FunctionCallRequest.this.notices);
            return ProtocolHandler.Action.Sync;
        }

        @Override
        public ProtocolHandler.Action error(Notice error) throws IOException {
            FunctionCallRequest.this.handler.handleError(new NoticeException(error), FunctionCallRequest.this.notices);
            return ProtocolHandler.Action.Sync;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            FunctionCallRequest.this.handler.handleError(cause, FunctionCallRequest.this.notices);
        }
    }
}

