/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import io.netty.channel.EventLoopGroup;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ServerConnectionShared {
    private static Map<Class<? extends EventLoopGroup>, ServerConnectionShared> instances = new HashMap<Class<? extends EventLoopGroup>, ServerConnectionShared>();
    private Class<? extends EventLoopGroup> eventLoopGroupType;
    private int maxThreads;
    private EventLoopGroup eventLoopGroup;
    private int count = 0;

    static synchronized Ref acquire(Class<? extends EventLoopGroup> eventLoopGroupType, int maxThreads) {
        return instances.computeIfAbsent(eventLoopGroupType, key -> new ServerConnectionShared(eventLoopGroupType, maxThreads)).addReference();
    }

    private ServerConnectionShared(Class<? extends EventLoopGroup> eventLoopGroupType, int maxThreads) {
        this.eventLoopGroupType = eventLoopGroupType;
        this.maxThreads = maxThreads;
    }

    EventLoopGroup getEventLoopGroup() {
        if (this.eventLoopGroup != null) {
            return this.eventLoopGroup;
        }
        NamedThreadFactory threadFactory = new NamedThreadFactory("PG-JDBC I/O");
        try {
            Constructor<? extends EventLoopGroup> constructor = this.eventLoopGroupType.getConstructor(Integer.TYPE, ThreadFactory.class);
            this.eventLoopGroup = constructor.newInstance(this.maxThreads, threadFactory);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unsupported event loop group type: " + this.eventLoopGroupType.getSimpleName());
        }
        return this.eventLoopGroup;
    }

    private synchronized Ref addReference() {
        ++this.count;
        return new Ref();
    }

    private synchronized void release() {
        if (this.count == 1) {
            this.shutdown();
            this.count = 0;
        } else {
            --this.count;
        }
    }

    private Future<?> shutdown() {
        if (this.eventLoopGroup == null) {
            return ImmediateEventExecutor.INSTANCE.newSucceededFuture(null);
        }
        Future<?> res = this.eventLoopGroup.shutdownGracefully(10L, 100L, TimeUnit.MILLISECONDS);
        this.eventLoopGroup = null;
        return res;
    }

    public static void waitForShutdown() {
        Collection shutdowns = instances.values().stream().map(ServerConnectionShared::shutdown).collect(Collectors.toList());
        shutdowns.forEach(shutdown -> shutdown.awaitUninterruptibly(150L, TimeUnit.MILLISECONDS));
        Thread deathThread = new Thread(() -> {
            try {
                ThreadDeathWatcher.awaitInactivity(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Thread globalThread = new Thread(() -> {
            try {
                GlobalEventExecutor.INSTANCE.awaitInactivity(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        try {
            globalThread.join(TimeUnit.SECONDS.toMillis(5L));
            deathThread.join(TimeUnit.SECONDS.toMillis(5L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public class Ref {
        private AtomicBoolean released = new AtomicBoolean(false);

        public ServerConnectionShared get() {
            return ServerConnectionShared.this;
        }

        public void release() {
            if (this.released.getAndSet(true)) {
                return;
            }
            ServerConnectionShared.this.release();
        }
    }

    private class NamedThreadFactory
    implements ThreadFactory {
        private String baseName;
        private AtomicInteger idx = new AtomicInteger(1);

        NamedThreadFactory(String baseName) {
            this.baseName = baseName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.baseName + " (" + this.idx.getAndIncrement() + ")");
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

