/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.procs.AutoConvertingDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;

abstract class AutoConvertingBinaryDecoder<N>
extends BaseBinaryDecoder
implements AutoConvertingDecoder {
    private AutoConvertingDecoder.Converter<N> converter;

    protected AutoConvertingBinaryDecoder(Integer requiredLength) {
        this(requiredLength, (AutoConvertingDecoder.Converter)null);
    }

    protected AutoConvertingBinaryDecoder(Function<N, String> converter) {
        this(null, new AutoConvertingDecoder.ToStringConverter<N>(converter));
    }

    protected AutoConvertingBinaryDecoder(AutoConvertingDecoder.Converter<N> converter) {
        this(null, converter);
    }

    protected AutoConvertingBinaryDecoder(Integer requiredLength, Function<N, String> converter) {
        this(requiredLength, new AutoConvertingDecoder.ToStringConverter<N>(converter));
    }

    protected AutoConvertingBinaryDecoder(Integer requiredLength, AutoConvertingDecoder.Converter<N> converter) {
        super(requiredLength);
        this.converter = converter;
    }

    protected Object convertOutput(Context context, N decoded, Class<?> targetClass, Object targetContext) throws IOException {
        if (targetClass.isInstance(decoded)) {
            return targetClass.cast(decoded);
        }
        return this.converter.convert(context, decoded, targetClass, targetContext);
    }

    private boolean isBinary(Class<?> type) {
        return type == InputStream.class || type == byte[].class;
    }

    @Override
    protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
        if (this.isBinary(targetClass)) {
            int length = buffer.readableBytes();
            if (this.shouldRespectMaxLength()) {
                Integer maxLength = context.getSetting(SystemSettings.FIELD_LENGTH_MAX);
                length = maxLength != null ? Integer.min(maxLength, length) : length;
            }
            Object binaryResult = null;
            if (targetClass == InputStream.class) {
                binaryResult = new ByteBufInputStream(buffer.readRetainedSlice(length), true);
            } else if (targetClass == byte[].class) {
                byte[] bytes = new byte[length];
                buffer.readBytes(bytes);
                binaryResult = bytes;
            }
            return binaryResult;
        }
        N decoded = this.decodeNativeValue(context, type, typeLength, typeModifier, buffer, targetClass, targetContext);
        Object converted = this.convertOutput(context, decoded, targetClass, targetContext);
        if (converted == null) {
            throw new ConversionException("Unable to convert value to " + targetClass);
        }
        return converted;
    }

    @Override
    public abstract Class<N> getDefaultClass();

    protected abstract N decodeNativeValue(Context var1, Type var2, Short var3, Integer var4, ByteBuf var5, Class<?> var6, Object var7) throws IOException;
}

