/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryEncoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextEncoder;
import com.impossibl.postgres.system.procs.Bytes;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;

public class Bits
extends SimpleProcProvider {
    public Bits() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "bit_", "varbit_");
    }

    static boolean[] convertInput(Context context, Object source, Object sourceContext) throws ConversionException {
        if (source instanceof BitSet) {
            BitSet val = (BitSet)source;
            boolean[] res = new boolean[val.size()];
            for (int bitIdx = 0; bitIdx < res.length; ++bitIdx) {
                res[bitIdx] = val.get(bitIdx);
            }
            return res;
        }
        if (source instanceof Boolean) {
            return new boolean[]{(Boolean)source};
        }
        if (source instanceof Byte) {
            Byte val = (Byte)source;
            return new boolean[]{val != 0};
        }
        if (source instanceof Short) {
            Short val = (Short)source;
            return new boolean[]{val != 0};
        }
        if (source instanceof Integer) {
            Integer val = (Integer)source;
            return new boolean[]{val != 0};
        }
        if (source instanceof Long) {
            Long val = (Long)source;
            return new boolean[]{val != 0L};
        }
        if (source instanceof Float) {
            Float val = (Float)source;
            return new boolean[]{(double)val.floatValue() != 0.0};
        }
        if (source instanceof Double) {
            Double val = (Double)source;
            return new boolean[]{val != 0.0};
        }
        if (source instanceof BigDecimal) {
            BigDecimal val = (BigDecimal)source;
            return new boolean[]{val.compareTo(BigDecimal.ZERO) != 0};
        }
        if (source instanceof String) {
            return Bits.bitStringToBools((String)source);
        }
        return null;
    }

    static Object convertOutput(Context context, boolean[] decoded, Class<?> targetClass, Object targetContext) throws ConversionException {
        if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
            return decoded[0];
        }
        if (targetClass == Byte.class || targetClass == Byte.TYPE) {
            return decoded[0] ? (byte)1 : 0;
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            return decoded[0] ? (short)1 : 0;
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            return decoded[0] ? 1 : 0;
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            return decoded[0] ? 1L : 0L;
        }
        if (targetClass == BigInteger.class) {
            return decoded[0] ? BigInteger.ONE : BigInteger.ZERO;
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            return Float.valueOf(decoded[0] ? 1.0f : 0.0f);
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return decoded[0] ? 1.0 : 0.0;
        }
        if (targetClass == String.class) {
            StringBuilder val = new StringBuilder();
            Bits.boolsToBitString(decoded, val);
            return val.toString();
        }
        return null;
    }

    private static void boolsToBitString(boolean[] bits, Appendable out) throws ConversionException {
        try {
            for (boolean bit : bits) {
                out.append(bit ? (char)'1' : '0');
            }
        }
        catch (IOException e) {
            throw new ConversionException("Error converting bits");
        }
    }

    private static boolean[] bitStringToBools(String val) throws ConversionException {
        if (val.length() == 0) {
            return new boolean[0];
        }
        switch (val.charAt(0)) {
            case 'B': 
            case 'b': {
                return Bits.binaryBitStringToBools(val.substring(1));
            }
            case 'X': 
            case 'x': {
                return Bits.bytesToBools(Bytes.decodeHex(val.substring(1)));
            }
        }
        return Bits.binaryBitStringToBools(val);
    }

    private static boolean[] bytesToBools(byte[] bytes) {
        BitSet bitSet = BitSet.valueOf(bytes);
        boolean[] bits = new boolean[bytes.length * 8];
        for (int c = 0; c < bits.length; ++c) {
            bits[bits.length - c - 1] = bitSet.get(c);
        }
        return bits;
    }

    private static boolean[] binaryBitStringToBools(String val) throws ConversionException {
        boolean[] bits = new boolean[val.length()];
        for (int c = 0; c < val.length(); ++c) {
            char cur = val.charAt(c);
            if (cur != '1' && cur != '0') {
                throw new ConversionException("'" + cur + "' is not a valid binary digit");
            }
            bits[c] = cur == '1';
        }
        return bits;
    }

    static class TxtEncoder
    extends AutoConvertingTextEncoder<boolean[]> {
        TxtEncoder() {
            super(Bits::convertInput);
        }

        @Override
        protected Class<boolean[]> getDefaultClass() {
            return boolean[].class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, boolean[] value, Object sourceContext, StringBuilder buffer) throws IOException {
            Bits.boolsToBitString(value, buffer);
        }
    }

    static class TxtDecoder
    extends AutoConvertingTextDecoder<boolean[]> {
        TxtDecoder() {
            super(Bits::convertOutput);
        }

        @Override
        public Class<boolean[]> getDefaultClass() {
            return boolean[].class;
        }

        @Override
        protected boolean[] decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            boolean[] bits = new boolean[buffer.length()];
            int sz = buffer.length();
            block4: for (int c = 0; c < sz; ++c) {
                switch (buffer.charAt(c)) {
                    case '0': {
                        bits[c] = false;
                        continue block4;
                    }
                    case '1': {
                        bits[c] = true;
                        continue block4;
                    }
                    default: {
                        throw new ConversionException("'" + buffer.charAt(c) + "' is not a valid binary digit");
                    }
                }
            }
            return bits;
        }
    }

    static class BinEncoder
    extends AutoConvertingBinaryEncoder<boolean[]> {
        BinEncoder() {
            super(Bits::convertInput);
        }

        @Override
        protected Class<boolean[]> getDefaultClass() {
            return boolean[].class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, boolean[] value, Object sourceContext, ByteBuf buffer) throws IOException {
            int bitCount = value.length;
            int byteCount = (bitCount + 7) / 8;
            byte[] bytes = new byte[byteCount];
            for (int c = 0; c < bitCount; ++c) {
                int n = c / 8;
                bytes[n] = (byte)(bytes[n] | 128 >> c % 8 & (value[c] ? 255 : 0));
            }
            buffer.writeInt(bitCount);
            buffer.writeBytes(bytes);
        }
    }

    static class BinDecoder
    extends AutoConvertingBinaryDecoder<boolean[]> {
        BinDecoder() {
            super(Bits::convertOutput);
        }

        @Override
        public Class<boolean[]> getDefaultClass() {
            return boolean[].class;
        }

        @Override
        protected boolean[] decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Integer lenMod;
            int bitCount = buffer.readInt();
            if (typeModifier != null && (lenMod = (Integer)type.getModifierParser().parse(typeModifier.intValue()).get("length")) > 0) {
                bitCount = lenMod;
            }
            int byteCount = (bitCount + 7) / 8;
            byte[] bytes = new byte[byteCount];
            buffer.readBytes(bytes);
            boolean[] bits = new boolean[bitCount];
            for (int c = 0; c < bitCount; ++c) {
                bits[c] = (bytes[c / 8] & 128 >> c % 8) != 0;
            }
            return bits;
        }
    }
}

