/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryEncoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.Strings;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.ByteBufs;
import com.impossibl.postgres.utils.TypeLiteral;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class HStores
extends SimpleProcProvider {
    public HStores() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "hstore_");
    }

    private static Map<String, String> newMap(int size) {
        return new HashMap<String, String>(Math.max(2, size));
    }

    static class TxtEncoder
    extends AutoConvertingTextEncoder<Map<String, String>> {
        protected TxtEncoder() {
            super((String x$0) -> TxtDecoder.parse(x$0));
        }

        @Override
        public Class<Map<String, String>> getDefaultClass() {
            return new TypeLiteral<Map<String, String>>(){}.getRawType();
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Map<String, String> value, Object sourceContext, StringBuilder buffer) throws IOException {
            if (value.isEmpty()) {
                return;
            }
            for (Map.Entry<String, String> e : value.entrySet()) {
                TxtEncoder.appendEscaped(buffer, e.getKey());
                buffer.append("=>");
                TxtEncoder.appendEscaped(buffer, e.getValue());
                buffer.append(", ");
            }
            buffer.setLength(buffer.length() - 2);
        }

        private static void appendEscaped(StringBuilder sb, Object val) {
            if (val != null) {
                sb.append('\"');
                String s = val.toString();
                for (int pos = 0; pos < s.length(); ++pos) {
                    char ch = s.charAt(pos);
                    if (ch == '\"' || ch == '\\') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                }
                sb.append('\"');
            } else {
                sb.append("NULL");
            }
        }
    }

    static class TxtDecoder
    extends AutoConvertingTextDecoder<Map<String, String>> {
        TxtDecoder() {
            super(Object::toString);
        }

        @Override
        public Class<Map<String, String>> getDefaultClass() {
            return new TypeLiteral<Map<String, String>>(){}.getRawType();
        }

        @Override
        protected Map<String, String> decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return TxtDecoder.parse(buffer);
        }

        private static Map<String, String> parse(CharSequence buffer) {
            Map m = HStores.newMap(10);
            String s = buffer.toString();
            StringBuilder sb = new StringBuilder();
            for (int pos = 0; pos < buffer.length(); ++pos) {
                String val;
                sb.setLength(0);
                int start = s.indexOf(34, pos);
                int end = TxtDecoder.appendUntilQuote(sb, s, start);
                String key = sb.toString();
                pos = end + 3;
                if (s.charAt(pos) == 'N') {
                    val = null;
                    pos += 4;
                } else {
                    sb.setLength(0);
                    end = TxtDecoder.appendUntilQuote(sb, s, pos);
                    val = sb.toString();
                    pos = end;
                }
                m.put(key, val);
            }
            return m;
        }

        private static int appendUntilQuote(StringBuilder sb, String s, int pos) {
            char ch;
            ++pos;
            while (pos < s.length() && (ch = s.charAt(pos)) != '\"') {
                if (ch == '\\') {
                    ch = s.charAt(++pos);
                }
                sb.append(ch);
                ++pos;
            }
            return pos;
        }
    }

    static class BinEncoder
    extends AutoConvertingBinaryEncoder<Map<String, String>> {
        BinEncoder() {
            super((String x$0) -> TxtDecoder.parse(x$0));
        }

        @Override
        public Class<Map<String, String>> getDefaultClass() {
            return new TypeLiteral<Map<String, String>>(){}.getRawType();
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Map<String, String> value, Object sourceContext, ByteBuf buffer) throws IOException {
            Type textType = context.getRegistry().loadBaseType("text");
            buffer.writeInt(value.size());
            for (Map.Entry<String, String> e : value.entrySet()) {
                ByteBufs.lengthEncodeBinary(Strings.BINARY_ENCODER, context, textType, e.getKey(), null, buffer);
                ByteBufs.lengthEncodeBinary(Strings.BINARY_ENCODER, context, textType, e.getValue(), null, buffer);
            }
        }
    }

    static class BinDecoder
    extends AutoConvertingBinaryDecoder<Map<String, String>> {
        BinDecoder() {
            super(Object::toString);
        }

        @Override
        public Class<Map<String, String>> getDefaultClass() {
            return new TypeLiteral<Map<String, String>>(){}.getRawType();
        }

        @Override
        protected Map<String, String> decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Type textType = context.getRegistry().loadBaseType("text");
            int numElements = buffer.readInt();
            Map m = HStores.newMap(numElements);
            for (int i = 0; i < numElements; ++i) {
                String key = (String)ByteBufs.lengthDecodeBinary(Strings.BINARY_DECODER, context, textType, textType.getLength(), null, buffer, String.class, null);
                String val = (String)ByteBufs.lengthDecodeBinary(Strings.BINARY_DECODER, context, textType, textType.getLength(), null, buffer, String.class, null);
                m.put(key, val);
            }
            return m;
        }
    }
}

