/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.Arrays;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.Joiner;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class Int2Vectors
extends SimpleProcProvider {
    public Int2Vectors() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "int2vector");
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            Object[] items;
            if (value instanceof short[]) {
                short[] values = (short[])value;
                items = new String[values.length];
                for (int c = 0; c < values.length; ++c) {
                    items[c] = Short.toString(values[c]);
                }
            } else if (value instanceof Short[]) {
                Short[] values = (Short[])value;
                items = new String[values.length];
                for (int c = 0; c < values.length; ++c) {
                    items[c] = Short.toString(values[c]);
                }
            } else {
                throw new ConversionException(value.getClass(), type);
            }
            Joiner.on(' ').appendTo(buffer, items);
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Short[].class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            int length = buffer.length();
            Short[] values = null;
            if (length != 0) {
                String[] items = buffer.toString().split(" ");
                values = new Short[items.length];
                for (int c = 0; c < items.length; ++c) {
                    values[c] = Short.valueOf(items[c]);
                }
            }
            return values;
        }
    }

    static class BinEncoder
    extends Arrays.BinEncoder {
        BinEncoder() {
        }
    }

    static class BinDecoder
    extends Arrays.BinDecoder {
        BinDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Short[].class;
        }
    }
}

