/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.ServerInfo;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SettingSelectProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

public class TimesWithoutTZ
extends SettingSelectProcProvider {
    public TimesWithoutTZ() {
        super(ServerInfo::hasIntegerDateTimes, new TxtEncoder(), new TxtDecoder(), new BinEncoder(), new BinDecoder(), new TxtEncoder(), new TxtDecoder(), null, null, "time_");
    }

    private static LocalTime convertInput(Context context, Type type, Object value, Calendar sourceCalendar) throws ConversionException {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof CharSequence) {
            CharSequence chars = (CharSequence)value;
            TemporalAccessor parsed = context.getClientTimeFormat().getParser().parse(chars);
            ZoneOffset offset = ZoneOffset.ofTotalSeconds((int)TimeUnit.MILLISECONDS.toSeconds(sourceCalendar.getTimeZone().getRawOffset()));
            if (parsed.isSupported(ChronoField.OFFSET_SECONDS)) {
                return OffsetTime.from(parsed).withOffsetSameInstant(offset).toLocalTime();
            }
            return LocalTime.from(parsed).atOffset(offset).toLocalTime();
        }
        if (value instanceof Time) {
            Time t = (Time)value;
            return Instant.ofEpochMilli(t.getTime()).atZone(sourceCalendar.getTimeZone().toZoneId()).toLocalTime();
        }
        if (value instanceof Date) {
            Date d = (Date)value;
            return Instant.ofEpochMilli(d.getTime()).atZone(sourceCalendar.getTimeZone().toZoneId()).toLocalTime();
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            return ts.toInstant().atZone(sourceCalendar.getTimeZone().toZoneId()).toLocalTime();
        }
        throw new ConversionException(value.getClass(), type);
    }

    private static Object convertOutput(Context context, Type type, LocalTime time, Class<?> targetClass, Calendar targetCalendar) throws ConversionException {
        if (targetClass == LocalTime.class) {
            return time;
        }
        if (targetClass == OffsetTime.class) {
            ZoneOffset offset = ZoneOffset.ofTotalSeconds((int)TimeUnit.MILLISECONDS.toSeconds(targetCalendar.getTimeZone().getRawOffset()));
            return time.atOffset(offset);
        }
        if (targetClass == String.class) {
            return context.getClientTimeFormat().getPrinter().format(time);
        }
        if (targetClass == Time.class) {
            LocalDate date = LocalDate.of(1970, 1, 1);
            OffsetDateTime dateTime = date.atTime(time).atZone(targetCalendar.getTimeZone().toZoneId()).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
            return new Time(dateTime.toInstant().toEpochMilli());
        }
        if (targetClass == Timestamp.class) {
            LocalDate date = LocalDate.of(1970, 1, 1);
            ZonedDateTime dateTime = date.atTime(time).atZone(targetCalendar.getTimeZone().toZoneId());
            return Timestamp.from(dateTime.toInstant());
        }
        throw new ConversionException(type, targetClass);
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            Calendar calendar = sourceContext != null ? (Calendar)sourceContext : Calendar.getInstance();
            LocalTime time = TimesWithoutTZ.convertInput(context, type, value, calendar);
            String strVal = context.getServerTimeFormat().getPrinter().format(time);
            buffer.append(strVal);
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Time.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Calendar calendar = targetContext != null ? (Calendar)targetContext : Calendar.getInstance();
            TemporalAccessor parsed = context.getServerTimeFormat().getParser().parse(buffer);
            LocalTime time = LocalTime.from(parsed);
            return TimesWithoutTZ.convertOutput(context, type, time, targetClass, calendar);
        }
    }

    private static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
            super(8);
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            Calendar calendar = sourceContext != null ? (Calendar)sourceContext : Calendar.getInstance();
            LocalTime time = TimesWithoutTZ.convertInput(context, type, value, calendar);
            long micros = TimeUnit.NANOSECONDS.toMicros(time.toNanoOfDay() + 500L) % TimeUnit.DAYS.toMicros(1L);
            buffer.writeLong(micros);
        }
    }

    private static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
            super(8);
        }

        @Override
        public Class<?> getDefaultClass() {
            return Time.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Calendar calendar = targetContext != null ? (Calendar)targetContext : Calendar.getInstance();
            long micros = buffer.readLong();
            LocalTime time = LocalTime.ofNanoOfDay(TimeUnit.MICROSECONDS.toNanos(micros));
            return TimesWithoutTZ.convertOutput(context, type, time, targetClass, calendar);
        }
    }
}

