/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.jdbc.Query;
import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.RequestExecutorHandlers;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultBatches;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.utils.Nulls;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DirectQuery
implements Query {
    private String sql;
    private FieldFormatRef[] parameterFormats;
    private ByteBuf[] parameterBuffers;
    private FieldFormatRef[] resultFieldFormats;
    private String portalName;
    private Query.Status status;
    private Long timeout;
    private int maxRows;
    private List<ResultBatch> resultBatches;
    private ResultField[] suspendedResultFields;

    DirectQuery(String sql, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers, FieldFormatRef[] resultFieldFormats) {
        this.sql = sql;
        this.parameterFormats = parameterFormats;
        this.parameterBuffers = parameterBuffers;
        this.resultFieldFormats = resultFieldFormats;
        this.status = Query.Status.Initialized;
        this.resultBatches = new ArrayList<ResultBatch>();
    }

    @Override
    public Query.Status getStatus() {
        return this.status;
    }

    @Override
    public Long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public List<ResultBatch> getResultBatches() {
        return this.resultBatches;
    }

    private boolean requiresPortal() {
        return this.maxRows > 0;
    }

    private boolean hasParameters() {
        return this.parameterBuffers != null && this.parameterBuffers.length != 0;
    }

    private SQLWarning executeSimple(PGDirectConnection connection, String sql) throws SQLException {
        this.portalName = null;
        RequestExecutorHandlers.CompositeQueryResults results = connection.executeTimed(this.timeout, timeout -> {
            RequestExecutorHandlers.CompositeQueryResults handler = new RequestExecutorHandlers.CompositeQueryResults();
            connection.getRequestExecutor().query(sql, handler);
            handler.await(timeout, TimeUnit.MILLISECONDS);
            return handler;
        });
        this.resultBatches = results.getBatches();
        try {
            for (ResultBatch resultBatch : this.resultBatches) {
                ResultBatches.transformFieldTypes(resultBatch, connection.getRegistry()::resolve);
            }
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
        return ErrorUtils.chainWarnings(null, results);
    }

    private SQLWarning executeExtended(PGDirectConnection connection, String sql) throws SQLException {
        this.portalName = this.requiresPortal() ? connection.getNextPortalName() : null;
        RequestExecutorHandlers.QueryResult result = connection.executeTimed(this.timeout, timeout -> {
            RequestExecutorHandlers.QueryResult handler = new RequestExecutorHandlers.QueryResult(!this.requiresPortal());
            connection.getRequestExecutor().query(sql, this.portalName, this.parameterFormats, this.parameterBuffers, this.resultFieldFormats, this.maxRows, handler);
            handler.await(timeout, TimeUnit.MILLISECONDS);
            return handler;
        });
        if (result.isSuspended()) {
            this.suspendedResultFields = result.getBatch().getFields();
        }
        return this.applyExecuteResult(connection, result);
    }

    private SQLWarning resumeExtended(PGDirectConnection connection) throws SQLException {
        RequestExecutorHandlers.ExecuteResult result = connection.executeTimed(this.timeout, timeout -> {
            RequestExecutorHandlers.ExecuteResult handler = new RequestExecutorHandlers.ExecuteResult(false, this.suspendedResultFields);
            connection.getRequestExecutor().resume(this.portalName, Nulls.firstNonNull(this.maxRows, 0), handler);
            handler.await(timeout, TimeUnit.MILLISECONDS);
            return handler;
        });
        return this.applyExecuteResult(connection, result);
    }

    private SQLWarning applyExecuteResult(PGDirectConnection connection, RequestExecutorHandlers.AnyQueryResult result) throws SQLException {
        ResultBatch resultBatch = result.getBatch();
        try {
            ResultBatches.transformFieldTypes(resultBatch, connection.getRegistry()::resolve);
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
        this.resultBatches = new ArrayList<ResultBatch>(Collections.singletonList(resultBatch));
        if (result.isSuspended()) {
            this.status = Query.Status.Suspended;
        } else if (this.portalName != null) {
            this.dispose(connection);
        }
        return ErrorUtils.chainWarnings(null, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning execute(PGDirectConnection connection) throws SQLException {
        boolean wasSuspended = this.status == Query.Status.Suspended;
        this.status = Query.Status.InProgress;
        try {
            if (wasSuspended) {
                if (this.portalName == null) {
                    throw new PGSQLSimpleException("Illegal query state - suspended with no portal");
                }
                if (this.suspendedResultFields == null) {
                    throw new PGSQLSimpleException("Illegal query state - suspended with no previous results");
                }
                SQLWarning sQLWarning = this.resumeExtended(connection);
                return sQLWarning;
            }
            if (this.requiresPortal() || this.hasParameters()) {
                SQLWarning sQLWarning = this.executeExtended(connection, this.sql);
                return sQLWarning;
            }
            SQLWarning sQLWarning = this.executeSimple(connection, this.sql);
            return sQLWarning;
        }
        finally {
            if (this.status == Query.Status.InProgress) {
                this.status = Query.Status.Completed;
            }
        }
    }

    @Override
    public void dispose(PGDirectConnection connection) throws SQLException {
        if (this.portalName != null) {
            connection.execute((long timeout) -> {
                RequestExecutorHandlers.SynchronizedResult finish = new RequestExecutorHandlers.SynchronizedResult();
                connection.getRequestExecutor().finish(this.portalName, finish);
                finish.await(timeout, TimeUnit.MILLISECONDS);
            });
        }
        this.portalName = null;
    }

    public String toString() {
        return "DirectQuery{sql='" + this.sql + '\'' + ", portalName='" + this.portalName + '\'' + ", status=" + (Object)((Object)this.status) + '}';
    }
}

