/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.api.jdbc.PGType;
import com.impossibl.postgres.jdbc.JDBCTypeMapping;
import com.impossibl.postgres.types.Type;
import java.util.Map;

class JDBCTypeMetaData {
    JDBCTypeMetaData() {
    }

    static boolean requiresQuoting(Type type) {
        int sqlType = JDBCTypeMapping.getJDBCTypeCode(type);
        switch (sqlType) {
            case -6: 
            case -5: 
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    static boolean isCurrency(Type type) {
        return PGType.valueOf(type.unwrap()) == PGType.MONEY;
    }

    static boolean isCaseSensitive(Type type) {
        switch (type.getCategory()) {
            case Enumeration: 
            case String: {
                return true;
            }
        }
        return false;
    }

    static boolean isSigned(Type type) {
        return type.unwrap().getCategory() == Type.Category.Numeric;
    }

    static String getTypeName(Type type, String attributeDefaultValue) {
        if (type.isAutoIncrement() || Type.isAutoIncrement(attributeDefaultValue)) {
            if (PGType.valueOf(type) == PGType.INT4) {
                return "serial";
            }
            if (PGType.valueOf(type) == PGType.INT8) {
                return "bigserial";
            }
        }
        return type.getName();
    }

    static int getPrecisionRadix(Type type) {
        switch (type.unwrap().getCategory()) {
            case Numeric: {
                return 10;
            }
            case BitString: {
                return 2;
            }
        }
        return 0;
    }

    static int getMaxPrecision(Type type) {
        PGType pgType = PGType.valueOf(type = type.unwrap());
        if (pgType == null) {
            return 0;
        }
        switch (pgType) {
            case NUMERIC: {
                return 1000;
            }
            case TIME: 
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIMEZONE: 
            case INTERVAL: {
                return 6;
            }
            case CHAR: 
            case NAME: 
            case BPCHAR: 
            case BIT: {
                return type.getLength() != null ? (int)type.getLength().shortValue() : 0;
            }
        }
        return 0;
    }

    static int getPrecision(Type type, int typeLength, int typeModifier) {
        int prec;
        type = type.unwrap();
        Map<String, Object> mods = type.getModifierParser().parse(typeModifier);
        int precMod = -1;
        if (mods.containsKey("precision")) {
            precMod = (Integer)mods.get("precision");
        }
        int lenMod = -1;
        if (mods.containsKey("length")) {
            lenMod = (Integer)mods.get("length");
        } else if (typeLength != -1) {
            lenMod = typeLength;
        }
        PGType pgType = PGType.valueOf(type);
        if (pgType == null) {
            prec = lenMod;
        } else {
            switch (pgType) {
                case INT2: {
                    prec = 5;
                    break;
                }
                case INT4: 
                case OID: {
                    prec = 10;
                    break;
                }
                case INT8: 
                case MONEY: {
                    prec = 19;
                    break;
                }
                case FLOAT4: {
                    prec = 8;
                    break;
                }
                case FLOAT8: {
                    prec = 17;
                    break;
                }
                case NUMERIC: {
                    if (precMod != 0) {
                        prec = precMod;
                        break;
                    }
                    prec = 131072;
                    break;
                }
                case TIME: 
                case TIME_WITH_TIMEZONE: 
                case TIMESTAMP: 
                case TIMESTAMP_WITH_TIMEZONE: 
                case DATE: {
                    prec = JDBCTypeMetaData.calculateDateTimeDisplaySize(pgType, precMod);
                    break;
                }
                case INTERVAL: {
                    prec = 49;
                    break;
                }
                case CHAR: 
                case NAME: 
                case BPCHAR: 
                case BIT: 
                case TEXT: 
                case VARCHAR: 
                case CSTRING: 
                case VARBIT: {
                    prec = lenMod;
                    break;
                }
                case BOOL: {
                    prec = 1;
                    break;
                }
                case UUID: {
                    prec = 36;
                    break;
                }
                default: {
                    prec = lenMod;
                }
            }
        }
        return prec;
    }

    static int getMinScale(Type type) {
        PGType pgType = PGType.valueOf(type.unwrap());
        if (pgType == null) {
            return 0;
        }
        if (pgType == PGType.MONEY) {
            return 2;
        }
        return 0;
    }

    static int getMaxScale(Type type) {
        PGType pgType = PGType.valueOf(type.unwrap());
        if (pgType == null) {
            return 0;
        }
        if (pgType == PGType.NUMERIC) {
            return 1000;
        }
        return 0;
    }

    static int getScale(Type type, int typeModifier) {
        PGType pgType = PGType.valueOf(type.unwrap());
        if (pgType == null) {
            return 0;
        }
        Map<String, Object> mods = type.getModifierParser().parse(typeModifier);
        int scaleMod = -1;
        if (mods.get("scale") != null) {
            scaleMod = (Integer)mods.get("scale");
        }
        int scale = 0;
        switch (pgType) {
            case FLOAT4: {
                scale = 8;
                break;
            }
            case FLOAT8: {
                scale = 17;
                break;
            }
            case NUMERIC: {
                scale = scaleMod;
                break;
            }
            case TIME: 
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIMEZONE: {
                int precMod = -1;
                if (mods.get("precision") != null) {
                    precMod = (Integer)mods.get("precision");
                }
                if (precMod == -1) {
                    scale = 6;
                    break;
                }
                scale = precMod;
                break;
            }
            case INTERVAL: {
                scale = scaleMod == -1 ? 6 : scaleMod;
            }
        }
        return scale;
    }

    static int getDisplaySize(Type type, int typeLength, int typeModifier) {
        int size;
        type = type.unwrap();
        Map<String, Object> mods = type.getModifierParser().parse(typeModifier);
        int precMod = -1;
        if (mods.containsKey("precision")) {
            precMod = (Integer)mods.get("precision");
        }
        int lenMod = -1;
        if (mods.containsKey("length")) {
            lenMod = (Integer)mods.get("length");
        } else if (typeLength != -1) {
            lenMod = typeLength;
        }
        switch (type.getCategory()) {
            case Numeric: {
                if (precMod == -1) {
                    size = 131089;
                    break;
                }
                int prec = JDBCTypeMetaData.getPrecision(type, typeLength, typeModifier);
                int scale = JDBCTypeMetaData.getScale(type, typeModifier);
                size = prec + (scale != 0 ? 1 : 0) + 1;
                break;
            }
            case Boolean: {
                size = 5;
                break;
            }
            case Enumeration: 
            case String: 
            case BitString: {
                if (lenMod == -1) {
                    size = Integer.MAX_VALUE;
                    break;
                }
                size = lenMod;
                break;
            }
            case DateTime: {
                size = JDBCTypeMetaData.calculateDateTimeDisplaySize(PGType.valueOf(type), precMod);
                break;
            }
            case Timespan: {
                size = 49;
                break;
            }
            default: {
                size = Integer.MAX_VALUE;
            }
        }
        return size;
    }

    private static int calculateDateTimeDisplaySize(PGType pgType, int precision) {
        int size;
        if (pgType == null) {
            return 0;
        }
        block0 : switch (pgType) {
            case DATE: {
                size = 13;
                break;
            }
            case TIME: 
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIMEZONE: {
                int secondSize;
                switch (precision) {
                    case -1: {
                        secondSize = 7;
                        break;
                    }
                    case 0: {
                        secondSize = 0;
                        break;
                    }
                    case 1: {
                        secondSize = 3;
                        break;
                    }
                    default: {
                        secondSize = precision + 1;
                    }
                }
                switch (pgType) {
                    case TIME: {
                        size = 8 + secondSize;
                        break block0;
                    }
                    case TIME_WITH_TIMEZONE: {
                        size = 8 + secondSize + 6;
                        break block0;
                    }
                    case TIMESTAMP: {
                        size = 22 + secondSize;
                        break block0;
                    }
                    case TIMESTAMP_WITH_TIMEZONE: {
                        size = 22 + secondSize + 6;
                        break block0;
                    }
                }
                size = 0;
                break;
            }
            default: {
                size = 0;
            }
        }
        return size;
    }
}

