/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.ListScroller;
import com.impossibl.postgres.jdbc.PGResultSet;
import com.impossibl.postgres.jdbc.Query;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowDataSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

class QueryScroller
extends ListScroller {
    private PGResultSet resultSet;
    private int resultsIndexOffset;
    private Query query;

    QueryScroller(PGResultSet resultSet, Query query, ResultField[] resultFields, RowDataSet results) {
        super(resultFields, results, true);
        this.resultSet = resultSet;
        this.query = query;
    }

    @Override
    void close() throws SQLException {
        super.close();
        this.query.dispose(this.resultSet.statement.connection);
    }

    @Override
    int getType() {
        return 1003;
    }

    @Override
    public int getRow() {
        if (!this.isValidRow()) {
            return 0;
        }
        return this.resultsIndexOffset + this.currentRowIndex + 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return super.isBeforeFirst() && this.resultsIndexOffset == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return super.isAfterLast() && this.query.getStatus() == Query.Status.Completed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return super.isFirst() && this.resultsIndexOffset == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return super.isLast() && this.query.getStatus() == Query.Status.Completed;
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public void afterLast() throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public boolean first() throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public boolean last() throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }

    @Override
    public boolean next() throws SQLException {
        if (Math.min(++this.currentRowIndex, this.results.size()) == this.results.size() && this.query != null && this.query.getStatus() != Query.Status.Completed) {
            Integer fetchSize = this.resultSet.fetchSize();
            if (fetchSize != null) {
                this.query.setMaxRows(fetchSize);
            }
            SQLWarning warningChain = this.query.execute(this.resultSet.statement.connection);
            this.resultSet.addWarnings(warningChain);
            List<ResultBatch> resultBatches = this.query.getResultBatches();
            if (resultBatches.size() != 1) {
                throw new SQLException("Invalid result data");
            }
            try (ResultBatch resultBatch = resultBatches.remove(0);){
                this.resultFields = resultBatch.getFields();
                this.setResults(resultBatch.takeRows());
                this.resultsIndexOffset += this.currentRowIndex;
                this.currentRowIndex = -1;
                boolean bl = this.next();
                return bl;
            }
        }
        return this.isValidRow();
    }

    @Override
    boolean previous() throws SQLException {
        throw Exceptions.CURSOR_NOT_SCROLLABLE;
    }
}

