/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.ServerInfo;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.DatesTimes;
import com.impossibl.postgres.system.procs.SettingSelectProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

public class TimestampsWithTZ
extends SettingSelectProcProvider {
    public TimestampsWithTZ() {
        super(ServerInfo::hasIntegerDateTimes, new TxtEncoder(), new TxtDecoder(), new BinEncoder(), new BinDecoder(), new TxtEncoder(), new TxtDecoder(), null, null, "timestamptz_");
    }

    private static OffsetDateTime convertInput(Context context, Type type, Object value, Calendar sourceCalendar) throws ConversionException {
        if (value instanceof OffsetDateTime) {
            return (OffsetDateTime)value;
        }
        if (value instanceof CharSequence) {
            CharSequence chars = (CharSequence)value;
            if (value.equals("infinity")) {
                return OffsetDateTime.MAX;
            }
            if (value.equals("-infinity")) {
                return OffsetDateTime.MIN;
            }
            TemporalAccessor parsed = context.getClientTimestampFormat().getParser().parse(chars);
            if (parsed.isSupported(ChronoField.OFFSET_SECONDS)) {
                return OffsetDateTime.from(parsed);
            }
            return LocalDateTime.from(parsed).atZone(sourceCalendar.getTimeZone().toZoneId()).toOffsetDateTime();
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            if (ts.getTime() == 9223372036825200000L) {
                return OffsetDateTime.MAX;
            }
            if (ts.getTime() == -9223372036832400000L) {
                return OffsetDateTime.MIN;
            }
            return ts.toInstant().atZone(sourceCalendar.getTimeZone().toZoneId()).toOffsetDateTime();
        }
        if (value instanceof Time) {
            Time t = (Time)value;
            if (t.getTime() == 9223372036825200000L) {
                return OffsetDateTime.MAX;
            }
            if (t.getTime() == -9223372036832400000L) {
                return OffsetDateTime.MIN;
            }
            return Instant.ofEpochMilli(t.getTime()).atZone(sourceCalendar.getTimeZone().toZoneId()).toOffsetDateTime();
        }
        if (value instanceof Date) {
            Date d = (Date)value;
            if (d.getTime() == 9223372036825200000L) {
                return OffsetDateTime.MAX;
            }
            if (d.getTime() == -9223372036832400000L) {
                return OffsetDateTime.MIN;
            }
            return Instant.ofEpochMilli(d.getTime()).atZone(sourceCalendar.getTimeZone().toZoneId()).toOffsetDateTime();
        }
        throw new ConversionException(value.getClass(), type);
    }

    private static Object convertInfinityOutput(boolean positive, Type type, Class<?> targetClass) throws ConversionException {
        if (targetClass == OffsetDateTime.class) {
            return positive ? OffsetDateTime.MAX : OffsetDateTime.MIN;
        }
        if (targetClass == String.class) {
            return positive ? "infinity" : "-infinity";
        }
        if (targetClass == Time.class) {
            return new Time(positive ? 9223372036825200000L : -9223372036832400000L);
        }
        if (targetClass == Date.class) {
            return new Date(positive ? 9223372036825200000L : -9223372036832400000L);
        }
        if (targetClass == Timestamp.class) {
            return new Timestamp(positive ? 9223372036825200000L : -9223372036832400000L);
        }
        throw new ConversionException(type, targetClass);
    }

    private static Object convertOutput(Context context, Type type, ZonedDateTime dateTime, Class<?> targetClass, Calendar targetCalendar) throws ConversionException {
        if (targetClass == OffsetDateTime.class) {
            return dateTime.toOffsetDateTime();
        }
        if (targetClass == String.class) {
            return context.getClientTimestampFormat().getPrinter().format(dateTime);
        }
        ZoneId targetZoneId = targetCalendar.getTimeZone().toZoneId();
        ZonedDateTime zonedDateTime = dateTime.withZoneSameInstant(targetZoneId);
        if (targetClass == Time.class) {
            return new Time(zonedDateTime.withYear(1970).withDayOfYear(1).toInstant().toEpochMilli());
        }
        if (targetClass == Date.class) {
            return new Date(zonedDateTime.truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli());
        }
        if (targetClass == Timestamp.class) {
            return Timestamp.from(zonedDateTime.toInstant());
        }
        throw new ConversionException(type, targetClass);
    }

    private static class TxtEncoder
    extends BaseTextEncoder {
        private TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            Calendar calendar = sourceContext != null ? (Calendar)sourceContext : Calendar.getInstance();
            OffsetDateTime dateTime = TimestampsWithTZ.convertInput(context, type, value, calendar);
            if (dateTime.equals(OffsetDateTime.MAX)) {
                buffer.append("infinity");
            } else if (dateTime.equals(OffsetDateTime.MIN)) {
                buffer.append("-infinity");
            } else {
                String strVal = context.getServerTimestampFormat().getPrinter().format(dateTime);
                buffer.append(strVal);
            }
        }
    }

    private static class TxtDecoder
    extends BaseTextDecoder {
        private TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Timestamp.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Calendar calendar;
            Calendar calendar2 = calendar = targetContext != null ? (Calendar)targetContext : Calendar.getInstance();
            if (buffer.equals("infinity") || buffer.equals("-infinity")) {
                return TimestampsWithTZ.convertInfinityOutput(buffer.equals("infinity"), type, targetClass);
            }
            TemporalAccessor parsed = context.getServerTimestampFormat().getParser().parse(buffer);
            ZonedDateTime dateTime = parsed.isSupported(ChronoField.OFFSET_SECONDS) ? OffsetDateTime.from(parsed).toZonedDateTime().withZoneSameInstant(DatesTimes.UTC_ID) : LocalDateTime.from(parsed).atZone(calendar.getTimeZone().toZoneId());
            return TimestampsWithTZ.convertOutput(context, type, dateTime, targetClass, calendar);
        }
    }

    private static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
            super(8);
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            long micros;
            Calendar calendar = sourceContext != null ? (Calendar)sourceContext : Calendar.getInstance();
            OffsetDateTime dateTime = TimestampsWithTZ.convertInput(context, type, value, calendar);
            if (dateTime.equals(OffsetDateTime.MAX)) {
                micros = Long.MAX_VALUE;
            } else if (dateTime.equals(OffsetDateTime.MIN)) {
                micros = Long.MIN_VALUE;
            } else {
                long seconds = DatesTimes.javaEpochToPg(dateTime.toEpochSecond(), TimeUnit.SECONDS);
                micros = TimeUnit.SECONDS.toMicros(seconds) + TimeUnit.NANOSECONDS.toMicros(dateTime.getNano() + 500);
            }
            buffer.writeLong(micros);
        }
    }

    private static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
            super(8);
        }

        @Override
        public Class<?> getDefaultClass() {
            return Timestamp.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Calendar calendar = targetContext != null ? (Calendar)targetContext : Calendar.getInstance();
            long micros = buffer.readLong();
            if (micros == Long.MAX_VALUE || micros == Long.MIN_VALUE) {
                return TimestampsWithTZ.convertInfinityOutput(micros == Long.MAX_VALUE, type, targetClass);
            }
            micros = DatesTimes.pgEpochToJava(micros, TimeUnit.MICROSECONDS);
            long secs = TimeUnit.MICROSECONDS.toSeconds(micros);
            long nanos = TimeUnit.MICROSECONDS.toNanos(micros % TimeUnit.SECONDS.toMicros(1L));
            if (nanos < 0L) {
                nanos += TimeUnit.SECONDS.toNanos(1L);
                --secs;
            }
            ZonedDateTime dateTime = Instant.ofEpochSecond(secs, (int)nanos).atZone(context.getTimeZoneId());
            return TimestampsWithTZ.convertOutput(context, type, dateTime, targetClass, calendar);
        }
    }
}

