/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.tables;

import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.system.BasicContext;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.system.tables.Tables;
import java.io.IOException;
import java.util.List;

public interface Table<R extends Row> {
    public String getSQL(Version var1);

    public R createRow(Context var1, ResultBatch var2, int var3) throws IOException;

    default public List<R> query(BasicContext context, String queryTxt, long timeout, Object ... params) throws IOException {
        try (ResultBatch resultBatch = context.queryBatchPrepared(queryTxt, params, timeout);){
            List list = Tables.convertRows(context, this, resultBatch);
            return list;
        }
    }

    public static <T> T getFieldOfRow(ResultBatch resultBatch, int rowIdx, int fieldIdx, Context context, Class<T> targetType) throws IOException {
        return targetType.cast(resultBatch.borrowRows().borrow(rowIdx).getField(fieldIdx, resultBatch.getFields()[fieldIdx], context, targetType, null));
    }

    public static interface Row {
        public void load(Context var1, ResultBatch var2, int var3) throws IOException;
    }
}

