/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.tables;

import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultBatches;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.UnsupportedServerVersion;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.system.tables.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Tables {
    public static String getSQL(Object[] sqlData, Version currentVersion) {
        try {
            for (int c = 0; c < sqlData.length; c += 2) {
                Version curSqlVersion = (Version)sqlData[c];
                String curSql = (String)sqlData[c + 1];
                if (!currentVersion.isMinimum(curSqlVersion)) continue;
                return curSql;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Misconfigured system table type ");
        }
        throw new UnsupportedServerVersion(currentVersion);
    }

    public static <R extends Table.Row, T extends Table<R>> List<R> convertRows(Context context, T table, ResultBatch results) throws IOException {
        ResultBatches.transformFieldTypes(results, context.getRegistry()::resolve);
        int rowCount = results.borrowRows().size();
        ArrayList<R> rows = new ArrayList<R>(rowCount);
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            rows.add(table.createRow(context, results, rowIdx));
        }
        return rows;
    }
}

