/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTransforms {
    private static final Pattern CAPITALIZED_WORDS_PATTERN = Pattern.compile("[A-Z][^A-Z]*");
    private static final Pattern WORD_BREAKS_PATTERN = Pattern.compile("[^.\\-_ ]+");

    public static String dashedFromCamelCase(String val) {
        return StringTransforms.fromCamelCase(val, '-');
    }

    public static String dottedFromCamelCase(String val) {
        return StringTransforms.fromCamelCase(val, '.');
    }

    public static String fromCamelCase(String val, char separator) {
        StringBuilder newVal = new StringBuilder();
        boolean first = true;
        Matcher matcher = CAPITALIZED_WORDS_PATTERN.matcher(val);
        while (matcher.find()) {
            String group = matcher.group(0);
            if (first) {
                if (matcher.start() != 0) {
                    newVal.append(val, 0, matcher.start());
                    newVal.append(separator);
                }
            } else {
                newVal.append(separator);
            }
            newVal.append(group.toLowerCase());
            first = false;
        }
        return newVal.toString();
    }

    public static String dashedFromSnakeCase(String val) {
        return StringTransforms.fromSnakeCase(val, '-');
    }

    public static String fromSnakeCase(String val, char separator) {
        return val.toLowerCase().replace('_', separator);
    }

    public static String toUpperSnakeCase(String val) {
        StringBuilder newVal = new StringBuilder();
        boolean first = true;
        Matcher matcher = WORD_BREAKS_PATTERN.matcher(val);
        while (matcher.find()) {
            String group = matcher.group(0);
            if (!first) {
                newVal.append("_");
            }
            first = false;
            newVal.append(group.toUpperCase());
        }
        return newVal.toString();
    }

    public static String toUpperCamelCase(String val) {
        return StringTransforms.capitalizeGroups(val, true);
    }

    public static String toLowerCamelCase(String val) {
        return StringTransforms.capitalizeGroups(val, false);
    }

    public static String capitalizeGroups(String val, boolean capitalizeFirstWord) {
        StringBuilder newVal = new StringBuilder();
        boolean first = !capitalizeFirstWord;
        Matcher matcher = WORD_BREAKS_PATTERN.matcher(val);
        while (matcher.find()) {
            String group = matcher.group(0);
            if (!first) {
                newVal.appendCodePoint(Character.toUpperCase(group.codePointAt(0))).append(group.substring(1));
            } else {
                newVal.append(group);
            }
            first = false;
        }
        return newVal.toString();
    }

    public static String capitalize(String val) {
        return val.substring(0, 1).toUpperCase() + val.substring(1);
    }
}

