/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pool;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.PlatformDependent;
import io.vertx.core.net.impl.pool.Executor;
import io.vertx.core.net.impl.pool.Task;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class CombinerExecutor<S>
implements Executor<S> {
    private final Queue<Executor.Action<S>> q = PlatformDependent.newMpscQueue();
    private final AtomicInteger s = new AtomicInteger();
    private final S state;
    private static final FastThreadLocal<InProgressTail<?>> current = new FastThreadLocal();

    public CombinerExecutor(S state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Executor.Action<S> action) {
        block25: {
            this.q.add(action);
            if (this.s.get() != 0 || !this.s.compareAndSet(0, 1)) {
                return;
            }
            Task head = null;
            Task tail = null;
            block9: do {
                try {
                    while (true) {
                        Executor.Action<S> a;
                        if ((a = this.q.poll()) == null) {
                            continue block9;
                        }
                        Task task = a.execute(this.state);
                        if (task == null) continue;
                        Task last = task.last();
                        if (head == null) {
                            assert (tail == null);
                            tail = last;
                            head = task;
                            continue;
                        }
                        tail.next(task);
                        tail = last;
                    }
                }
                finally {
                    this.s.set(0);
                }
            } while (!this.q.isEmpty() && this.s.compareAndSet(0, 1));
            if (head != null) {
                InProgressTail<Object> inProgress = current.get();
                if (inProgress == null) {
                    inProgress = new InProgressTail(this, tail);
                    current.set(inProgress);
                    try {
                        head.runNextTasks();
                        assert (inProgress.others == null || inProgress.others.isEmpty());
                        break block25;
                    }
                    finally {
                        current.remove();
                    }
                }
                if (inProgress.combiner == this) {
                    Task oldNextTail = inProgress.task.replaceNext(head);
                    assert (oldNextTail == null);
                    inProgress.task = tail;
                } else {
                    Task task;
                    Map map = inProgress.others;
                    if (map == null) {
                        inProgress.others = new HashMap(1);
                        map = inProgress.others;
                    }
                    if ((task = map.get(this)) == null) {
                        map.put(this, tail);
                        try {
                            head.runNextTasks();
                        }
                        finally {
                            map.remove(this);
                        }
                    } else {
                        Task oldNextTail = task.replaceNext(head);
                        assert (oldNextTail == null);
                        map.put(this, tail);
                    }
                }
            }
        }
    }

    protected static final class InProgressTail<S> {
        final CombinerExecutor<S> combiner;
        Task task;
        Map<CombinerExecutor<S>, Task> others;

        public InProgressTail(CombinerExecutor<S> combiner, Task task) {
            this.combiner = combiner;
            this.task = task;
        }
    }
}

