/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServer;
import org.apache.camel.support.CamelContextHelper;

public class VertxPlatformHttpRouter
implements Router {
    public static final String PLATFORM_HTTP_ROUTER_NAME = "platform-http-router";
    private final VertxPlatformHttpServer server;
    private final Vertx vertx;
    private final Router delegate;
    private AllowForwardHeaders allowForward;

    public VertxPlatformHttpRouter(VertxPlatformHttpServer server, Vertx vertx, Router delegate) {
        this.server = server;
        this.vertx = vertx;
        this.delegate = delegate;
        this.allowForward = AllowForwardHeaders.NONE;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public VertxPlatformHttpServer getServer() {
        return this.server;
    }

    @Override
    public Route route() {
        return this.delegate.route();
    }

    @Override
    public Route route(HttpMethod method, String s) {
        return this.delegate.route(method, s);
    }

    @Override
    public Route route(String s) {
        return this.delegate.route(s);
    }

    @Override
    public Route routeWithRegex(HttpMethod method, String s) {
        return this.delegate.routeWithRegex(method, s);
    }

    @Override
    public Route routeWithRegex(String s) {
        return this.delegate.routeWithRegex(s);
    }

    @Override
    public Route get() {
        return this.delegate.get();
    }

    @Override
    public Route get(String s) {
        return this.delegate.get(s);
    }

    @Override
    public Route getWithRegex(String s) {
        return this.delegate.getWithRegex(s);
    }

    @Override
    public Route head() {
        return this.delegate.head();
    }

    @Override
    public Route head(String s) {
        return this.delegate.head(s);
    }

    @Override
    public Route headWithRegex(String s) {
        return this.delegate.headWithRegex(s);
    }

    @Override
    public Route options() {
        return this.delegate.options();
    }

    @Override
    public Route options(String s) {
        return this.delegate.options(s);
    }

    @Override
    public Route optionsWithRegex(String s) {
        return this.delegate.optionsWithRegex(s);
    }

    @Override
    public Route put() {
        return this.delegate.put();
    }

    @Override
    public Route put(String s) {
        return this.delegate.put(s);
    }

    @Override
    public Route putWithRegex(String s) {
        return this.delegate.putWithRegex(s);
    }

    @Override
    public Route post() {
        return this.delegate.post();
    }

    @Override
    public Route post(String s) {
        return this.delegate.post(s);
    }

    @Override
    public Route postWithRegex(String s) {
        return this.delegate.postWithRegex(s);
    }

    @Override
    public Route delete() {
        return this.delegate.delete();
    }

    @Override
    public Route delete(String s) {
        return this.delegate.delete(s);
    }

    @Override
    public Route deleteWithRegex(String s) {
        return this.delegate.deleteWithRegex(s);
    }

    @Override
    public Route trace() {
        return this.delegate.trace();
    }

    @Override
    public Route trace(String s) {
        return this.delegate.trace(s);
    }

    @Override
    public Route traceWithRegex(String s) {
        return this.delegate.traceWithRegex(s);
    }

    @Override
    public Route connect() {
        return this.delegate.connect();
    }

    @Override
    public Route connect(String s) {
        return this.delegate.connect(s);
    }

    @Override
    public Route connectWithRegex(String s) {
        return this.delegate.connectWithRegex(s);
    }

    @Override
    public Route patch() {
        return this.delegate.patch();
    }

    @Override
    public Route patch(String s) {
        return this.delegate.patch(s);
    }

    @Override
    public Route patchWithRegex(String s) {
        return this.delegate.patchWithRegex(s);
    }

    @Override
    public List<Route> getRoutes() {
        return this.delegate.getRoutes();
    }

    @Override
    public Router clear() {
        return this.delegate.clear();
    }

    @Override
    public Route mountSubRouter(String mountPoint, Router subRouter) {
        if (mountPoint.endsWith("*")) {
            throw new IllegalArgumentException("Don't include * when mounting a sub router");
        }
        return this.route(mountPoint + "*").subRouter(subRouter);
    }

    @Override
    public Router errorHandler(int i, Handler<RoutingContext> handler) {
        return this.delegate.errorHandler(i, handler);
    }

    @Override
    public void handleContext(RoutingContext context) {
        this.delegate.handleContext(context);
    }

    @Override
    public void handleFailure(RoutingContext context) {
        this.delegate.handleFailure(context);
    }

    @Override
    public Router modifiedHandler(Handler<Router> handler) {
        return this.delegate.modifiedHandler(handler);
    }

    @Override
    public Router allowForward(AllowForwardHeaders allowForwardHeaders) {
        this.allowForward = allowForwardHeaders;
        return this;
    }

    @Override
    public void handle(HttpServerRequest request) {
        this.delegate.handle(request);
    }

    @Override
    public Router putMetadata(String key, Object value) {
        return this.delegate.putMetadata(key, value);
    }

    @Override
    public Map<String, Object> metadata() {
        return this.delegate.metadata();
    }

    public Handler<RoutingContext> bodyHandler() {
        return BodyHandler.create();
    }

    public static VertxPlatformHttpRouter lookup(CamelContext camelContext) {
        return CamelContextHelper.mandatoryLookup(camelContext, PLATFORM_HTTP_ROUTER_NAME, VertxPlatformHttpRouter.class);
    }
}

