/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.AbstractByteOutput;
import java.io.IOException;
import java.io.OutputStream;

public class ArrayByteOutput
extends AbstractByteOutput<byte[]> {
    int index;

    public static ArrayByteOutput of(final int length, final OutputStream stream) {
        if (length <= 0) {
            throw new IllegalArgumentException("length(" + length + ") <= 0");
        }
        if (stream == null) {
            throw new NullPointerException("stream is null");
        }
        return new ArrayByteOutput(null){

            @Override
            public void write(int value) throws IOException {
                if (this.target == null) {
                    this.target = new byte[length];
                    this.index = 0;
                }
                super.write(value);
                if (this.index == ((byte[])this.target).length) {
                    stream.write((byte[])this.target);
                    this.index = 0;
                }
            }

            @Override
            public void setTarget(byte[] target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setIndex(int index) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int flush(ArrayByteOutput output, OutputStream stream) throws IOException {
        if (output == null) {
            throw new NullPointerException("output is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is null");
        }
        byte[] target = (byte[])output.getTarget();
        if (target == null || target.length == 0) {
            return 0;
        }
        int index = output.index;
        if (index < 0 || index >= target.length) {
            return 0;
        }
        stream.write(target, 0, index);
        output.index = 0;
        return index;
    }

    public ArrayByteOutput(byte[] target) {
        super(target);
        this.index = target == null || target.length == 0 ? -1 : 0;
    }

    @Override
    public void write(int value) throws IOException {
        ((byte[])this.target)[this.index++] = (byte)value;
    }

    public ArrayByteOutput target(byte[] target) {
        return (ArrayByteOutput)super.target(target);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ArrayByteOutput index(int index) {
        this.setIndex(index);
        return this;
    }
}

