/*
 * Decompiled with CFR 0.152.
 */
package jtermios.macosx;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;

public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private static int IOSSIOSPEED = -2147199998;
    private static String DEVICE_DIR_PATH = "/dev/";
    static C_lib_DirectMapping m_ClibDM;
    static C_lib m_Clib;

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
    }

    @Override
    public int errno() {
        return Native.getLastError();
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        termios t = new termios(termios2);
        m_Clib.cfmakeraw(t);
        t.update(termios2);
    }

    @Override
    public int fcntl(int fd, int cmd, int arg) {
        return m_Clib.fcntl(fd, cmd, arg);
    }

    @Override
    public int tcdrain(int fd) {
        return m_Clib.tcdrain(fd);
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return m_Clib.cfgetispeed(new termios(termios2)).intValue();
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return m_Clib.cfgetospeed(new termios(termios2)).intValue();
    }

    @Override
    public int cfsetispeed(Termios termios2, int speed) {
        termios t = new termios(termios2);
        int ret = m_Clib.cfsetispeed(t, new NativeLong((long)speed));
        t.update(termios2);
        return ret;
    }

    @Override
    public int cfsetospeed(Termios termios2, int speed) {
        termios t = new termios(termios2);
        int ret = m_Clib.cfsetospeed(t, new NativeLong((long)speed));
        t.update(termios2);
        return ret;
    }

    @Override
    public int open(String s, int t) {
        if (s != null && !s.startsWith("/")) {
            s = DEVICE_DIR_PATH + s;
        }
        return m_Clib.open(s, t);
    }

    @Override
    public int read(int fd, byte[] buffer, int len) {
        return m_Clib.read(fd, buffer, new JTermios.JTermiosInterface.NativeSize((long)len)).intValue();
    }

    @Override
    public int write(int fd, byte[] buffer, int len) {
        return m_Clib.write(fd, buffer, new JTermios.JTermiosInterface.NativeSize((long)len)).intValue();
    }

    @Override
    public int close(int fd) {
        return m_Clib.close(fd);
    }

    @Override
    public int tcflush(int fd, int b) {
        return m_Clib.tcflush(fd, b);
    }

    @Override
    public int tcgetattr(int fd, Termios termios2) {
        termios t = new termios();
        int ret = m_Clib.tcgetattr(fd, t);
        t.update(termios2);
        return ret;
    }

    @Override
    public void perror(String msg) {
        m_Clib.perror(msg);
    }

    @Override
    public int tcsendbreak(int fd, int duration) {
        return m_Clib.tcsendbreak(fd, duration / 250);
    }

    @Override
    public int tcsetattr(int fd, int cmd, Termios termios2) {
        return m_Clib.tcsetattr(fd, cmd, new termios(termios2));
    }

    @Override
    public int select(int nfds, JTermios.FDSet rfds, JTermios.FDSet wfds, JTermios.FDSet efds, TimeVal timeout) {
        timeval tout = null;
        if (timeout != null) {
            tout = new timeval(timeout);
        }
        return m_Clib.select(nfds, (fd_set)rfds, (fd_set)wfds, (fd_set)efds, tout);
    }

    @Override
    public int poll(Pollfd[] fds, int nfds, int timeout) {
        throw new UnsupportedOperationException("Poll not supported");
    }

    @Override
    public boolean canPoll() {
        return false;
    }

    @Override
    public JTermios.FDSet newFDSet() {
        return new fd_set();
    }

    @Override
    public int ioctl(int fd, int cmd, int ... data) {
        return m_Clib.ioctl(fd, new NativeLong(0xFFFFFFFFL & (long)cmd), data);
    }

    @Override
    public List<String> getPortList() {
        File dir = new File(DEVICE_DIR_PATH);
        if (!dir.isDirectory()) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "device directory %s does not exist\n", DEVICE_DIR_PATH);
            return null;
        }
        String[] devs = dir.list();
        LinkedList<String> list = new LinkedList<String>();
        Pattern p = JTermios.getPortNamePattern(this);
        if (devs != null) {
            for (int i = 0; i < devs.length; ++i) {
                String s = devs[i];
                if (!p.matcher(s).matches()) continue;
                list.add(s);
            }
        }
        return list;
    }

    @Override
    public String getPortNamePattern() {
        return "^(tty\\.|cu\\.).*";
    }

    @Override
    public void shutDown() {
    }

    @Override
    public int setspeed(int fd, Termios termios2, int speed) {
        int r = this.cfsetispeed(termios2, speed);
        if (r == 0) {
            r = this.cfsetospeed(termios2, speed);
        }
        if (r == 0) {
            r = this.tcsetattr(fd, JTermios.TCSANOW, termios2);
        }
        if (r != 0 && this.cfsetispeed(termios2, JTermios.B9600) == 0 && this.cfsetospeed(termios2, JTermios.B9600) == 0 && this.tcsetattr(fd, JTermios.TCSANOW, termios2) == 0) {
            r = this.ioctl(fd, IOSSIOSPEED, speed);
        }
        return r;
    }

    @Override
    public int pipe(int[] fds) {
        return m_Clib.pipe(fds);
    }

    static {
        Native.setPreserveLastError(true);
        Native.register(C_lib_DirectMapping.class, NativeLibrary.getInstance(Platform.C_LIBRARY_NAME));
        m_ClibDM = new C_lib_DirectMapping();
        m_Clib = m_ClibDM;
    }

    public static class termios
    extends Structure {
        public NativeLong c_iflag;
        public NativeLong c_oflag;
        public NativeLong c_cflag;
        public NativeLong c_lflag;
        public byte[] c_cc = new byte[20];
        public NativeLong c_ispeed;
        public NativeLong c_ospeed;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_cc", "c_ispeed", "c_ospeed");
        }

        public termios() {
        }

        public termios(Termios t) {
            this.c_iflag.setValue(t.c_iflag);
            this.c_oflag.setValue(t.c_oflag);
            this.c_cflag.setValue(t.c_cflag);
            this.c_lflag.setValue(t.c_lflag);
            System.arraycopy(t.c_cc, 0, this.c_cc, 0, Math.min(t.c_cc.length, this.c_cc.length));
            this.c_ispeed.setValue(t.c_ispeed);
            this.c_ospeed.setValue(t.c_ospeed);
        }

        public void update(Termios t) {
            t.c_iflag = this.c_iflag.intValue();
            t.c_oflag = this.c_oflag.intValue();
            t.c_cflag = this.c_cflag.intValue();
            t.c_lflag = this.c_lflag.intValue();
            System.arraycopy(this.c_cc, 0, t.c_cc, 0, Math.min(t.c_cc.length, this.c_cc.length));
            t.c_ispeed = this.c_ispeed.intValue();
            t.c_ospeed = this.c_ospeed.intValue();
        }
    }

    public static class fd_set
    extends Structure
    implements JTermios.FDSet {
        private static final int NFBBITS = 32;
        private static final int fd_count = 1024;
        public int[] fd_array = new int[32];

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("fd_array");
        }

        @Override
        public void FD_SET(int fd) {
            int n = fd / 32;
            this.fd_array[n] = this.fd_array[n] | 1 << fd % 32;
        }

        @Override
        public boolean FD_ISSET(int fd) {
            return (this.fd_array[fd / 32] & 1 << fd % 32) != 0;
        }

        @Override
        public void FD_ZERO() {
            Arrays.fill(this.fd_array, 0);
        }

        @Override
        public void FD_CLR(int fd) {
            int n = fd / 32;
            this.fd_array[n] = this.fd_array[n] & ~(1 << fd % 32);
        }
    }

    public static class pollfd
    extends Structure {
        public int fd;
        public short events;
        public short revents;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("fd", "events", "revents");
        }

        public pollfd() {
        }

        public pollfd(Pollfd pfd) {
            this.fd = pfd.fd;
            this.events = pfd.events;
            this.revents = pfd.revents;
        }

        public static class ByReference
        extends pollfd
        implements Structure.ByReference {
        }
    }

    public static class timeval
    extends Structure {
        public NativeLong tv_sec;
        public NativeLong tv_usec;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("tv_sec", "tv_usec");
        }

        public timeval(TimeVal timeout) {
            this.tv_sec = new NativeLong(timeout.tv_sec);
            this.tv_usec = new NativeLong(timeout.tv_usec);
        }
    }

    public static interface C_lib
    extends Library {
        public int pipe(int[] var1);

        public int tcdrain(int var1);

        public void cfmakeraw(termios var1);

        public int fcntl(int var1, int var2, int var3);

        public int ioctl(int var1, NativeLong var2, int[] var3);

        public int open(String var1, int var2);

        public int close(int var1);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int cfsetispeed(termios var1, NativeLong var2);

        public int cfsetospeed(termios var1, NativeLong var2);

        public NativeLong cfgetispeed(termios var1);

        public NativeLong cfgetospeed(termios var1);

        public JTermios.JTermiosInterface.NativeSize write(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        public JTermios.JTermiosInterface.NativeSize read(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        public int tcflush(int var1, int var2);

        public void perror(String var1);

        public int tcsendbreak(int var1, int var2);

        public int select(int var1, fd_set var2, fd_set var3, fd_set var4, timeval var5);
    }

    public static class C_lib_DirectMapping
    implements C_lib {
        @Override
        public native int pipe(int[] var1);

        @Override
        public native int tcdrain(int var1);

        @Override
        public native void cfmakeraw(termios var1);

        @Override
        public native int fcntl(int var1, int var2, int var3);

        public native int ioctl(int var1, NativeLong var2);

        public native int ioctl(int var1, NativeLong var2, int var3);

        @Override
        public native int ioctl(int var1, NativeLong var2, int[] var3);

        @Override
        public native int open(String var1, int var2);

        @Override
        public native int close(int var1);

        @Override
        public native int tcgetattr(int var1, termios var2);

        @Override
        public native int tcsetattr(int var1, int var2, termios var3);

        @Override
        public native int cfsetispeed(termios var1, NativeLong var2);

        @Override
        public native int cfsetospeed(termios var1, NativeLong var2);

        @Override
        public native NativeLong cfgetispeed(termios var1);

        @Override
        public native NativeLong cfgetospeed(termios var1);

        @Override
        public native JTermios.JTermiosInterface.NativeSize write(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        @Override
        public native JTermios.JTermiosInterface.NativeSize read(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        @Override
        public native int tcflush(int var1, int var2);

        @Override
        public native void perror(String var1);

        @Override
        public native int tcsendbreak(int var1, int var2);

        @Override
        public native int select(int var1, fd_set var2, fd_set var3, fd_set var4, timeval var5);
    }
}

