/*
 * Decompiled with CFR 0.152.
 */
package jtermios.windows.testsuite;

import com.sun.jna.Memory;
import jtermios.windows.WinAPI;

public class TestSuite {
    private void check(boolean ok, String what) {
        if (!ok) {
            System.err.println(what + " failed, error " + WinAPI.GetLastError());
            System.exit(0);
        }
    }

    public void test1() {
        System.out.println("A contorted loopback test with overlapped IO for WinAPI");
        String COM = "COM5:";
        WinAPI.HANDLE hComm = WinAPI.CreateFile(COM, -1073741824, 0, null, 3, 0x40000000, null);
        this.check(WinAPI.SetupComm(hComm, 2048, 2048), "SetupComm ");
        WinAPI.DCB dcb = new WinAPI.DCB();
        dcb.DCBlength = dcb.size();
        dcb.BaudRate = 1200;
        dcb.ByteSize = (byte)8;
        dcb.fFlags = 0;
        dcb.Parity = 0;
        dcb.XonChar = (byte)17;
        dcb.StopBits = 0;
        dcb.XonChar = (byte)19;
        this.check(WinAPI.SetCommState(hComm, dcb), "SetCommState ");
        WinAPI.COMMTIMEOUTS touts = new WinAPI.COMMTIMEOUTS();
        this.check(WinAPI.SetCommTimeouts(hComm, touts), "SetCommTimeouts ");
        this.check(!WinAPI.INVALID_HANDLE_VALUE.equals(hComm), "CreateFile " + COM);
        String send = "Hello World";
        int tlen = send.getBytes().length;
        int[] txn = new int[]{0};
        Memory txm = new Memory(tlen + 1);
        txm.clear();
        txm.write(0L, send.getBytes(), 0, tlen);
        int[] rxn = new int[]{0};
        Memory rxm = new Memory(tlen);
        WinAPI.OVERLAPPED osReader = new WinAPI.OVERLAPPED();
        osReader.writeField("hEvent", WinAPI.CreateEvent(null, true, false, null));
        this.check(osReader.hEvent != null, "CreateEvent/osReader");
        WinAPI.OVERLAPPED osWriter = new WinAPI.OVERLAPPED();
        osWriter.writeField("hEvent", WinAPI.CreateEvent(null, true, false, null));
        this.check(osWriter.hEvent != null, "CreateEvent/osWriter");
        boolean first = true;
        first = false;
        this.check(WinAPI.ResetEvent(osWriter.hEvent), "ResetEvent/osWriter.hEvent");
        boolean write = WinAPI.WriteFile(hComm, txm, tlen, txn, osWriter);
        if (!write) {
            this.check(WinAPI.GetLastError() == 997, "WriteFile");
            System.out.println("Write pending");
        }
        block8: while (!write) {
            System.out.println("WaitForSingleObject/write");
            int dwRes = WinAPI.WaitForSingleObject(osWriter.hEvent, 1000);
            switch (dwRes) {
                case 0: {
                    if (!WinAPI.GetOverlappedResult(hComm, osWriter, txn, true)) {
                        this.check(WinAPI.GetLastError() == 996, "GetOverlappedResult/osWriter");
                        continue block8;
                    }
                    write = true;
                    continue block8;
                }
                case 258: {
                    System.out.println("write TIMEOT");
                    continue block8;
                }
            }
            this.check(false, "WaitForSingleObject/write");
        }
        System.out.println("Transmit: '" + txm.getString(0L) + "' , len=" + txn[0]);
        this.check(WinAPI.ResetEvent(osReader.hEvent), "ResetEvent/osReader.hEvent ");
        boolean read = WinAPI.ReadFile(hComm, rxm, tlen, rxn, osReader);
        if (!read) {
            this.check(WinAPI.GetLastError() == 997, "ReadFile");
            System.out.println("Read pending");
        }
        block9: while (!read) {
            if (first) {
                // empty if block
            }
            System.out.println("WaitForSingleObject/read");
            this.check(WinAPI.ResetEvent(osReader.hEvent), "ResetEvent/osReader.hEvent");
            int dwRes = WinAPI.WaitForSingleObject(osReader.hEvent, 1000);
            switch (dwRes) {
                case 0: {
                    if (!WinAPI.GetOverlappedResult(hComm, osReader, rxn, false)) {
                        this.check(WinAPI.GetLastError() == 996, "GetOverlappedResult/osReader");
                        continue block9;
                    }
                    read = true;
                    continue block9;
                }
                case 258: {
                    System.out.println("WAIT_TIMEOUT");
                    continue block9;
                }
            }
            this.check(false, "WaitForSingleObject/osReader.hEvent");
        }
        System.out.println("Received: '" + rxm.getString(0L) + "' , len=" + rxn[0]);
        this.check(WinAPI.CloseHandle(osWriter.hEvent), "CloseHandle/osWriter.hEvent");
        this.check(WinAPI.CloseHandle(osReader.hEvent), "CloseHandle/osReader.hEvent");
        this.check(WinAPI.CloseHandle(hComm), "CloseHandle/hComm");
        System.out.println("All done");
    }

    private void run() {
        this.test1();
    }

    public static void main(String[] args) {
        TestSuite ts = new TestSuite();
        ts.run();
    }
}

