/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.plc4x;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.plc4x.Plc4XEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="plc4x")
public class Plc4XComponent
extends DefaultComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Plc4XComponent.class);

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Integer period;
        String trigger;
        Plc4XEndpoint endpoint = new Plc4XEndpoint(uri, this);
        LinkedHashMap<String, String> tags = this.getAndRemoveOrResolveReferenceParameter(parameters, "tags", Map.class);
        Map<String, Object> map = PropertiesHelper.extractProperties(parameters, "tag.");
        if (map != null) {
            if (tags == null) {
                tags = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, Object> me : map.entrySet()) {
                tags.put(me.getKey(), me.getValue().toString());
            }
        }
        if (tags != null) {
            endpoint.setTags((Map<String, String>)tags);
        }
        if ((trigger = this.getAndRemoveOrResolveReferenceParameter(parameters, "trigger", String.class)) != null) {
            endpoint.setTrigger(trigger);
        }
        if ((period = this.getAndRemoveOrResolveReferenceParameter(parameters, "period", Integer.class)) != null) {
            endpoint.setPeriod(period);
        }
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    @Override
    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) {
        Plc4XEndpoint plc4XEndpoint = (Plc4XEndpoint)endpoint;
        plc4XEndpoint.setDriver(remaining.split(":")[0]);
    }

    @Override
    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
        if (parameters != null && !parameters.isEmpty()) {
            Map<String, Object> param = parameters;
            if (optionPrefix != null) {
                param = PropertiesHelper.extractProperties(parameters, optionPrefix);
            }
            if (parameters.size() > 0) {
                LOGGER.info("{} parameters will be passed to the PLC Driver", param);
            }
        }
    }
}

