/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionResponse;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationPacket;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadResponse;
import org.apache.plc4x.java.abeth.readwrite.DF1CommandRequestMessage;
import org.apache.plc4x.java.abeth.readwrite.DF1CommandResponseMessageProtectedTypedLogicalRead;
import org.apache.plc4x.java.abeth.readwrite.DF1RequestProtectedTypedLogicalRead;
import org.apache.plc4x.java.abeth.tag.AbEthTag;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.PlcMessageToMessageCodec;
import org.apache.plc4x.java.spi.events.ConnectEvent;
import org.apache.plc4x.java.spi.events.ConnectedEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.PlcRequestContainer;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Plc4xAbEthProtocol
extends PlcMessageToMessageCodec<CIPEncapsulationPacket, PlcRequestContainer> {
    private static final Logger logger = LoggerFactory.getLogger(Plc4xAbEthProtocol.class);
    private static final AtomicInteger transactionCounterGenerator = new AtomicInteger(10);
    private static final List<Short> emptySenderContext = Arrays.asList((short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0);
    private long sessionHandle;
    private final Map<Integer, PlcRequestContainer> requests;
    private final int station;

    public Plc4xAbEthProtocol(int station) {
        logger.trace("Created new instance of PLC4X-AB-ETH Protocol");
        this.requests = new HashMap<Integer, PlcRequestContainer>();
        this.station = station;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        logger.trace("Registered user event {}", evt);
        if (evt instanceof ConnectEvent) {
            logger.debug("AB-ETH Sending Connection Request");
            CIPEncapsulationConnectionRequest connectionRequest = new CIPEncapsulationConnectionRequest(0L, 0L, emptySenderContext, 0L);
            ctx.channel().writeAndFlush(connectionRequest);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, PlcRequestContainer msg, List<Object> out) throws Exception {
        logger.trace("Encoding {}", (Object)msg);
        Object request = msg.getRequest();
        if (transactionCounterGenerator.get() > 65000) {
            transactionCounterGenerator.set(10);
        }
        if (request instanceof PlcReadRequest) {
            PlcReadRequest readRequest = (PlcReadRequest)msg.getRequest();
            for (String tagName : readRequest.getTagNames()) {
                PlcTag tag = readRequest.getTag(tagName);
                if (!(tag instanceof AbEthTag)) {
                    throw new PlcProtocolException("The tag should have been of type AbEthTag");
                }
                AbEthTag abEthTag = (AbEthTag)tag;
                DF1RequestProtectedTypedLogicalRead logicalRead = new DF1RequestProtectedTypedLogicalRead(abEthTag.getByteSize(), abEthTag.getFileNumber(), abEthTag.getFileType().getTypeCode(), abEthTag.getElementNumber(), 0);
                DF1CommandRequestMessage requestMessage = new DF1CommandRequestMessage((short)this.station, 5, 0, transactionCounterGenerator.incrementAndGet(), logicalRead);
                CIPEncapsulationReadRequest read = new CIPEncapsulationReadRequest(this.sessionHandle, 0L, emptySenderContext, 0L, requestMessage);
                this.requests.put(requestMessage.getTransactionCounter(), msg);
                out.add(read);
            }
        } else {
            ctx.fireExceptionCaught(new PlcProtocolException("Unsupported request type " + request.getClass().getName()));
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, CIPEncapsulationPacket packet, List<Object> out) throws Exception {
        logger.trace("Received {}, decoding...", (Object)packet);
        if (packet instanceof CIPEncapsulationConnectionResponse) {
            CIPEncapsulationConnectionResponse connectionResponse = (CIPEncapsulationConnectionResponse)packet;
            this.sessionHandle = connectionResponse.getSessionHandle();
            ctx.channel().pipeline().fireUserEventTriggered(new ConnectedEvent());
        } else {
            if (!(packet instanceof CIPEncapsulationReadResponse)) {
                return;
            }
            CIPEncapsulationReadResponse cipResponse = (CIPEncapsulationReadResponse)packet;
            int transactionCounter = cipResponse.getResponse().getTransactionCounter();
            if (!this.requests.containsKey(transactionCounter)) {
                ctx.fireExceptionCaught(new PlcProtocolException("Couldn't find request for response with transaction counter " + transactionCounter));
                return;
            }
            PlcRequestContainer requestContainer = this.requests.remove(transactionCounter);
            Object request = requestContainer.getRequest();
            PlcResponse response = null;
            if (request instanceof PlcReadRequest) {
                response = this.decodeReadResponse(cipResponse, requestContainer);
            } else {
                ctx.fireExceptionCaught(new PlcProtocolException("Unsupported request type " + request.getClass().getName()));
            }
            if (response != null) {
                requestContainer.getResponseFuture().complete(response);
            }
        }
    }

    private PlcResponse decodeReadResponse(CIPEncapsulationReadResponse plcReadResponse, PlcRequestContainer requestContainer) {
        PlcReadRequest plcReadRequest = (PlcReadRequest)requestContainer.getRequest();
        HashMap<String, ResponseItem<PlcValue>> values = new HashMap<String, ResponseItem<PlcValue>>();
        for (String tagName : plcReadRequest.getTagNames()) {
            AbEthTag tag = (AbEthTag)plcReadRequest.getTag(tagName);
            PlcResponseCode responseCode = this.decodeResponseCode(plcReadResponse.getResponse().getStatus());
            PlcValue plcValue = null;
            if (responseCode == PlcResponseCode.OK) {
                try {
                    switch (tag.getFileType()) {
                        case INTEGER: {
                            List<Short> data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if (data.size() == 1) {
                                    plcValue = new PlcINT(data.get(0));
                                    break;
                                }
                                plcValue = PlcValueHandler.of(data);
                            }
                            break;
                        }
                        case WORD: {
                            List<Short> data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if ((data.get(1) >> 7 & 1) == 0) {
                                    plcValue = PlcValueHandler.of((data.get(1) << 8) + data.get(0));
                                    break;
                                }
                                plcValue = PlcValueHandler.of((((~data.get(1).shortValue() & 0x7F) << 8) + (-data.get(0).shortValue() & 0xFF)) * -1);
                            }
                            break;
                        }
                        case DWORD: {
                            List<Short> data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if ((data.get(3) >> 7 & 1) == 0) {
                                    plcValue = PlcValueHandler.of((data.get(3) << 24) + (data.get(2) << 16) + (data.get(1) << 8) + data.get(0));
                                    break;
                                }
                                plcValue = PlcValueHandler.of((((~data.get(3).shortValue() & 0x7F) << 24) + ((-data.get(2).shortValue() & 0xFF) << 16) + ((-data.get(1).shortValue() & 0xFF) << 8) + (-data.get(0).shortValue() & 0xFF)) * -1);
                            }
                            break;
                        }
                        case SINGLEBIT: {
                            List<Short> data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if (tag.getBitNumber() < 8) {
                                    plcValue = PlcValueHandler.of((data.get(0) & 1 << tag.getBitNumber()) != 0);
                                    break;
                                }
                                plcValue = PlcValueHandler.of((data.get(1) & 1 << tag.getBitNumber() - 8) != 0);
                            }
                            break;
                        }
                        default: {
                            logger.warn("Problem during decoding of tag {}: Decoding of file type not implemented; TagInformation: {}", (Object)tagName, (Object)tag);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("Some other error occurred casting field {}, TagInformation: {}", new Object[]{tagName, tag, e});
                }
            }
            ResponseItem<Object> result = new ResponseItem<Object>(responseCode, plcValue);
            values.put(tagName, result);
        }
        return new DefaultPlcReadResponse(plcReadRequest, values);
    }

    private PlcResponseCode decodeResponseCode(short status) {
        if (status == 0) {
            return PlcResponseCode.OK;
        }
        return PlcResponseCode.NOT_FOUND;
    }

    private PlcValue decodeReadResponseUnsignedBytePlcValue(AbEthTag tag, ByteBuf data) {
        Object shorts = null;
        return new PlcSINT(1);
    }
}

