/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.configuration;

import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.ads.readwrite.AmsNetId;
import org.apache.plc4x.java.spi.configuration.ConfigurationParameterConverter;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.Description;
import org.apache.plc4x.java.spi.configuration.annotations.ParameterConverter;
import org.apache.plc4x.java.spi.configuration.annotations.Required;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.BooleanDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.IntDefaultValue;

public class AdsConfiguration
implements PlcConnectionConfiguration {
    public static final Pattern AMS_NET_ID_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    @Required
    @ConfigurationParameter(value="target-ams-net-id")
    @ParameterConverter(value=AmsNetIdConverter.class)
    @Description(value="AMS-Net-Id of the target. An AMS-Net-Id has the regular format of an IPv4 IP-Address, however with 6 segments instead of 4.")
    protected AmsNetId targetAmsNetId;
    @Required
    @ConfigurationParameter(value="target-ams-port")
    @Description(value="AMS port of the target.")
    protected int targetAmsPort;
    @Required
    @ConfigurationParameter(value="source-ams-net-id")
    @ParameterConverter(value=AmsNetIdConverter.class)
    @Description(value="AMS-Net-Id of the source. An AMS-Net-Id has the regular format of an IPv4 IP-Address, however with 6 segments instead of 4.")
    protected AmsNetId sourceAmsNetId;
    @Required
    @ConfigurationParameter(value="source-ams-port")
    @Description(value="AMS port of the source.")
    protected int sourceAmsPort;
    @ConfigurationParameter(value="timeout-request")
    @IntDefaultValue(value=4000)
    @Description(value="Default timeout for all types of requests.")
    protected int timeoutRequest;
    @ConfigurationParameter(value="load-symbol-and-data-type-tables")
    @BooleanDefaultValue(value=true)
    @Description(value="Configures, if when connecting the data-type- and symbol-table should be read. This is an optimization that can help in cases, where the PLC program is pretty large and downloading the full tables is causing problems. When disabled, symbolic addresses will manually be resolved as soon as an address is used.")
    protected boolean loadSymbolAndDataTypeTables;

    public AmsNetId getTargetAmsNetId() {
        return this.targetAmsNetId;
    }

    public void setTargetAmsNetId(AmsNetId targetAmsNetId) {
        this.targetAmsNetId = targetAmsNetId;
    }

    public int getTargetAmsPort() {
        return this.targetAmsPort;
    }

    public void setTargetAmsPort(int targetAmsPort) {
        this.targetAmsPort = targetAmsPort;
    }

    public AmsNetId getSourceAmsNetId() {
        return this.sourceAmsNetId;
    }

    public void setSourceAmsNetId(AmsNetId sourceAmsNetId) {
        this.sourceAmsNetId = sourceAmsNetId;
    }

    public int getSourceAmsPort() {
        return this.sourceAmsPort;
    }

    public void setSourceAmsPort(int sourceAmsPort) {
        this.sourceAmsPort = sourceAmsPort;
    }

    public int getTimeoutRequest() {
        return this.timeoutRequest;
    }

    public void setTimeoutRequest(int timeoutRequest) {
        this.timeoutRequest = timeoutRequest;
    }

    public boolean isLoadSymbolAndDataTypeTables() {
        return this.loadSymbolAndDataTypeTables;
    }

    public void setLoadSymbolAndDataTypeTables(boolean loadSymbolAndDataTypeTables) {
        this.loadSymbolAndDataTypeTables = loadSymbolAndDataTypeTables;
    }

    public static AmsNetId amsNetIdOf(String address) {
        if (!AMS_NET_ID_PATTERN.matcher(address).matches()) {
            throw new IllegalArgumentException(String.valueOf(address) + " must match " + AMS_NET_ID_PATTERN);
        }
        String[] split = address.split("\\.");
        short[] shorts = ArrayUtils.toPrimitive((Short[])Stream.of(split).map(Integer::parseInt).map(Integer::shortValue).toArray(Short[]::new));
        return new AmsNetId(shorts[0], shorts[1], shorts[2], shorts[3], shorts[4], shorts[5]);
    }

    public static class AmsNetIdConverter
    implements ConfigurationParameterConverter<AmsNetId> {
        @Override
        public Class<AmsNetId> getType() {
            return AmsNetId.class;
        }

        @Override
        public AmsNetId convert(String value) {
            return AdsConfiguration.amsNetIdOf(value);
        }
    }
}

