/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.protocol;

import io.netty.channel.ChannelPipeline;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.plc4x.java.ads.configuration.AdsConfiguration;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscovery;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlock;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockAmsNetId;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockHostName;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockPassword;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockRouteName;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockStatus;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockType;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockUserName;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryConstants;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsPortNumbers;
import org.apache.plc4x.java.ads.discovery.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.discovery.readwrite.AmsString;
import org.apache.plc4x.java.ads.discovery.readwrite.Operation;
import org.apache.plc4x.java.ads.discovery.readwrite.Status;
import org.apache.plc4x.java.ads.model.AdsSubscriptionHandle;
import org.apache.plc4x.java.ads.readwrite.AdsAddDeviceNotificationRequest;
import org.apache.plc4x.java.ads.readwrite.AdsAddDeviceNotificationResponse;
import org.apache.plc4x.java.ads.readwrite.AdsDataType;
import org.apache.plc4x.java.ads.readwrite.AdsDataTypeArrayInfo;
import org.apache.plc4x.java.ads.readwrite.AdsDataTypeTableChildEntry;
import org.apache.plc4x.java.ads.readwrite.AdsDataTypeTableEntry;
import org.apache.plc4x.java.ads.readwrite.AdsDeleteDeviceNotificationRequest;
import org.apache.plc4x.java.ads.readwrite.AdsDeleteDeviceNotificationResponse;
import org.apache.plc4x.java.ads.readwrite.AdsDeviceNotificationRequest;
import org.apache.plc4x.java.ads.readwrite.AdsMultiRequestItemRead;
import org.apache.plc4x.java.ads.readwrite.AdsMultiRequestItemReadWrite;
import org.apache.plc4x.java.ads.readwrite.AdsMultiRequestItemWrite;
import org.apache.plc4x.java.ads.readwrite.AdsNotificationSample;
import org.apache.plc4x.java.ads.readwrite.AdsReadDeviceInfoRequest;
import org.apache.plc4x.java.ads.readwrite.AdsReadDeviceInfoResponse;
import org.apache.plc4x.java.ads.readwrite.AdsReadRequest;
import org.apache.plc4x.java.ads.readwrite.AdsReadResponse;
import org.apache.plc4x.java.ads.readwrite.AdsReadWriteRequest;
import org.apache.plc4x.java.ads.readwrite.AdsReadWriteResponse;
import org.apache.plc4x.java.ads.readwrite.AdsStampHeader;
import org.apache.plc4x.java.ads.readwrite.AdsSymbolTableEntry;
import org.apache.plc4x.java.ads.readwrite.AdsTableSizes;
import org.apache.plc4x.java.ads.readwrite.AdsTransMode;
import org.apache.plc4x.java.ads.readwrite.AdsWriteRequest;
import org.apache.plc4x.java.ads.readwrite.AdsWriteResponse;
import org.apache.plc4x.java.ads.readwrite.AmsPacket;
import org.apache.plc4x.java.ads.readwrite.AmsTCPPacket;
import org.apache.plc4x.java.ads.readwrite.DataItem;
import org.apache.plc4x.java.ads.readwrite.DefaultAmsPorts;
import org.apache.plc4x.java.ads.readwrite.ReservedIndexGroups;
import org.apache.plc4x.java.ads.readwrite.ReturnCode;
import org.apache.plc4x.java.ads.tag.AdsTag;
import org.apache.plc4x.java.ads.tag.DirectAdsStringTag;
import org.apache.plc4x.java.ads.tag.DirectAdsTag;
import org.apache.plc4x.java.ads.tag.SymbolicAdsTag;
import org.apache.plc4x.java.api.authentication.PlcUsernamePasswordAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcBrowseItem;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseRequestInterceptor;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.messages.PlcPingRequest;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultListPlcBrowseItem;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseItem;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcPingResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcBrowser;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultArrayInfo;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdsProtocolLogic
extends Plc4xProtocolBase<AmsTCPPacket>
implements HasConfiguration<AdsConfiguration>,
PlcSubscriber,
PlcBrowser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsProtocolLogic.class);
    private AdsConfiguration configuration;
    private String adsVersion;
    private String deviceName;
    private final AtomicLong invokeIdGenerator = new AtomicLong(1L);
    private final RequestTransactionManager tm;
    private final Map<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> consumers = new ConcurrentHashMap<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>>();
    private final ConcurrentHashMap<SymbolicAdsTag, CompletableFuture<Void>> pendingResolutionRequests = new ConcurrentHashMap();
    private int symbolVersion;
    private long onlineVersion;
    private final Map<String, AdsSymbolTableEntry> symbolTable = new HashMap<String, AdsSymbolTableEntry>();
    private final Map<String, AdsDataTypeTableEntry> dataTypeTable = new HashMap<String, AdsDataTypeTableEntry>();
    private final ReentrantLock invalidationLock = new ReentrantLock();

    public AdsProtocolLogic() {
        this.tm = new RequestTransactionManager(1);
    }

    @Override
    public void close(ConversationContext<AmsTCPPacket> context) {
        this.tm.shutdown();
    }

    @Override
    public void setConfiguration(AdsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void onConnect(ConversationContext<AmsTCPPacket> context) {
        CompletableFuture<Object> setupAmsRouteFuture;
        if (context.getAuthentication() != null) {
            if (!(context.getAuthentication() instanceof PlcUsernamePasswordAuthentication)) {
                context.getChannel().pipeline().fireExceptionCaught(new PlcConnectionException("This type of connection only supports username-password authentication"));
                return;
            }
            PlcUsernamePasswordAuthentication usernamePasswordAuthentication = (PlcUsernamePasswordAuthentication)context.getAuthentication();
            setupAmsRouteFuture = this.setupAmsRoute(usernamePasswordAuthentication);
        } else {
            setupAmsRouteFuture = CompletableFuture.completedFuture(null);
        }
        setupAmsRouteFuture.whenComplete((unused, throwable) -> {
            if (!this.configuration.isLoadSymbolAndDataTypeTables()) {
                context.fireConnected();
            } else {
                AdsReadDeviceInfoRequest readDeviceInfoRequest = new AdsReadDeviceInfoRequest(this.configuration.getTargetAmsNetId(), DefaultAmsPorts.RUNTIME_SYSTEM_01.getValue(), this.configuration.getSourceAmsNetId(), 800, 0L, this.getInvokeId());
                RequestTransactionManager.RequestTransaction readDeviceInfoTx = this.tm.startRequest();
                readDeviceInfoTx.submit(() -> {
                    ConversationContext.ContextHandler contextHandler = context.sendRequest(new AmsTCPPacket(readDeviceInfoRequest)).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(e -> {
                        ChannelPipeline channelPipeline = context.getChannel().pipeline().fireExceptionCaught((Throwable)e);
                    }).onError((p, e) -> {
                        ChannelPipeline channelPipeline = context.getChannel().pipeline().fireExceptionCaught((Throwable)e);
                    }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == readDeviceInfoRequest.getInvokeId()).only(AdsReadDeviceInfoResponse.class).handle(readDeviceInfoResponse -> {
                        readDeviceInfoTx.endRequest();
                        if (readDeviceInfoResponse.getResult() != ReturnCode.OK) {
                            context.getChannel().pipeline().fireExceptionCaught(new PlcException("Result is " + (Object)((Object)readDeviceInfoResponse.getResult())));
                            return;
                        }
                        this.adsVersion = String.format("%d.%d.%d", readDeviceInfoResponse.getMajorVersion(), readDeviceInfoResponse.getMinorVersion(), readDeviceInfoResponse.getVersion());
                        this.deviceName = new String(readDeviceInfoResponse.getDevice()).trim();
                        AdsReadWriteRequest readOnlineVersionNumberRequest = new AdsReadWriteRequest(this.configuration.getTargetAmsNetId(), DefaultAmsPorts.RUNTIME_SYSTEM_01.getValue(), this.configuration.getSourceAmsNetId(), 800, 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_SYM_VALBYNAME.getValue(), 0L, 4L, null, "TwinCAT_SystemInfoVarList._AppInfo.OnlineChangeCnt".getBytes(StandardCharsets.UTF_8));
                        RequestTransactionManager.RequestTransaction readOnlineVersionNumberTx = this.tm.startRequest();
                        readOnlineVersionNumberTx.submit(() -> {
                            ConversationContext.ContextHandler contextHandler = context.sendRequest(new AmsTCPPacket(readOnlineVersionNumberRequest)).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(e -> {
                                ChannelPipeline channelPipeline = context.getChannel().pipeline().fireExceptionCaught((Throwable)e);
                            }).onError((p, e) -> {
                                ChannelPipeline channelPipeline = context.getChannel().pipeline().fireExceptionCaught((Throwable)e);
                            }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == readOnlineVersionNumberRequest.getInvokeId()).only(AdsReadWriteResponse.class).handle(readOnlineVersionNumberResponse -> {
                                readOnlineVersionNumberTx.endRequest();
                                if (readOnlineVersionNumberResponse.getResult() != ReturnCode.OK) {
                                    context.getChannel().pipeline().fireExceptionCaught(new PlcException("Result is " + (Object)((Object)readOnlineVersionNumberResponse.getResult())));
                                    return;
                                }
                                try {
                                    ReadBufferByteBased rb = new ReadBufferByteBased(readOnlineVersionNumberResponse.getData());
                                    this.onlineVersion = rb.readUnsignedLong(32, new WithReaderArgs[0]);
                                    AdsReadRequest readSymbolVersionNumberRequest = new AdsReadRequest(this.configuration.getTargetAmsNetId(), DefaultAmsPorts.RUNTIME_SYSTEM_01.getValue(), this.configuration.getSourceAmsNetId(), 800, 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_SYM_VERSION.getValue(), 0L, 1L);
                                    RequestTransactionManager.RequestTransaction readSymbolVersionNumberTx = this.tm.startRequest();
                                    readSymbolVersionNumberTx.submit(() -> {
                                        ConversationContext.ContextHandler contextHandler = context.sendRequest(new AmsTCPPacket(readSymbolVersionNumberRequest)).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(e -> {
                                            ChannelPipeline channelPipeline = context.getChannel().pipeline().fireExceptionCaught((Throwable)e);
                                        }).onError((p, e) -> {
                                            ChannelPipeline channelPipeline = context.getChannel().pipeline().fireExceptionCaught((Throwable)e);
                                        }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == readSymbolVersionNumberRequest.getInvokeId()).only(AdsReadResponse.class).handle(readSymbolVersionNumberResponse -> {
                                            readSymbolVersionNumberTx.endRequest();
                                            if (readSymbolVersionNumberResponse.getResult() != ReturnCode.OK) {
                                                context.getChannel().pipeline().fireExceptionCaught(new PlcException("Result is " + (Object)((Object)readSymbolVersionNumberResponse.getResult())));
                                                return;
                                            }
                                            try {
                                                ReadBufferByteBased rb2 = new ReadBufferByteBased(readSymbolVersionNumberResponse.getData());
                                                this.symbolVersion = rb2.readUnsignedInt(8, new WithReaderArgs[0]);
                                                LOGGER.debug("Fetching sizes of symbol and datatype table sizes.");
                                                CompletableFuture<Void> readSymbolTableFuture = this.readSymbolTableAndDatatypeTable(context);
                                                readSymbolTableFuture.whenComplete((unused2, throwable2) -> {
                                                    if (throwable2 != null) {
                                                        LOGGER.error("Error fetching symbol and datatype table sizes");
                                                    } else {
                                                        context.fireConnected();
                                                    }
                                                });
                                            }
                                            catch (ParseException e) {
                                                context.getChannel().pipeline().fireExceptionCaught(new PlcConnectionException("Error reading the symbol version of data type and symbol data.", e));
                                            }
                                        });
                                    });
                                }
                                catch (ParseException e) {
                                    context.getChannel().pipeline().fireExceptionCaught(new PlcConnectionException("Error reading the online version of data type and symbol data.", e));
                                }
                            });
                        });
                    });
                });
            }
        });
    }

    protected CompletableFuture<Void> setupAmsRoute(PlcUsernamePasswordAuthentication authentication) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        new Thread(() -> {
            LOGGER.debug("Setting up remote AMS routes.");
            SocketAddress localSocketAddress = this.context.getChannel().localAddress();
            InetAddress localAddress = ((InetSocketAddress)localSocketAddress).getAddress();
            AmsNetId sourceAmsNetId = new AmsNetId(this.configuration.getSourceAmsNetId().getOctet1(), this.configuration.getSourceAmsNetId().getOctet2(), this.configuration.getSourceAmsNetId().getOctet3(), this.configuration.getSourceAmsNetId().getOctet4(), this.configuration.getSourceAmsNetId().getOctet5(), this.configuration.getSourceAmsNetId().getOctet6());
            String routeName = String.format("PLC4X-%d.%d.%d.%d.%d.%d", sourceAmsNetId.getOctet1(), sourceAmsNetId.getOctet2(), sourceAmsNetId.getOctet3(), sourceAmsNetId.getOctet4(), sourceAmsNetId.getOctet5(), sourceAmsNetId.getOctet6());
            AdsDiscovery addOrUpdateRouteRequest = new AdsDiscovery(this.getInvokeId(), Operation.ADD_OR_UPDATE_ROUTE_REQUEST, sourceAmsNetId, AdsPortNumbers.SYSTEM_SERVICE, Arrays.asList(new AdsDiscoveryBlockRouteName(new AmsString(routeName)), new AdsDiscoveryBlockAmsNetId(sourceAmsNetId), new AdsDiscoveryBlockUserName(new AmsString(authentication.getUsername())), new AdsDiscoveryBlockPassword(new AmsString(authentication.getPassword())), new AdsDiscoveryBlockHostName(new AmsString(localAddress.getHostAddress()))));
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (DatagramSocket adsDiscoverySocket = new DatagramSocket(AdsDiscoveryConstants.ADSDISCOVERYUDPDEFAULTPORT);){
                    WriteBufferByteBased writeBuffer = new WriteBufferByteBased(addOrUpdateRouteRequest.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
                    addOrUpdateRouteRequest.serialize(writeBuffer);
                    SocketAddress remoteSocketAddress = this.context.getChannel().remoteAddress();
                    InetAddress remoteAddress = ((InetSocketAddress)remoteSocketAddress).getAddress();
                    DatagramPacket discoveryRequestPacket = new DatagramPacket(writeBuffer.getBytes(), writeBuffer.getBytes().length, remoteAddress, AdsDiscoveryConstants.ADSDISCOVERYUDPDEFAULTPORT);
                    adsDiscoverySocket.send(discoveryRequestPacket);
                    byte[] buf = new byte[100];
                    DatagramPacket responsePacket = new DatagramPacket(buf, buf.length);
                    adsDiscoverySocket.setSoTimeout(this.configuration.getTimeoutRequest());
                    adsDiscoverySocket.receive(responsePacket);
                    ReadBufferByteBased readBuffer = new ReadBufferByteBased(responsePacket.getData(), ByteOrder.LITTLE_ENDIAN);
                    AdsDiscovery addOrUpdateRouteResponse = AdsDiscovery.staticParse(readBuffer);
                    if (addOrUpdateRouteResponse.getRequestId() == 1L) {
                        for (AdsDiscoveryBlock block : addOrUpdateRouteResponse.getBlocks()) {
                            AdsDiscoveryBlockStatus statusBlock;
                            if (block.getBlockType() != AdsDiscoveryBlockType.STATUS || (statusBlock = (AdsDiscoveryBlockStatus)block).getStatus() == Status.SUCCESS) continue;
                            future.completeExceptionally(new PlcException("Error adding AMS route"));
                            return;
                        }
                    }
                    future.complete(null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                future.completeExceptionally(new PlcException("Error adding AMS route", e));
            }
        }).start();
        return future;
    }

    protected CompletableFuture<Void> readSymbolTableAndDatatypeTable(ConversationContext<AmsTCPPacket> context) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AdsReadRequest readDataAndSymbolTableSizesRequest = new AdsReadRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_SYMBOL_AND_DATA_TYPE_SIZES.getValue(), 0L, 24L);
        RequestTransactionManager.RequestTransaction readDataAndSymbolTableSizesTx = this.tm.startRequest();
        readDataAndSymbolTableSizesTx.submit(() -> {
            ConversationContext.ContextHandler contextHandler = context.sendRequest(new AmsTCPPacket(readDataAndSymbolTableSizesRequest)).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == readDataAndSymbolTableSizesRequest.getInvokeId()).only(AdsReadResponse.class).handle(readDataAndSymbolTableSizesResponse -> {
                readDataAndSymbolTableSizesTx.endRequest();
                if (readDataAndSymbolTableSizesResponse.getResult() != ReturnCode.OK) {
                    future.completeExceptionally(new PlcException("Reading data type and symbol table sizes failed: " + (Object)((Object)readDataAndSymbolTableSizesResponse.getResult())));
                    return;
                }
                try {
                    ReadBufferByteBased readBuffer = new ReadBufferByteBased(readDataAndSymbolTableSizesResponse.getData());
                    AdsTableSizes adsTableSizes = AdsTableSizes.staticParse(readBuffer);
                    LOGGER.debug("PLC contains {} symbols and {} data-types", (Object)adsTableSizes.getSymbolCount(), (Object)adsTableSizes.getDataTypeCount());
                    AdsReadRequest readDataTypeTableRequest = new AdsReadRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_DATA_TYPE_TABLE_UPLOAD.getValue(), 0L, adsTableSizes.getDataTypeLength());
                    RequestTransactionManager.RequestTransaction readDataTypeTableTx = this.tm.startRequest();
                    AmsTCPPacket amsReadTableTCPPacket = new AmsTCPPacket(readDataTypeTableRequest);
                    readDataTypeTableTx.submit(() -> {
                        ConversationContext.ContextHandler contextHandler = context.sendRequest(amsReadTableTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                            boolean bl = future.completeExceptionally((Throwable)e);
                        }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == readDataTypeTableRequest.getInvokeId()).only(AdsReadResponse.class).handle(readDataTypeTableResponse -> {
                            readDataTypeTableTx.endRequest();
                            if (readDataTypeTableResponse.getResult() != ReturnCode.OK) {
                                future.completeExceptionally(new PlcException("Reading data type table failed: " + (Object)((Object)readDataTypeTableResponse.getResult())));
                                return;
                            }
                            ReadBufferByteBased rb = new ReadBufferByteBased(readDataTypeTableResponse.getData());
                            int i = 0;
                            while ((long)i < adsTableSizes.getDataTypeCount()) {
                                try {
                                    AdsDataTypeTableEntry adsDataTypeTableEntry = AdsDataTypeTableEntry.staticParse(rb);
                                    this.dataTypeTable.put(adsDataTypeTableEntry.getDataTypeName(), adsDataTypeTableEntry);
                                }
                                catch (ParseException e) {
                                    throw new RuntimeException(e);
                                }
                                ++i;
                            }
                            AdsReadRequest readSymbolTableRequest = new AdsReadRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_SYM_UPLOAD.getValue(), 0L, adsTableSizes.getSymbolLength());
                            RequestTransactionManager.RequestTransaction readSymbolTableTx = this.tm.startRequest();
                            AmsTCPPacket amsReadSymbolTableTCPPacket = new AmsTCPPacket(readSymbolTableRequest);
                            readSymbolTableTx.submit(() -> {
                                ConversationContext.ContextHandler contextHandler = context.sendRequest(amsReadSymbolTableTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                                    boolean bl = future.completeExceptionally((Throwable)e);
                                }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == readSymbolTableRequest.getInvokeId()).only(AdsReadResponse.class).handle(readSymbolTableResponse -> {
                                    readSymbolTableTx.endRequest();
                                    if (readSymbolTableResponse.getResult() != ReturnCode.OK) {
                                        future.completeExceptionally(new PlcException("Reading symbol table failed: " + (Object)((Object)readSymbolTableResponse.getResult())));
                                        return;
                                    }
                                    ReadBufferByteBased rb2 = new ReadBufferByteBased(readSymbolTableResponse.getData());
                                    int i = 0;
                                    while ((long)i < adsTableSizes.getSymbolCount()) {
                                        try {
                                            AdsSymbolTableEntry adsSymbolTableEntry = AdsSymbolTableEntry.staticParse(rb2);
                                            this.symbolTable.put(adsSymbolTableEntry.getName(), adsSymbolTableEntry);
                                        }
                                        catch (ParseException e) {
                                            throw new RuntimeException(e);
                                        }
                                        ++i;
                                    }
                                    LinkedHashMap<String, PlcSubscriptionTag> subscriptionTags = new LinkedHashMap<String, PlcSubscriptionTag>();
                                    subscriptionTags.put("onlineVersion", new DefaultPlcSubscriptionTag(PlcSubscriptionType.CHANGE_OF_STATE, new SymbolicAdsTag("TwinCAT_SystemInfoVarList._AppInfo.OnlineChangeCnt", PlcValueType.UDINT, Collections.emptyList()), Duration.ofMillis(1000L)));
                                    subscriptionTags.put("symbolVersion", new DefaultPlcSubscriptionTag(PlcSubscriptionType.CHANGE_OF_STATE, new DirectAdsTag(61448L, 0L, "USINT", 1), Duration.ofMillis(1000L)));
                                    LinkedHashMap<String, List<Consumer<PlcSubscriptionEvent>>> consumer = new LinkedHashMap<String, List<Consumer<PlcSubscriptionEvent>>>();
                                    consumer.put("onlineVersion", Collections.singletonList(plcSubscriptionEvent -> {
                                        long oldVersion = this.onlineVersion;
                                        long newVersion = plcSubscriptionEvent.getPlcValue("onlineVersion").getLong();
                                        if (oldVersion != newVersion && this.invalidationLock.tryLock()) {
                                            LOGGER.info("Detected change of the 'online-version', invalidating data type and symbol information.");
                                            CompletableFuture<Void> reloadingFuture = this.readSymbolTableAndDatatypeTable(context);
                                            reloadingFuture.whenComplete((unused, throwable) -> {
                                                if (throwable != null) {
                                                    LOGGER.error("Error reloading data type and symbol data", throwable);
                                                }
                                                this.invalidationLock.unlock();
                                            });
                                        }
                                    }));
                                    consumer.put("symbolVersion", Collections.singletonList(plcSubscriptionEvent -> {
                                        int oldVersion = this.symbolVersion;
                                        int newVersion = plcSubscriptionEvent.getPlcValue("symbolVersion").getInteger();
                                        if (oldVersion != newVersion && this.invalidationLock.tryLock()) {
                                            LOGGER.info("Detected change of the 'symbol-version', invalidating data type and symbol information.");
                                            CompletableFuture<Void> reloadingFuture = this.readSymbolTableAndDatatypeTable(context);
                                            reloadingFuture.whenComplete((unused, throwable) -> {
                                                if (throwable != null) {
                                                    LOGGER.error("Error reloading data type and symbol data", throwable);
                                                }
                                                this.invalidationLock.unlock();
                                            });
                                        }
                                    }));
                                    DefaultPlcSubscriptionRequest subscriptionRequest = new DefaultPlcSubscriptionRequest(this, subscriptionTags, consumer);
                                    CompletableFuture<PlcSubscriptionResponse> subscriptionResponseCompletableFuture = this.subscribe(subscriptionRequest);
                                    subscriptionResponseCompletableFuture.whenComplete((plcSubscriptionResponse, throwable) -> {
                                        if (throwable == null) {
                                            future.complete(null);
                                        }
                                    });
                                });
                            });
                        });
                    });
                }
                catch (ParseException e) {
                    future.completeExceptionally(new PlcException("Error loading the table sizes", e));
                }
            });
        });
        return future;
    }

    @Override
    public void onDisconnect(ConversationContext<AmsTCPPacket> context) {
        super.onDisconnect(context);
    }

    @Override
    public CompletableFuture<PlcBrowseResponse> browse(PlcBrowseRequest browseRequest) {
        return this.browseWithInterceptor(browseRequest, item -> true);
    }

    @Override
    public CompletableFuture<PlcBrowseResponse> browseWithInterceptor(PlcBrowseRequest browseRequest, PlcBrowseRequestInterceptor interceptor) {
        CompletableFuture<PlcBrowseResponse> future = new CompletableFuture<PlcBrowseResponse>();
        HashMap<String, PlcResponseCode> responseCodes = new HashMap<String, PlcResponseCode>();
        HashMap<String, List<PlcBrowseItem>> values = new HashMap<String, List<PlcBrowseItem>>();
        for (String queryName : browseRequest.getQueryNames()) {
            ArrayList<DefaultPlcBrowseItem> resultsForQuery = new ArrayList<DefaultPlcBrowseItem>();
            for (AdsSymbolTableEntry symbol : this.symbolTable.values()) {
                AdsDataTypeTableEntry dataType = this.dataTypeTable.get(symbol.getDataTypeName());
                if (dataType == null) {
                    System.out.printf("couldn't find datatype: %s%n", symbol.getDataTypeName());
                    continue;
                }
                String itemName = symbol.getComment() == null || symbol.getComment().isEmpty() ? symbol.getName() : symbol.getComment();
                PlcValueType plc4xPlcValueType = PlcValueType.valueOf(this.getPlcValueTypeForAdsDataType(dataType).toString());
                List<PlcBrowseItem> children = this.getBrowseItems(symbol.getName(), symbol.getGroup(), symbol.getOffset(), !symbol.getFlagReadOnly(), dataType);
                HashMap<String, PlcBrowseItem> childMap = new HashMap<String, PlcBrowseItem>();
                for (PlcBrowseItem child : children) {
                    childMap.put(child.getName(), child);
                }
                HashMap<String, PlcValue> options = new HashMap<String, PlcValue>();
                options.put("comment", new PlcSTRING(symbol.getComment()));
                options.put("group-id", new PlcUDINT(symbol.getGroup()));
                options.put("offset", new PlcUDINT(symbol.getOffset()));
                options.put("size-in-bytes", new PlcUDINT(symbol.getSize()));
                if (plc4xPlcValueType == PlcValueType.List) {
                    ArrayList<ArrayInfo> arrayInfo = new ArrayList<ArrayInfo>();
                    for (AdsDataTypeArrayInfo adsDataTypeArrayInfo : dataType.getArrayInfo()) {
                        arrayInfo.add(new DefaultArrayInfo((int)adsDataTypeArrayInfo.getLowerBound(), (int)adsDataTypeArrayInfo.getUpperBound()));
                    }
                    DefaultListPlcBrowseItem item = new DefaultListPlcBrowseItem(new SymbolicAdsTag(symbol.getName(), plc4xPlcValueType, arrayInfo), itemName, true, !symbol.getFlagReadOnly(), true, childMap, options);
                    if (!interceptor.intercept(item)) continue;
                    resultsForQuery.add(item);
                    continue;
                }
                DefaultPlcBrowseItem item = new DefaultPlcBrowseItem(new SymbolicAdsTag(symbol.getName(), plc4xPlcValueType, Collections.emptyList()), itemName, true, !symbol.getFlagReadOnly(), true, childMap, options);
                if (!interceptor.intercept(item)) continue;
                resultsForQuery.add(item);
            }
            responseCodes.put(queryName, PlcResponseCode.OK);
            values.put(queryName, resultsForQuery);
        }
        DefaultPlcBrowseResponse response = new DefaultPlcBrowseResponse(browseRequest, responseCodes, values);
        future.complete(response);
        return future;
    }

    protected List<PlcBrowseItem> getBrowseItems(String basePath, long baseGroupId, long baseOffset, boolean parentWritable, AdsDataTypeTableEntry dataType) {
        if (dataType.getNumChildren() == 0) {
            return Collections.emptyList();
        }
        ArrayList<PlcBrowseItem> values = new ArrayList<PlcBrowseItem>(dataType.getNumChildren());
        for (AdsDataTypeTableChildEntry child : dataType.getChildren()) {
            AdsDataTypeTableEntry childDataType = this.dataTypeTable.get(child.getDataTypeName());
            if (childDataType == null) {
                System.out.printf("couldn't find datatype: %s%n", child.getDataTypeName());
                continue;
            }
            String itemAddress = String.valueOf(basePath) + "." + child.getPropertyName();
            String itemName = child.getComment() == null || child.getComment().isEmpty() ? child.getPropertyName() : child.getComment();
            PlcValueType plc4xPlcValueType = PlcValueType.valueOf(this.getPlcValueTypeForAdsDataType(childDataType).toString());
            List<PlcBrowseItem> children = this.getBrowseItems(itemAddress, baseGroupId, baseOffset + child.getOffset(), parentWritable, childDataType);
            HashMap<String, PlcBrowseItem> childMap = new HashMap<String, PlcBrowseItem>();
            for (PlcBrowseItem ch : children) {
                childMap.put(ch.getName(), ch);
            }
            HashMap<String, PlcValue> options = new HashMap<String, PlcValue>();
            options.put("comment", new PlcSTRING(child.getComment()));
            options.put("group-id", new PlcUDINT(baseGroupId));
            options.put("offset", new PlcUDINT(baseOffset + child.getOffset()));
            options.put("size-in-bytes", new PlcUDINT(childDataType.getSize()));
            if (plc4xPlcValueType == PlcValueType.List) {
                ArrayList<ArrayInfo> arrayInfo = new ArrayList<ArrayInfo>();
                for (AdsDataTypeArrayInfo adsDataTypeArrayInfo : childDataType.getArrayInfo()) {
                    arrayInfo.add(new DefaultArrayInfo((int)adsDataTypeArrayInfo.getLowerBound(), (int)adsDataTypeArrayInfo.getUpperBound()));
                }
                values.add(new DefaultListPlcBrowseItem(new SymbolicAdsTag(String.valueOf(basePath) + "." + child.getPropertyName(), plc4xPlcValueType, arrayInfo), itemName, true, parentWritable, true, childMap, options));
                continue;
            }
            values.add(new DefaultPlcBrowseItem(new SymbolicAdsTag(String.valueOf(basePath) + "." + child.getPropertyName(), plc4xPlcValueType, Collections.emptyList()), itemName, true, parentWritable, true, childMap, options));
        }
        return values;
    }

    @Override
    public CompletableFuture<PlcPingResponse> ping(PlcPingRequest pingRequest) {
        CompletableFuture<PlcPingResponse> future = new CompletableFuture<PlcPingResponse>();
        AdsReadDeviceInfoRequest readDeviceInfoRequest = new AdsReadDeviceInfoRequest(this.configuration.getTargetAmsNetId(), DefaultAmsPorts.RUNTIME_SYSTEM_01.getValue(), this.configuration.getSourceAmsNetId(), 800, 0L, this.getInvokeId());
        RequestTransactionManager.RequestTransaction readDeviceInfoTx = this.tm.startRequest();
        readDeviceInfoTx.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest(new AmsTCPPacket(readDeviceInfoRequest)).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(e -> {
                ChannelPipeline channelPipeline = this.context.getChannel().pipeline().fireExceptionCaught((Throwable)e);
            }).onError((p, e) -> {
                ChannelPipeline channelPipeline = this.context.getChannel().pipeline().fireExceptionCaught((Throwable)e);
            }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == readDeviceInfoRequest.getInvokeId()).only(AdsReadDeviceInfoResponse.class).handle(readDeviceInfoResponse -> {
                readDeviceInfoTx.endRequest();
                future.complete(new DefaultPlcPingResponse(pingRequest, PlcResponseCode.OK));
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<Map<AdsTag, DirectAdsTag>> directAdsTagsFuture = this.getDirectAddresses(readRequest.getTags());
        if (directAdsTagsFuture.isDone()) {
            Map resolvedTags = directAdsTagsFuture.getNow(null);
            if (resolvedTags != null) {
                return this.executeRead(readRequest, resolvedTags);
            }
            CompletableFuture<PlcReadResponse> errorFuture = new CompletableFuture<PlcReadResponse>();
            errorFuture.completeExceptionally(new PlcException("Tags are null"));
            return errorFuture;
        }
        CompletableFuture<PlcReadResponse> delayedRead = new CompletableFuture<PlcReadResponse>();
        directAdsTagsFuture.handle((directAdsTags, throwable) -> {
            if (directAdsTags != null) {
                CompletableFuture<PlcReadResponse> delayedResponse = this.executeRead(readRequest, (Map<AdsTag, DirectAdsTag>)directAdsTags);
                delayedResponse.handle((plcReadResponse, throwable1) -> {
                    if (plcReadResponse != null) {
                        delayedRead.complete((PlcReadResponse)plcReadResponse);
                    } else {
                        delayedRead.completeExceptionally((Throwable)throwable1);
                    }
                    return this;
                });
            } else {
                delayedRead.completeExceptionally((Throwable)throwable);
            }
            return this;
        });
        return delayedRead;
    }

    protected CompletableFuture<PlcReadResponse> executeRead(PlcReadRequest readRequest, Map<AdsTag, DirectAdsTag> resolvedTags) {
        if (resolvedTags.size() == 1) {
            return this.singleRead(readRequest, resolvedTags.values().stream().findFirst().get());
        }
        return this.multiRead(readRequest, resolvedTags);
    }

    protected CompletableFuture<PlcReadResponse> singleRead(PlcReadRequest readRequest, DirectAdsTag directAdsTag) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        String dataTypeName = directAdsTag.getPlcDataType();
        AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(dataTypeName);
        long size = adsDataTypeTableEntry == null ? (long)AdsDataType.valueOf(dataTypeName).getNumBytes() : adsDataTypeTableEntry.getSize();
        AdsReadRequest amsPacket = new AdsReadRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), directAdsTag.getIndexGroup(), directAdsTag.getIndexOffset(), size * (long)directAdsTag.getNumberOfElements());
        AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest(amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == amsPacket.getInvokeId()).only(AdsReadResponse.class).handle(response -> {
                if (response.getResult() == ReturnCode.OK) {
                    PlcReadResponse plcReadResponse = this.convertToPlc4xReadResponse(readRequest, (AmsPacket)response);
                    future.complete(plcReadResponse);
                } else {
                    future.completeExceptionally(new PlcException("Result is " + (Object)((Object)response.getResult())));
                }
                transaction.endRequest();
            });
        });
        return future;
    }

    protected CompletableFuture<PlcReadResponse> multiRead(PlcReadRequest readRequest, Map<AdsTag, DirectAdsTag> resolvedTags) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        long expectedResponseDataSize = resolvedTags.values().stream().mapToLong(tag -> {
            String dataTypeName = tag.getPlcDataType();
            AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(dataTypeName);
            long size = adsDataTypeTableEntry == null ? (long)AdsDataType.valueOf(dataTypeName).getNumBytes() : adsDataTypeTableEntry.getSize();
            return 4L + size * (long)tag.getNumberOfElements();
        }).sum();
        AdsReadWriteRequest amsPacket = new AdsReadWriteRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_MULTIPLE_READ.getValue(), resolvedTags.size(), expectedResponseDataSize, readRequest.getTagNames().stream().map(tagName -> {
            AdsTag tag = (AdsTag)readRequest.getTag((String)tagName);
            DirectAdsTag directAdsTag = (DirectAdsTag)resolvedTags.get(tag);
            String dataTypeName = directAdsTag.getPlcDataType();
            AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(dataTypeName);
            long size = adsDataTypeTableEntry == null ? (long)AdsDataType.valueOf(dataTypeName).getNumBytes() : adsDataTypeTableEntry.getSize();
            return new AdsMultiRequestItemRead(directAdsTag.getIndexGroup(), directAdsTag.getIndexOffset(), size * (long)directAdsTag.getNumberOfElements());
        }).collect(Collectors.toList()), null);
        AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest(amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == amsPacket.getInvokeId()).only(AdsReadWriteResponse.class).handle(response -> {
                if (response.getResult() == ReturnCode.OK) {
                    PlcReadResponse plcReadResponse = this.convertToPlc4xReadResponse(readRequest, (AmsPacket)response);
                    future.complete(plcReadResponse);
                } else if (response.getResult() == ReturnCode.ADSERR_DEVICE_INVALIDSIZE) {
                    future.completeExceptionally(new PlcException("The parameter size was not correct (Internal error)"));
                } else {
                    future.completeExceptionally(new PlcException("Unexpected result " + (Object)((Object)response.getResult())));
                }
                transaction.endRequest();
            });
        });
        return future;
    }

    protected PlcReadResponse convertToPlc4xReadResponse(PlcReadRequest readRequest, AmsPacket adsData) {
        ReadBufferByteBased readBuffer = null;
        HashMap<String, PlcResponseCode> responseCodes = new HashMap<String, PlcResponseCode>();
        if (adsData instanceof AdsReadResponse) {
            AdsReadResponse adsReadResponse = (AdsReadResponse)adsData;
            readBuffer = new ReadBufferByteBased(adsReadResponse.getData(), ByteOrder.LITTLE_ENDIAN);
            responseCodes.put(readRequest.getTagNames().stream().findFirst().orElse(""), this.parsePlcResponseCode(adsReadResponse.getResult()));
        } else if (adsData instanceof AdsReadWriteResponse) {
            AdsReadWriteResponse adsReadWriteResponse = (AdsReadWriteResponse)adsData;
            readBuffer = new ReadBufferByteBased(adsReadWriteResponse.getData(), ByteOrder.LITTLE_ENDIAN);
            for (String tagName : readRequest.getTagNames()) {
                try {
                    ReturnCode result = ReturnCode.enumForValue(readBuffer.readUnsignedLong(32, new WithReaderArgs[0]));
                    responseCodes.put(tagName, this.parsePlcResponseCode(result));
                }
                catch (ParseException e) {
                    responseCodes.put(tagName, PlcResponseCode.INTERNAL_ERROR);
                }
            }
        }
        if (readBuffer != null) {
            HashMap<String, ResponseItem<PlcValue>> values = new HashMap<String, ResponseItem<PlcValue>>();
            for (String tagName : readRequest.getTagNames()) {
                DirectAdsTag tag;
                if (readRequest.getTag(tagName) instanceof DirectAdsTag) {
                    tag = (DirectAdsTag)readRequest.getTag(tagName);
                } else {
                    SymbolicAdsTag symbolicAdsTag = (SymbolicAdsTag)readRequest.getTag(tagName);
                    tag = this.getDirectAdsTagForSymbolicName(symbolicAdsTag);
                }
                if (responseCodes.get(tagName) != PlcResponseCode.OK) {
                    values.put(tagName, new ResponseItem<Object>((PlcResponseCode)((Object)responseCodes.get(tagName)), null));
                    continue;
                }
                values.put(tagName, this.parseResponseItem(tag, readBuffer));
            }
            return new DefaultPlcReadResponse(readRequest, values);
        }
        return null;
    }

    private PlcResponseCode parsePlcResponseCode(ReturnCode adsResult) {
        if (adsResult == ReturnCode.OK) {
            return PlcResponseCode.OK;
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    private ResponseItem<PlcValue> parseResponseItem(DirectAdsTag tag, ReadBuffer readBuffer) {
        try {
            AdsDataTypeTableEntry adsDataTypeTableEntry;
            String dataTypeName = tag.getPlcDataType();
            if (this.dataTypeTable.containsKey(dataTypeName)) {
                adsDataTypeTableEntry = this.dataTypeTable.get(dataTypeName);
            } else {
                AdsDataType adsDataType = AdsDataType.valueOf(dataTypeName);
                adsDataTypeTableEntry = new AdsDataTypeTableEntry(0L, 0L, 0L, 0L, adsDataType.getNumBytes(), 0L, 0L, 0L, 0, 0, dataTypeName, dataTypeName, "", Collections.emptyList(), Collections.emptyList(), new byte[0]);
            }
            org.apache.plc4x.java.ads.readwrite.PlcValueType plcValueType = this.getPlcValueTypeForAdsDataType(adsDataTypeTableEntry);
            int strLen = 0;
            if (tag instanceof DirectAdsStringTag) {
                strLen = ((DirectAdsStringTag)tag).getStringLength();
            }
            int stringLength = strLen;
            if (tag.getNumberOfElements() == 1) {
                ReadBufferByteBased readBufferByteBased = (ReadBufferByteBased)readBuffer;
                int remainingBytes = readBufferByteBased.getTotalBytes() - readBufferByteBased.getPos();
                int singleStringLength = Math.min(remainingBytes - 1, stringLength);
                return new ResponseItem<PlcValue>(PlcResponseCode.OK, this.parsePlcValue(plcValueType, adsDataTypeTableEntry, singleStringLength, readBuffer));
            }
            Object[] resultItems = (PlcValue[])IntStream.range(0, tag.getNumberOfElements()).mapToObj(i -> {
                try {
                    return this.parsePlcValue(plcValueType, adsDataTypeTableEntry, stringLength, readBuffer);
                }
                catch (ParseException e) {
                    LOGGER.warn("Error parsing tag item of type: '{}' (at position {}})", new Object[]{tag.getPlcDataType(), i, e});
                    return null;
                }
            }).toArray(PlcValue[]::new);
            return new ResponseItem<PlcValue>(PlcResponseCode.OK, PlcValueHandler.of(resultItems));
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Error parsing tag item of type: '%s'", tag.getPlcDataType()), (Throwable)e);
            return new ResponseItem<Object>(PlcResponseCode.INTERNAL_ERROR, null);
        }
    }

    private PlcValue parsePlcValue(org.apache.plc4x.java.ads.readwrite.PlcValueType plcValueType, AdsDataTypeTableEntry adsDataTypeTableEntry, int stringLength, ReadBuffer readBuffer) throws ParseException {
        switch (plcValueType) {
            case Struct: {
                HashMap<String, PlcValue> properties = new HashMap<String, PlcValue>();
                int startPos = readBuffer.getPos();
                int curPos = 0;
                for (AdsDataTypeTableChildEntry child : adsDataTypeTableEntry.getChildren()) {
                    if (child.getOffset() > (long)curPos) {
                        long skipBytes = child.getOffset() - (long)curPos;
                        long i = 0L;
                        while (i < skipBytes) {
                            readBuffer.readByte(new WithReaderArgs[0]);
                            ++i;
                        }
                    }
                    String propertyName = child.getPropertyName();
                    AdsDataTypeTableEntry propertyDataTypeTableEntry = this.dataTypeTable.get(child.getDataTypeName());
                    org.apache.plc4x.java.ads.readwrite.PlcValueType propertyPlcValueType = this.getPlcValueTypeForAdsDataType(propertyDataTypeTableEntry);
                    int strLen = 0;
                    if (propertyPlcValueType == org.apache.plc4x.java.ads.readwrite.PlcValueType.STRING || propertyPlcValueType == org.apache.plc4x.java.ads.readwrite.PlcValueType.WSTRING) {
                        String dataTypeName = propertyDataTypeTableEntry.getDataTypeName();
                        strLen = Integer.parseInt(dataTypeName.substring(dataTypeName.indexOf("(") + 1, dataTypeName.indexOf(")")));
                    }
                    PlcValue propertyValue = this.parsePlcValue(propertyPlcValueType, propertyDataTypeTableEntry, strLen, readBuffer);
                    properties.put(propertyName, propertyValue);
                    curPos = readBuffer.getPos() - startPos;
                }
                return new PlcStruct(properties);
            }
            case List: {
                return this.parseArrayLevel(adsDataTypeTableEntry, adsDataTypeTableEntry.getArrayInfo(), readBuffer);
            }
        }
        return DataItem.staticParse(readBuffer, plcValueType, stringLength);
    }

    private PlcValue parseArrayLevel(AdsDataTypeTableEntry adsDataTypeTableEntry, List<AdsDataTypeArrayInfo> arrayLayers, ReadBuffer readBuffer) throws ParseException {
        if (arrayLayers.isEmpty()) {
            String dataTypeName = adsDataTypeTableEntry.getDataTypeName();
            dataTypeName = dataTypeName.substring(dataTypeName.lastIndexOf(" OF ") + 4);
            int stringLength = 0;
            if (dataTypeName.startsWith("STRING(")) {
                stringLength = Integer.parseInt(dataTypeName.substring(7, dataTypeName.length() - 1));
            } else if (dataTypeName.startsWith("WSTRING(")) {
                stringLength = Integer.parseInt(dataTypeName.substring(8, dataTypeName.length() - 1));
            }
            AdsDataTypeTableEntry elementDataTypeTableEntry = this.dataTypeTable.get(dataTypeName);
            org.apache.plc4x.java.ads.readwrite.PlcValueType plcValueType = this.getPlcValueTypeForAdsDataType(elementDataTypeTableEntry);
            return this.parsePlcValue(plcValueType, elementDataTypeTableEntry, stringLength, readBuffer);
        }
        ArrayList<PlcValue> elements = new ArrayList<PlcValue>();
        List<AdsDataTypeArrayInfo> arrayInfo = adsDataTypeTableEntry.getArrayInfo();
        AdsDataTypeArrayInfo firstLayer = arrayInfo.get(0);
        int i = 0;
        while ((long)i < firstLayer.getNumElements()) {
            List<AdsDataTypeArrayInfo> remainingLayers = arrayInfo.subList(1, arrayInfo.size());
            elements.add(this.parseArrayLevel(adsDataTypeTableEntry, remainingLayers, readBuffer));
            ++i;
        }
        return new PlcList(elements);
    }

    @Override
    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<Map<AdsTag, DirectAdsTag>> directAdsTagsFuture = this.getDirectAddresses(writeRequest.getTags());
        if (directAdsTagsFuture.isDone()) {
            Map resolvedTags = directAdsTagsFuture.getNow(null);
            if (resolvedTags != null) {
                return this.executeWrite(writeRequest, resolvedTags);
            }
            CompletableFuture<PlcWriteResponse> errorFuture = new CompletableFuture<PlcWriteResponse>();
            errorFuture.completeExceptionally(new PlcException("Tags are null"));
            return errorFuture;
        }
        CompletableFuture<PlcWriteResponse> delayedWrite = new CompletableFuture<PlcWriteResponse>();
        directAdsTagsFuture.handle((directAdsTags, throwable) -> {
            if (directAdsTags != null) {
                CompletableFuture<PlcWriteResponse> delayedResponse = this.executeWrite(writeRequest, (Map<AdsTag, DirectAdsTag>)directAdsTags);
                delayedResponse.handle((plcReadResponse, throwable1) -> {
                    if (plcReadResponse != null) {
                        delayedWrite.complete((PlcWriteResponse)plcReadResponse);
                    } else {
                        delayedWrite.completeExceptionally((Throwable)throwable1);
                    }
                    return this;
                });
            } else {
                delayedWrite.completeExceptionally((Throwable)throwable);
            }
            return this;
        });
        return delayedWrite;
    }

    protected CompletableFuture<PlcWriteResponse> executeWrite(PlcWriteRequest writeRequest, Map<AdsTag, DirectAdsTag> resolvedTags) {
        if (resolvedTags.size() == 1) {
            return this.singleWrite(writeRequest, resolvedTags.values().stream().findFirst().get());
        }
        return this.multiWrite(writeRequest, resolvedTags);
    }

    protected CompletableFuture<PlcWriteResponse> singleWrite(PlcWriteRequest writeRequest, DirectAdsTag directAdsTag) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        String tagName = (String)writeRequest.getTagNames().iterator().next();
        PlcValue plcValue = writeRequest.getPlcValue(tagName);
        try {
            byte[] serializedValue = this.serializePlcValue(plcValue, directAdsTag.getPlcDataType());
            AdsWriteRequest amsPacket = new AdsWriteRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), directAdsTag.getIndexGroup(), directAdsTag.getIndexOffset(), serializedValue);
            AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.context.sendRequest(amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == amsPacket.getInvokeId()).only(AdsWriteResponse.class).handle(response -> {
                    if (response.getResult() == ReturnCode.OK) {
                        PlcWriteResponse plcWriteResponse = this.convertToPlc4xWriteResponse(writeRequest, (AmsPacket)response);
                        future.complete(plcWriteResponse);
                    } else {
                        future.completeExceptionally(new PlcException("Unexpected return code " + (Object)((Object)response.getResult())));
                    }
                    transaction.endRequest();
                });
            });
        }
        catch (Exception e) {
            future.completeExceptionally(new PlcException("Error", e));
        }
        return future;
    }

    protected CompletableFuture<PlcWriteResponse> multiWrite(PlcWriteRequest writeRequest, Map<AdsTag, DirectAdsTag> resolvedTags) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        int numTags = writeRequest.getTags().size();
        ArrayList<byte[]> serializedTags = new ArrayList<byte[]>(numTags);
        LinkedHashMap<Object, AdsDataTypeTableEntry> directAdsTags = new LinkedHashMap<Object, AdsDataTypeTableEntry>(numTags);
        for (String tagName : writeRequest.getTagNames()) {
            AdsTag tag = (AdsTag)writeRequest.getTag(tagName);
            DirectAdsTag directAdsTag = resolvedTags.get(tag);
            PlcValue plcValue = writeRequest.getPlcValue(tagName);
            AdsDataTypeTableEntry dataType = this.dataTypeTable.get(directAdsTag.getPlcDataType());
            try {
                byte[] serializedValue = this.serializePlcValue(plcValue, directAdsTag.getPlcDataType());
                serializedTags.add(serializedValue);
                directAdsTags.put(directAdsTag, dataType);
            }
            catch (Exception e) {
                future.completeExceptionally(new PlcException("Error serializing data", e));
                return future;
            }
        }
        int serializedSize = serializedTags.stream().mapToInt(serializedTag -> ((byte[])serializedTag).length).sum();
        WriteBufferByteBased writeBuffer = new WriteBufferByteBased(serializedSize);
        for (byte[] serializedTag2 : serializedTags) {
            try {
                writeBuffer.writeByteArray("", serializedTag2, new WithWriterArgs[0]);
            }
            catch (SerializationException e) {
                future.completeExceptionally(new PlcException("Error serializing data", e));
                return future;
            }
        }
        AdsReadWriteRequest amsPacket = new AdsReadWriteRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_MULTIPLE_WRITE.getValue(), serializedSize, (long)numTags * 4L, directAdsTags.entrySet().stream().map(entry -> new AdsMultiRequestItemWrite(((DirectAdsTag)entry.getKey()).getIndexGroup(), ((DirectAdsTag)entry.getKey()).getIndexOffset(), ((AdsDataTypeTableEntry)entry.getValue()).getEntryLength())).collect(Collectors.toList()), writeBuffer.getBytes());
        AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest(amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == amsPacket.getInvokeId()).only(AdsReadWriteResponse.class).handle(response -> {
                if (response.getResult() == ReturnCode.OK) {
                    PlcWriteResponse plcWriteResponse = this.convertToPlc4xWriteResponse(writeRequest, (AmsPacket)response);
                    future.complete(plcWriteResponse);
                } else {
                    future.completeExceptionally(new PlcException("Error"));
                }
                transaction.endRequest();
            });
        });
        return future;
    }

    protected byte[] serializePlcValue(PlcValue plcValue, String datatypeName) throws SerializationException {
        if (!this.dataTypeTable.containsKey(datatypeName)) {
            throw new SerializationException("Could not find data type: " + datatypeName);
        }
        AdsDataTypeTableEntry dataType = this.dataTypeTable.get(datatypeName);
        WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)dataType.getSize(), ByteOrder.LITTLE_ENDIAN);
        List<AdsDataTypeArrayInfo> arrayInfo = dataType.getArrayInfo();
        this.serializeInternal(plcValue, dataType, arrayInfo, writeBuffer);
        return writeBuffer.getBytes();
    }

    protected void serializeInternal(PlcValue contextValue, AdsDataTypeTableEntry dataType, List<AdsDataTypeArrayInfo> arrayInfo, WriteBufferByteBased writeBuffer) throws SerializationException {
        if (!arrayInfo.isEmpty()) {
            if (!contextValue.isList()) {
                throw new SerializationException("Expected a PlcList, but got a " + contextValue.getPlcValueType().name());
            }
            AdsDataTypeArrayInfo curArrayLevel = arrayInfo.get(0);
            List<? extends PlcValue> list = contextValue.getList();
            if (curArrayLevel.getNumElements() != (long)list.size()) {
                throw new SerializationException(String.format("Expected a PlcList of size %d, but got one of size %d", curArrayLevel.getNumElements(), list.size()));
            }
            for (PlcValue plcValue : list) {
                this.serializeInternal(plcValue, dataType, arrayInfo.subList(1, arrayInfo.size()), writeBuffer);
            }
        } else if (!dataType.getChildren().isEmpty()) {
            if (!contextValue.isStruct()) {
                throw new SerializationException("Expected a PlcStruct, but got a " + contextValue.getPlcValueType().name());
            }
            PlcStruct plcStruct = (PlcStruct)contextValue;
            int startPos = writeBuffer.getPos();
            boolean bl = false;
            for (AdsDataTypeTableChildEntry child : dataType.getChildren()) {
                int n;
                AdsDataTypeTableEntry childDataType = this.dataTypeTable.get(child.getDataTypeName());
                if (!plcStruct.hasKey(child.getPropertyName())) {
                    throw new SerializationException("PlcStruct is missing a child with the name " + child.getPropertyName());
                }
                if (child.getOffset() > (long)n) {
                    long fillBytes = child.getOffset() - (long)n;
                    long i = 0L;
                    while (i < fillBytes) {
                        writeBuffer.writeByte("fillByte", (byte)0, new WithWriterArgs[0]);
                        ++i;
                    }
                }
                PlcValue childValue = plcStruct.getValue(child.getPropertyName());
                this.serializeInternal(childValue, childDataType, childDataType.getArrayInfo(), writeBuffer);
                n = writeBuffer.getPos() - startPos;
            }
        } else {
            org.apache.plc4x.java.ads.readwrite.PlcValueType plcValueType = this.getPlcValueTypeForAdsDataType(dataType);
            if (plcValueType == null) {
                throw new SerializationException("Unsupported simple type: " + dataType.getDataTypeName());
            }
            int stringLength = 0;
            if (plcValueType == org.apache.plc4x.java.ads.readwrite.PlcValueType.STRING || plcValueType == org.apache.plc4x.java.ads.readwrite.PlcValueType.WSTRING) {
                String string = dataType.getDataTypeName();
                stringLength = Integer.parseInt(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
            }
            DataItem.staticSerialize(writeBuffer, contextValue, plcValueType, stringLength);
        }
    }

    protected PlcWriteResponse convertToPlc4xWriteResponse(PlcWriteRequest writeRequest, AmsPacket adsData) {
        HashMap<String, PlcResponseCode> responseCodes = new HashMap<String, PlcResponseCode>();
        if (adsData instanceof AdsWriteResponse) {
            AdsWriteResponse adsWriteResponse = (AdsWriteResponse)adsData;
            responseCodes.put(writeRequest.getTagNames().stream().findFirst().orElse(""), this.parsePlcResponseCode(adsWriteResponse.getResult()));
        } else if (adsData instanceof AdsReadWriteResponse) {
            AdsReadWriteResponse adsReadWriteResponse = (AdsReadWriteResponse)adsData;
            ReadBufferByteBased readBuffer = new ReadBufferByteBased(adsReadWriteResponse.getData(), ByteOrder.LITTLE_ENDIAN);
            for (String tagName : writeRequest.getTagNames()) {
                try {
                    ReturnCode result = ReturnCode.enumForValue(readBuffer.readUnsignedLong(32, new WithReaderArgs[0]));
                    responseCodes.put(tagName, this.parsePlcResponseCode(result));
                }
                catch (ParseException e) {
                    responseCodes.put(tagName, PlcResponseCode.INTERNAL_ERROR);
                }
            }
        }
        return new DefaultPlcWriteResponse(writeRequest, responseCodes);
    }

    @Override
    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        CompletableFuture<Map<AdsTag, DirectAdsTag>> directAdsTagFutures = this.getDirectAddresses(subscriptionRequest.getTags().stream().map(tag -> ((DefaultPlcSubscriptionTag)tag).getTag()).collect(Collectors.toList()));
        if (directAdsTagFutures.isDone()) {
            Map resolvedTags = directAdsTagFutures.getNow(null);
            if (resolvedTags != null) {
                return this.executeSubscribe(subscriptionRequest, resolvedTags);
            }
            CompletableFuture<PlcSubscriptionResponse> errorFuture = new CompletableFuture<PlcSubscriptionResponse>();
            errorFuture.completeExceptionally(new PlcException("Tags are null"));
            return errorFuture;
        }
        CompletableFuture<PlcSubscriptionResponse> delayedSubscribe = new CompletableFuture<PlcSubscriptionResponse>();
        directAdsTagFutures.handle((tagMapping, throwable) -> {
            if (tagMapping != null) {
                CompletableFuture<PlcSubscriptionResponse> delayedResponse = this.executeSubscribe(subscriptionRequest, (Map<AdsTag, DirectAdsTag>)tagMapping);
                delayedResponse.handle((plcSubscribeResponse, throwable1) -> {
                    if (plcSubscribeResponse != null) {
                        delayedSubscribe.complete((PlcSubscriptionResponse)plcSubscribeResponse);
                    } else {
                        delayedSubscribe.completeExceptionally((Throwable)throwable1);
                    }
                    return this;
                });
            } else {
                delayedSubscribe.completeExceptionally((Throwable)throwable);
            }
            return this;
        });
        return delayedSubscribe;
    }

    private CompletableFuture<PlcSubscriptionResponse> executeSubscribe(PlcSubscriptionRequest subscribeRequest, Map<AdsTag, DirectAdsTag> resolvedTags) {
        CompletableFuture<PlcSubscriptionResponse> future = new CompletableFuture<PlcSubscriptionResponse>();
        List amsTCPPackets = subscribeRequest.getTags().stream().map(tag -> (DefaultPlcSubscriptionTag)tag).map(tag -> {
            AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(((DirectAdsTag)resolvedTags.get((AdsTag)tag.getTag())).getPlcDataType());
            DirectAdsTag directAdsTag = this.getDirectAdsTagForSymbolicName(tag.getTag());
            int numberOfElements = tag.getArrayInfo().size() == 0 ? 1 : tag.getArrayInfo().get(0).getSize();
            return new AmsTCPPacket(new AdsAddDeviceNotificationRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), directAdsTag.getIndexGroup(), directAdsTag.getIndexOffset(), adsDataTypeTableEntry.getSize() * (long)numberOfElements, tag.getPlcSubscriptionType() == PlcSubscriptionType.CYCLIC ? AdsTransMode.CYCLIC : AdsTransMode.ON_CHANGE, 0L, tag.getDuration().orElse(Duration.ZERO).toMillis()));
        }).collect(Collectors.toList());
        HashMap<String, ResponseItem<PlcSubscriptionHandle>> responses = new HashMap<String, ResponseItem<PlcSubscriptionHandle>>();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(this.subscribeRecursively(subscribeRequest, subscribeRequest.getTagNames().iterator(), resolvedTags, responses, future, amsTCPPackets.iterator(), transaction));
        return future;
    }

    private Runnable subscribeRecursively(PlcSubscriptionRequest subscriptionRequest, Iterator<String> tagNames, Map<AdsTag, DirectAdsTag> resolvedTags, Map<String, ResponseItem<PlcSubscriptionHandle>> responses, CompletableFuture<PlcSubscriptionResponse> future, Iterator<AmsTCPPacket> amsTCPPackets, RequestTransactionManager.RequestTransaction transaction) {
        return () -> {
            AmsTCPPacket packet = (AmsTCPPacket)amsTCPPackets.next();
            boolean hasMorePackets = amsTCPPackets.hasNext();
            String tagName = (String)tagNames.next();
            this.context.sendRequest(packet).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == packet.getUserdata().getInvokeId()).only(AdsAddDeviceNotificationResponse.class).handle(response -> {
                if (response.getResult() == ReturnCode.OK) {
                    DefaultPlcSubscriptionTag subscriptionTag = (DefaultPlcSubscriptionTag)subscriptionRequest.getTag(tagName);
                    AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(((DirectAdsTag)resolvedTags.get((AdsTag)subscriptionTag.getTag())).getPlcDataType());
                    responses.put(tagName, new ResponseItem<AdsSubscriptionHandle>(this.parsePlcResponseCode(response.getResult()), new AdsSubscriptionHandle(this, tagName, adsDataTypeTableEntry, response.getNotificationHandle())));
                    if (!hasMorePackets) {
                        DefaultPlcSubscriptionResponse plcSubscriptionResponse = new DefaultPlcSubscriptionResponse(subscriptionRequest, responses);
                        future.complete(plcSubscriptionResponse);
                    }
                } else if (response.getResult() == ReturnCode.ADSERR_DEVICE_INVALIDSIZE) {
                    future.completeExceptionally(new PlcException("The parameter size was not correct (Internal error)"));
                } else {
                    future.completeExceptionally(new PlcException("Unexpected result " + (Object)((Object)response.getResult())));
                }
                transaction.endRequest();
                if (hasMorePackets) {
                    RequestTransactionManager.RequestTransaction nextTransaction = this.tm.startRequest();
                    nextTransaction.submit(this.subscribeRecursively(subscriptionRequest, tagNames, resolvedTags, responses, future, amsTCPPackets, nextTransaction));
                }
            });
        };
    }

    @Override
    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        CompletableFuture<PlcUnsubscriptionResponse> future = new CompletableFuture<PlcUnsubscriptionResponse>();
        ArrayList notificationHandles = new ArrayList();
        unsubscriptionRequest.getSubscriptionHandles().stream().filter(handle -> handle instanceof AdsSubscriptionHandle).map(handle -> (AdsSubscriptionHandle)handle).forEach(adsSubscriptionHandle -> {
            notificationHandles.add(adsSubscriptionHandle.getNotificationHandle());
            this.consumers.keySet().stream().filter(consumerRegistration -> consumerRegistration.getSubscriptionHandles().contains(adsSubscriptionHandle)).forEach(DefaultPlcConsumerRegistration::unregister);
        });
        List amsTCPPackets = notificationHandles.stream().map(data -> new AmsTCPPacket(new AdsDeleteDeviceNotificationRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), (long)data))).collect(Collectors.toList());
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(this.unsubscribeRecursively(unsubscriptionRequest, future, amsTCPPackets.iterator(), transaction));
        return future;
    }

    private Runnable unsubscribeRecursively(PlcUnsubscriptionRequest unsubscriptionRequest, CompletableFuture<PlcUnsubscriptionResponse> future, Iterator<AmsTCPPacket> amsTCPPackets, RequestTransactionManager.RequestTransaction transaction) {
        return () -> {
            AmsTCPPacket packet = (AmsTCPPacket)amsTCPPackets.next();
            boolean hasMorePackets = amsTCPPackets.hasNext();
            this.context.sendRequest(packet).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).unwrap(AmsTCPPacket::getUserdata).check(userdata -> userdata.getInvokeId() == packet.getUserdata().getInvokeId()).only(AdsDeleteDeviceNotificationResponse.class).handle(response -> {
                if (response.getResult() == ReturnCode.OK) {
                    if (!hasMorePackets) {
                        DefaultPlcUnsubscriptionResponse plcUnsubscriptionResponse = new DefaultPlcUnsubscriptionResponse(unsubscriptionRequest);
                        future.complete(plcUnsubscriptionResponse);
                    }
                } else if (response.getResult() == ReturnCode.ADSERR_DEVICE_NOTIFYHNDINVALID) {
                    future.completeExceptionally(new PlcException("The notification handle is invalid (Internal error)"));
                } else {
                    future.completeExceptionally(new PlcException("Unexpected result " + (Object)((Object)response.getResult())));
                }
                transaction.endRequest();
                if (hasMorePackets) {
                    RequestTransactionManager.RequestTransaction nextTransaction = this.tm.startRequest();
                    nextTransaction.submit(this.unsubscribeRecursively(unsubscriptionRequest, future, amsTCPPackets, nextTransaction));
                }
            });
        };
    }

    @Override
    protected void decode(ConversationContext<AmsTCPPacket> context, AmsTCPPacket msg) throws Exception {
        if (msg.getUserdata() instanceof AdsDeviceNotificationRequest) {
            AdsDeviceNotificationRequest notificationData = (AdsDeviceNotificationRequest)msg.getUserdata();
            List<AdsStampHeader> stamps = notificationData.getAdsStampHeaders();
            for (AdsStampHeader stamp : stamps) {
                long unixEpochTimestamp = stamp.getTimestamp().divide(BigInteger.valueOf(10000L)).longValue() - 11644473600000L;
                List<AdsNotificationSample> samples = stamp.getAdsNotificationSamples();
                for (AdsNotificationSample sample : samples) {
                    long handle = sample.getNotificationHandle();
                    for (DefaultPlcConsumerRegistration registration : this.consumers.keySet()) {
                        for (PlcSubscriptionHandle subscriptionHandle : registration.getSubscriptionHandles()) {
                            AdsSubscriptionHandle adsHandle;
                            if (!(subscriptionHandle instanceof AdsSubscriptionHandle) || (adsHandle = (AdsSubscriptionHandle)subscriptionHandle).getNotificationHandle() != handle) continue;
                            this.consumers.get(registration).accept(new DefaultPlcSubscriptionEvent(Instant.ofEpochMilli(unixEpochTimestamp), this.convertSampleToPlc4XResult(adsHandle, sample.getData())));
                        }
                    }
                }
            }
        }
    }

    private Map<String, ResponseItem<PlcValue>> convertSampleToPlc4XResult(AdsSubscriptionHandle subscriptionHandle, byte[] data) throws ParseException {
        HashMap<String, ResponseItem<PlcValue>> values = new HashMap<String, ResponseItem<PlcValue>>();
        ReadBufferByteBased readBuffer = new ReadBufferByteBased(data, ByteOrder.LITTLE_ENDIAN);
        values.put(subscriptionHandle.getTagName(), new ResponseItem<PlcValue>(PlcResponseCode.OK, DataItem.staticParse(readBuffer, this.getPlcValueTypeForAdsDataType(subscriptionHandle.getAdsDataType()), data.length)));
        return values;
    }

    @Override
    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        DefaultPlcConsumerRegistration consumerRegistration = new DefaultPlcConsumerRegistration(this, consumer, handles.toArray(new PlcSubscriptionHandle[0]));
        this.consumers.put(consumerRegistration, consumer);
        return consumerRegistration;
    }

    @Override
    public void unregister(PlcConsumerRegistration registration) {
        DefaultPlcConsumerRegistration consumerRegistration = (DefaultPlcConsumerRegistration)registration;
        this.consumers.remove(consumerRegistration);
    }

    protected CompletableFuture<Map<AdsTag, DirectAdsTag>> getDirectAddresses(List<PlcTag> tags) {
        CompletableFuture<Map<AdsTag, DirectAdsTag>> future = new CompletableFuture<Map<AdsTag, DirectAdsTag>>();
        List referencedSymbolicTags = tags.stream().filter(SymbolicAdsTag.class::isInstance).map(SymbolicAdsTag.class::cast).collect(Collectors.toList());
        List symbolicTagsNeedingResolution = referencedSymbolicTags.stream().filter(symbolicAdsTag -> this.getDirectAdsTagForSymbolicName((PlcTag)symbolicAdsTag) == null).collect(Collectors.toList());
        if (!symbolicTagsNeedingResolution.isEmpty()) {
            List<SymbolicAdsTag> requiredResolutionTags = symbolicTagsNeedingResolution.stream().filter(symbolicAdsTags -> !this.pendingResolutionRequests.containsKey(symbolicAdsTags)).collect(Collectors.toList());
            if (!requiredResolutionTags.isEmpty()) {
                CompletableFuture<Void> resolutionFuture;
                if (requiredResolutionTags.size() == 1) {
                    SymbolicAdsTag symbolicAdsTag2 = (SymbolicAdsTag)requiredResolutionTags.get(0);
                    resolutionFuture = this.resolveSingleSymbolicAddress(requiredResolutionTags.get(0));
                    this.pendingResolutionRequests.put(symbolicAdsTag2, resolutionFuture);
                } else {
                    resolutionFuture = this.resolveMultipleSymbolicAddresses(requiredResolutionTags);
                    for (SymbolicAdsTag symbolicAdsTag3 : requiredResolutionTags) {
                        this.pendingResolutionRequests.put(symbolicAdsTag3, resolutionFuture);
                    }
                }
            }
            CompletableFuture<Void> resolutionComplete = CompletableFuture.allOf((CompletableFuture[])symbolicTagsNeedingResolution.stream().map(this.pendingResolutionRequests::get).toArray(CompletableFuture[]::new));
            resolutionComplete.handleAsync((unused, throwable) -> {
                if (throwable != null) {
                    return future.completeExceptionally(throwable.getCause());
                }
                HashMap<AdsTag, DirectAdsTag> directAdsTagMapping = new HashMap<AdsTag, DirectAdsTag>(tags.size());
                for (PlcTag tag : tags) {
                    if (tag instanceof SymbolicAdsTag) {
                        directAdsTagMapping.put((AdsTag)tag, this.getDirectAdsTagForSymbolicName(tag));
                        continue;
                    }
                    directAdsTagMapping.put((AdsTag)tag, (DirectAdsTag)tag);
                }
                return future.complete(directAdsTagMapping);
            });
        } else {
            HashMap<AdsTag, DirectAdsTag> directAdsTagMapping = new HashMap<AdsTag, DirectAdsTag>(tags.size());
            for (PlcTag tag : tags) {
                if (tag instanceof SymbolicAdsTag) {
                    directAdsTagMapping.put((AdsTag)tag, this.getDirectAdsTagForSymbolicName(tag));
                    continue;
                }
                directAdsTagMapping.put((AdsTag)tag, (DirectAdsTag)tag);
            }
            future.complete(directAdsTagMapping);
        }
        return future;
    }

    protected CompletableFuture<Void> resolveSingleSymbolicAddress(SymbolicAdsTag symbolicAdsTag) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AdsReadWriteRequest amsPacket = new AdsReadWriteRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_SYM_HNDBYNAME.getValue(), 0L, 4L, null, this.getNullByteTerminatedArray(symbolicAdsTag.getSymbolicAddress()));
        AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest(amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == amsPacket.getInvokeId()).unwrap(AmsTCPPacket::getUserdata).only(AdsReadWriteResponse.class).handle(response -> {
                if (response.getResult() != ReturnCode.OK) {
                    future.completeExceptionally(new PlcException("Couldn't retrieve handle for symbolic tag " + symbolicAdsTag.getSymbolicAddress() + " got return code " + response.getResult().name()));
                } else {
                    ReadBufferByteBased readBuffer = new ReadBufferByteBased(response.getData(), ByteOrder.LITTLE_ENDIAN);
                    try {
                        long handle = readBuffer.readUnsignedLong(32, new WithReaderArgs[0]);
                        future.complete(null);
                    }
                    catch (ParseException e) {
                        future.completeExceptionally(e);
                    }
                }
                transaction.endRequest();
            });
        });
        return future;
    }

    protected CompletableFuture<Void> resolveMultipleSymbolicAddresses(List<SymbolicAdsTag> symbolicAdsTags) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        long expectedResponseDataSize = (long)symbolicAdsTags.size() * 12L;
        byte[] addressData = symbolicAdsTags.stream().map(SymbolicAdsTag::getSymbolicAddress).collect(Collectors.joining("")).getBytes();
        AdsReadWriteRequest amsPacket = new AdsReadWriteRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_MULTIPLE_READ_WRITE.getValue(), symbolicAdsTags.size(), expectedResponseDataSize, symbolicAdsTags.stream().map(symbolicAdsTag -> new AdsMultiRequestItemReadWrite(ReservedIndexGroups.ADSIGRP_SYM_HNDBYNAME.getValue(), 0L, 4L, symbolicAdsTag.getSymbolicAddress().length())).collect(Collectors.toList()), null);
        AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest(amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == amsPacket.getInvokeId()).unwrap(AmsTCPPacket::getUserdata).only(AdsReadWriteResponse.class).handle(response -> {
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(response.getData(), ByteOrder.LITTLE_ENDIAN);
                HashMap returnCodes = new HashMap();
                symbolicAdsTags.forEach(symbolicAdsTag -> {
                    try {
                        long returnCode = readBuffer.readUnsignedLong(32, new WithReaderArgs[0]);
                        long itemLength = readBuffer.readUnsignedLong(32, new WithReaderArgs[0]);
                        assert (itemLength == 4L);
                        returnCodes.put(symbolicAdsTag, returnCode);
                    }
                    catch (ParseException e) {
                        throw new PlcRuntimeException(e);
                    }
                });
                symbolicAdsTags.forEach(symbolicAdsTag -> {
                    try {
                        if ((Long)returnCodes.get(symbolicAdsTag) == 0L) {
                            long l = readBuffer.readUnsignedLong(32, new WithReaderArgs[0]);
                        }
                    }
                    catch (ParseException e) {
                        throw new PlcRuntimeException(e);
                    }
                });
                future.complete(null);
                transaction.endRequest();
            });
        });
        return future;
    }

    protected long getInvokeId() {
        long invokeId = this.invokeIdGenerator.getAndIncrement();
        if (this.invokeIdGenerator.get() == -1L) {
            this.invokeIdGenerator.set(1L);
        }
        return invokeId;
    }

    protected DirectAdsTag getDirectAdsTagForSymbolicName(PlcTag tag) {
        if (tag instanceof DirectAdsTag) {
            return (DirectAdsTag)tag;
        }
        SymbolicAdsTag symbolicAdsTag = (SymbolicAdsTag)tag;
        String symbolicAddress = symbolicAdsTag.getSymbolicAddress();
        String[] addressParts = symbolicAddress.split("\\.");
        if (addressParts.length < 2) {
            if (!this.symbolTable.containsKey(symbolicAddress)) {
                return null;
            }
            AdsSymbolTableEntry adsSymbolTableEntry = this.symbolTable.get(symbolicAddress);
            if (adsSymbolTableEntry == null) {
                throw new PlcInvalidTagException("Couldn't resolve symbolic address: " + symbolicAddress);
            }
            AdsDataTypeTableEntry dataTypeTableEntry = this.dataTypeTable.get(adsSymbolTableEntry.getDataTypeName());
            if (dataTypeTableEntry == null) {
                throw new PlcInvalidTagException("Couldn't resolve datatype: '" + adsSymbolTableEntry.getDataTypeName() + "' for address: '" + ((SymbolicAdsTag)tag).getSymbolicAddress() + "'");
            }
            return new DirectAdsTag(adsSymbolTableEntry.getGroup(), adsSymbolTableEntry.getOffset(), dataTypeTableEntry.getDataTypeName(), dataTypeTableEntry.getArrayDimensions());
        }
        String symbolName = String.valueOf(addressParts[0]) + "." + addressParts[1];
        AdsSymbolTableEntry adsSymbolTableEntry = this.symbolTable.get(symbolName);
        if (adsSymbolTableEntry == null) {
            throw new PlcInvalidTagException("Couldn't resolve symbolic address: " + symbolName);
        }
        AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(adsSymbolTableEntry.getDataTypeName());
        if (adsDataTypeTableEntry == null) {
            throw new PlcInvalidTagException("Couldn't resolve datatype: '" + adsSymbolTableEntry.getDataTypeName() + "' for address: '" + ((SymbolicAdsTag)tag).getSymbolicAddress() + "'");
        }
        return this.resolveDirectAdsTagForSymbolicNameFromDataType(Arrays.asList(addressParts).subList(2, addressParts.length), adsSymbolTableEntry.getGroup(), adsSymbolTableEntry.getOffset(), adsDataTypeTableEntry);
    }

    protected DirectAdsTag resolveDirectAdsTagForSymbolicNameFromDataType(List<String> remainingAddressParts, long currentGroup, long currentOffset, AdsDataTypeTableEntry adsDataTypeTableEntry) {
        if (remainingAddressParts.isEmpty()) {
            if (adsDataTypeTableEntry.getDataType() == (long)AdsDataType.CHAR.getValue()) {
                int stringLength = (int)adsDataTypeTableEntry.getSize() - 1;
                return new DirectAdsStringTag(currentGroup, currentOffset, adsDataTypeTableEntry.getDataTypeName(), stringLength, 1);
            }
            if (adsDataTypeTableEntry.getDataType() == (long)AdsDataType.WCHAR.getValue()) {
                int stringLength = (int)(adsDataTypeTableEntry.getSize() - 2L) / 2;
                return new DirectAdsStringTag(currentGroup, currentOffset, adsDataTypeTableEntry.getDataTypeName(), stringLength, 1);
            }
            return new DirectAdsTag(currentGroup, currentOffset, adsDataTypeTableEntry.getDataTypeName(), 1);
        }
        for (AdsDataTypeTableChildEntry child : adsDataTypeTableEntry.getChildren()) {
            if (!child.getPropertyName().equals(remainingAddressParts.get(0))) continue;
            AdsDataTypeTableEntry childAdsDataTypeTableEntry = this.dataTypeTable.get(child.getDataTypeName());
            return this.resolveDirectAdsTagForSymbolicNameFromDataType(remainingAddressParts.subList(1, remainingAddressParts.size()), currentGroup, currentOffset + child.getOffset(), childAdsDataTypeTableEntry);
        }
        throw new PlcRuntimeException(String.format("Couldn't find child with name '%s' for type '%s'", remainingAddressParts.get(0), adsDataTypeTableEntry.getDataTypeName()));
    }

    protected org.apache.plc4x.java.ads.readwrite.PlcValueType getPlcValueTypeForAdsDataType(AdsDataTypeTableEntry dataTypeTableEntry) {
        String dataTypeName = dataTypeTableEntry.getDataTypeName();
        if (dataTypeName.startsWith("STRING(")) {
            dataTypeName = "STRING";
        } else if (dataTypeName.startsWith("WSTRING(")) {
            dataTypeName = "WSTRING";
        }
        try {
            return org.apache.plc4x.java.ads.readwrite.PlcValueType.valueOf(dataTypeName);
        }
        catch (IllegalArgumentException e) {
            if (dataTypeTableEntry.getArrayDimensions() > 0) {
                return org.apache.plc4x.java.ads.readwrite.PlcValueType.List;
            }
            if (dataTypeTableEntry.getChildren().isEmpty()) {
                try {
                    dataTypeName = dataTypeTableEntry.getSimpleTypeName();
                    if (dataTypeName.startsWith("STRING(")) {
                        dataTypeName = "STRING";
                    } else if (dataTypeName.startsWith("WSTRING(")) {
                        dataTypeName = "WSTRING";
                    }
                    return org.apache.plc4x.java.ads.readwrite.PlcValueType.valueOf(dataTypeName);
                }
                catch (IllegalArgumentException e2) {
                    return org.apache.plc4x.java.ads.readwrite.PlcValueType.NULL;
                }
            }
            return org.apache.plc4x.java.ads.readwrite.PlcValueType.Struct;
        }
    }

    protected byte[] getNullByteTerminatedArray(String value) {
        byte[] valueBytes = value.getBytes();
        byte[] nullTerminatedBytes = new byte[valueBytes.length + 1];
        System.arraycopy(valueBytes, 0, nullTerminatedBytes, 0, valueBytes.length);
        return nullTerminatedBytes;
    }
}

