/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.ads.readwrite.AdsMultiRequestItem;
import org.apache.plc4x.java.ads.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.readwrite.AmsPacket;
import org.apache.plc4x.java.ads.readwrite.CommandId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class AdsReadWriteRequest
extends AmsPacket
implements Message {
    protected final long indexGroup;
    protected final long indexOffset;
    protected final long readLength;
    protected final List<AdsMultiRequestItem> items;
    protected final byte[] data;

    @Override
    public CommandId getCommandId() {
        return CommandId.ADS_READ_WRITE;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public AdsReadWriteRequest(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId, long indexGroup, long indexOffset, long readLength, List<AdsMultiRequestItem> items, byte[] data) {
        super(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId);
        this.indexGroup = indexGroup;
        this.indexOffset = indexOffset;
        this.readLength = readLength;
        this.items = items;
        this.data = data;
    }

    public long getIndexGroup() {
        return this.indexGroup;
    }

    public long getIndexOffset() {
        return this.indexOffset;
    }

    public long getReadLength() {
        return this.readLength;
    }

    public List<AdsMultiRequestItem> getItems() {
        return this.items;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeAmsPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AdsReadWriteRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("indexGroup", this.indexGroup, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("indexOffset", this.indexOffset, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("readLength", this.readLength, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        long writeLength = (long)StaticHelper.COUNT(this.getItems()) * (this.getIndexGroup() == 61570L ? 16L : 12L) + (long)StaticHelper.COUNT(this.getData());
        FieldWriterFactory.writeImplicitField("writeLength", writeLength, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("items", this.items, writeBuffer, new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("AdsReadWriteRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AdsReadWriteRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.items != null) {
            int i = 0;
            for (AdsMultiRequestItem element : this.items) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.items.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static AmsPacket.AmsPacketBuilder staticParseAmsPacketBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsReadWriteRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long indexGroup = FieldReaderFactory.readSimpleField("indexGroup", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long indexOffset = FieldReaderFactory.readSimpleField("indexOffset", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long readLength = FieldReaderFactory.readSimpleField("readLength", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long writeLength = FieldReaderFactory.readImplicitField("writeLength", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        List<AdsMultiRequestItem> items = FieldReaderFactory.readCountArrayField("items", new DataReaderComplexDefault<AdsMultiRequestItem>(() -> AdsMultiRequestItem.staticParse(readBuffer, indexGroup), readBuffer), indexGroup == 61568L || indexGroup == 61569L || indexGroup == 61570L ? indexOffset : 0L, new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(writeLength - (long)(StaticHelper.COUNT(items) * 12)), new WithReaderArgs[0]);
        readBuffer.closeContext("AdsReadWriteRequest", new WithReaderArgs[0]);
        return new AdsReadWriteRequestBuilderImpl(indexGroup, indexOffset, readLength, items, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsReadWriteRequest)) {
            return false;
        }
        AdsReadWriteRequest that = (AdsReadWriteRequest)o;
        return this.getIndexGroup() == that.getIndexGroup() && this.getIndexOffset() == that.getIndexOffset() && this.getReadLength() == that.getReadLength() && this.getItems() == that.getItems() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getIndexGroup(), this.getIndexOffset(), this.getReadLength(), this.getItems(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AdsReadWriteRequestBuilderImpl
    implements AmsPacket.AmsPacketBuilder {
        private final long indexGroup;
        private final long indexOffset;
        private final long readLength;
        private final List<AdsMultiRequestItem> items;
        private final byte[] data;

        public AdsReadWriteRequestBuilderImpl(long indexGroup, long indexOffset, long readLength, List<AdsMultiRequestItem> items, byte[] data) {
            this.indexGroup = indexGroup;
            this.indexOffset = indexOffset;
            this.readLength = readLength;
            this.items = items;
            this.data = data;
        }

        @Override
        public AdsReadWriteRequest build(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId) {
            AdsReadWriteRequest adsReadWriteRequest = new AdsReadWriteRequest(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId, this.indexGroup, this.indexOffset, this.readLength, this.items, this.data);
            return adsReadWriteRequest;
        }
    }
}

