/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.ads.readwrite.AdsNotificationSample;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class AdsStampHeader
implements Message {
    protected final BigInteger timestamp;
    protected final long samples;
    protected final List<AdsNotificationSample> adsNotificationSamples;

    public AdsStampHeader(BigInteger timestamp, long samples, List<AdsNotificationSample> adsNotificationSamples) {
        this.timestamp = timestamp;
        this.samples = samples;
        this.adsNotificationSamples = adsNotificationSamples;
    }

    public BigInteger getTimestamp() {
        return this.timestamp;
    }

    public long getSamples() {
        return this.samples;
    }

    public List<AdsNotificationSample> getAdsNotificationSamples() {
        return this.adsNotificationSamples;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AdsStampHeader", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("timestamp", this.timestamp, DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("samples", this.samples, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("adsNotificationSamples", this.adsNotificationSamples, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("AdsStampHeader", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        AdsStampHeader _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 64;
        lengthInBits += 32;
        if (this.adsNotificationSamples != null) {
            int i = 0;
            for (AdsNotificationSample element : this.adsNotificationSamples) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.adsNotificationSamples.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static AdsStampHeader staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return AdsStampHeader.staticParse(readBuffer);
    }

    public static AdsStampHeader staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsStampHeader", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        BigInteger timestamp = FieldReaderFactory.readSimpleField("timestamp", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
        long samples = FieldReaderFactory.readSimpleField("samples", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        List<AdsNotificationSample> adsNotificationSamples = FieldReaderFactory.readCountArrayField("adsNotificationSamples", new DataReaderComplexDefault<AdsNotificationSample>(() -> AdsNotificationSample.staticParse(readBuffer), readBuffer), samples, new WithReaderArgs[0]);
        readBuffer.closeContext("AdsStampHeader", new WithReaderArgs[0]);
        AdsStampHeader _adsStampHeader = new AdsStampHeader(timestamp, samples, adsNotificationSamples);
        return _adsStampHeader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsStampHeader)) {
            return false;
        }
        AdsStampHeader that = (AdsStampHeader)o;
        return this.getTimestamp() == that.getTimestamp() && this.getSamples() == that.getSamples() && this.getAdsNotificationSamples() == that.getAdsNotificationSamples();
    }

    public int hashCode() {
        return Objects.hash(this.getTimestamp(), this.getSamples(), this.getAdsNotificationSamples());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

