/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.can.adapter.conversation;

import io.netty.channel.Channel;
import java.time.Duration;
import java.util.function.Function;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.can.adapter.conversation.SendRequestContextWrapper;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.transport.can.CANTransport;
import org.apache.plc4x.java.transport.can.FrameData;

public class ConversationContextWrapper<C, T>
implements ConversationContext<T> {
    private final ConversationContext<C> delegate;
    private final Class<C> wireType;
    private final Function<C, FrameData> adapter;
    private final CANTransport.FrameHandler<C, T> frameHandler;
    private final PlcAuthentication authentication;

    public ConversationContextWrapper(ConversationContext<C> delegate, Class<C> wireType, Function<C, FrameData> adapter, CANTransport.FrameHandler<C, T> frameHandler, PlcAuthentication authentication) {
        this.delegate = delegate;
        this.wireType = wireType;
        this.adapter = adapter;
        this.frameHandler = frameHandler;
        this.authentication = authentication;
    }

    @Override
    public PlcAuthentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public Channel getChannel() {
        return this.delegate.getChannel();
    }

    @Override
    public boolean isPassive() {
        return this.delegate.isPassive();
    }

    @Override
    public void sendToWire(T msg) {
        this.delegate.sendToWire(this.frameHandler.toCAN(msg));
    }

    @Override
    public void fireConnected() {
        this.delegate.fireConnected();
    }

    @Override
    public void fireDisconnected() {
        this.delegate.fireDisconnected();
    }

    @Override
    public void fireDiscovered(PlcConnectionConfiguration c) {
        this.delegate.fireDiscovered(c);
    }

    @Override
    public ConversationContext.SendRequestContext<T> sendRequest(T packet) {
        return new SendRequestContextWrapper<C, T>("", this.delegate.sendRequest(this.frameHandler.toCAN(packet)), this.wireType, this.adapter, this.frameHandler);
    }

    @Override
    public ConversationContext.ExpectRequestContext<T> expectRequest(Class<T> clazz, Duration timeout) {
        throw new UnsupportedOperationException();
    }
}

