/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.can.generic.protocol;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.plc4x.java.can.generic.tag.GenericCANTag;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;

public class GenericCANSubscriptionHandle
extends DefaultPlcSubscriptionHandle {
    private final Map<String, GenericCANTag> tags = new LinkedHashMap<String, GenericCANTag>();
    private final Integer nodeId;

    public GenericCANSubscriptionHandle(PlcSubscriber subscriber, Integer nodeId) {
        super(subscriber);
        this.nodeId = nodeId;
    }

    public boolean matches(int identifier) {
        return this.nodeId == identifier;
    }

    @Override
    public String toString() {
        return "GenericCANSubscriptionHandle [node=" + this.nodeId + " " + GenericCANSubscriptionHandle.intAndHex(this.nodeId) + "]";
    }

    public void add(String name, GenericCANTag tag) {
        this.tags.put(name, tag);
    }

    private static String intAndHex(int val) {
        return String.valueOf(val) + "(0x" + Integer.toHexString(val) + ")";
    }

    public Map<String, GenericCANTag> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }
}

