/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.api.conversation.canopen;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.canopen.api.conversation.canopen.CANConversation;
import org.apache.plc4x.java.canopen.api.conversation.canopen.CANOpenConversationBase;
import org.apache.plc4x.java.canopen.api.segmentation.accumulator.ByteStorage;
import org.apache.plc4x.java.canopen.readwrite.CANOpenDataType;
import org.apache.plc4x.java.canopen.readwrite.CANOpenFrame;
import org.apache.plc4x.java.canopen.readwrite.CANOpenSDOResponse;
import org.apache.plc4x.java.canopen.readwrite.IndexAddress;
import org.apache.plc4x.java.canopen.readwrite.SDOAbort;
import org.apache.plc4x.java.canopen.readwrite.SDOAbortRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateExpeditedUploadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateSegmentedUploadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateUploadRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateUploadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOSegmentUploadRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOSegmentUploadResponse;
import org.apache.plc4x.java.canopen.transport.CANOpenAbortException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDOUploadConversation
extends CANOpenConversationBase {
    private final Logger logger = LoggerFactory.getLogger(SDOUploadConversation.class);
    private final IndexAddress address;
    private final CANOpenDataType type;

    public SDOUploadConversation(CANConversation delegate, int nodeId, int answerNodeId, IndexAddress address, CANOpenDataType type) {
        super(delegate, nodeId, answerNodeId);
        this.address = address;
        this.type = type;
    }

    public void execute(CompletableFuture<PlcValue> receiver) {
        SDOInitiateUploadRequest rq = new SDOInitiateUploadRequest(this.address);
        this.delegate.send(this.createFrame(rq)).check(new CANOpenConversationBase.NodeIdPredicate(this.answerNodeId)).onTimeout(receiver::completeExceptionally).unwrap(CANOpenFrame::getPayload).only(CANOpenSDOResponse.class).onError((payload, error) -> this.onError(receiver, (CANOpenSDOResponse)payload, (Throwable)error)).unwrap(CANOpenSDOResponse::getResponse).check(new CANOpenConversationBase.TypeOrAbortPredicate<SDOInitiateUploadResponse>(SDOInitiateUploadResponse.class)).unwrap(payload -> this.unwrap(SDOInitiateUploadResponse.class, (SDOResponse)payload)).check(either -> either.isLeft() || ((SDOInitiateUploadResponse)either.get()).getAddress().equals(this.address)).handle(either -> {
            if (either.isLeft()) {
                SDOAbort abort = (SDOAbort)either.getLeft();
                receiver.completeExceptionally(new CANOpenAbortException("Could not complete operation", abort.getCode()));
            } else {
                this.handle(receiver, (SDOInitiateUploadResponse)either.get());
            }
        });
    }

    private void handle(CompletableFuture<PlcValue> receiver, SDOInitiateUploadResponse answer) {
        BiConsumer<Integer, byte[]> valueCallback = (length, bytes) -> {
            try {
                PlcValue decodedValue = this.decodeFrom((byte[])bytes, this.type, (int)length);
                receiver.complete(decodedValue);
            }
            catch (ArrayIndexOutOfBoundsException | ParseException e) {
                receiver.completeExceptionally(e);
            }
        };
        if (answer.getExpedited() && answer.getIndicated() && answer.getPayload() instanceof SDOInitiateExpeditedUploadResponse) {
            SDOInitiateExpeditedUploadResponse payload = (SDOInitiateExpeditedUploadResponse)answer.getPayload();
            valueCallback.accept(payload.getData().length, payload.getData());
        } else if (answer.getPayload() instanceof SDOInitiateSegmentedUploadResponse) {
            this.logger.debug("Beginning of segmented operation for address {}/{}", (Object)Integer.toHexString(this.address.getIndex()), (Object)Integer.toHexString(this.address.getSubindex()));
            ByteStorage.SDOUploadStorage storage = new ByteStorage.SDOUploadStorage();
            storage.append(answer);
            SDOInitiateSegmentedUploadResponse segment = (SDOInitiateSegmentedUploadResponse)answer.getPayload();
            this.fetch(storage, valueCallback, receiver, false, Long.valueOf(segment.getBytes()).intValue());
        } else {
            receiver.completeExceptionally(new PlcException("Unsupported SDO operation kind."));
        }
    }

    private void fetch(ByteStorage.SDOUploadStorage storage, BiConsumer<Integer, byte[]> valueCallback, CompletableFuture<PlcValue> receiver, boolean toggle, int size) {
        this.logger.info("Request next data block for address {}/{}", (Object)Integer.toHexString(this.address.getIndex()), (Object)Integer.toHexString(this.address.getSubindex()));
        this.delegate.send(this.createFrame(new SDOSegmentUploadRequest(toggle))).check(new CANOpenConversationBase.NodeIdPredicate(this.answerNodeId)).onTimeout(receiver::completeExceptionally).unwrap(CANOpenFrame::getPayload).only(CANOpenSDOResponse.class).onError((payload, error) -> this.onError(receiver, (CANOpenSDOResponse)payload, (Throwable)error)).unwrap(CANOpenSDOResponse::getResponse).check(new CANOpenConversationBase.TypeOrAbortPredicate<SDOSegmentUploadResponse>(SDOSegmentUploadResponse.class)).unwrap(payload -> this.unwrap(SDOSegmentUploadResponse.class, (SDOResponse)payload)).handle(either -> {
            if (either.isLeft()) {
                SDOAbort abort = (SDOAbort)either.getLeft();
                receiver.completeExceptionally(new CANOpenAbortException("Could not complete operation", abort.getCode()));
            } else {
                SDOSegmentUploadResponse response = (SDOSegmentUploadResponse)either.get();
                if (response.getToggle() != toggle) {
                    receiver.completeExceptionally(new CANOpenAbortException("Remote operation failed", 1000L));
                    SDOAbort abort = new SDOAbort(this.address, 1000L);
                    this.delegate.sendToWire(this.createFrame(new SDOAbortRequest(abort)));
                    return;
                }
                storage.append((SDOResponse)either.get());
                if (response.getLast()) {
                    this.logger.trace("Completed reading of data from {}/{}, collected {}, wanted {}", new Object[]{Integer.toHexString(this.address.getIndex()), Integer.toHexString(this.address.getSubindex()), storage.size(), size});
                    valueCallback.accept(Long.valueOf(size).intValue(), storage.get());
                } else {
                    this.logger.trace("Continue reading of data from {}/{}, collected {}, wanted {}", new Object[]{Integer.toHexString(this.address.getIndex()), Integer.toHexString(this.address.getSubindex()), storage.size(), size});
                    this.fetch(storage, valueCallback, receiver, !toggle, size);
                }
            }
        });
    }
}

