/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.protocol;

import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.canopen.tag.CANOpenSubscriptionTag;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;

public class CANOpenSubscriptionHandle
extends DefaultPlcSubscriptionHandle {
    private final String name;
    private final CANOpenSubscriptionTag tag;

    public CANOpenSubscriptionHandle(PlcSubscriber subscriber, String name, CANOpenSubscriptionTag tag) {
        super(subscriber);
        this.name = name;
        this.tag = tag;
    }

    public boolean matches(CANOpenService service, int identifier) {
        if (this.tag.getService() != service) {
            return false;
        }
        return this.tag.isWildcard() || this.tag.getNodeId() == identifier;
    }

    public String getName() {
        return this.name;
    }

    public CANOpenSubscriptionTag getTag() {
        return this.tag;
    }

    @Override
    public String toString() {
        return "CANopenSubscriptionHandle [service=" + (Object)((Object)this.tag.getService()) + ", node=" + CANOpenSubscriptionHandle.intAndHex(this.tag.getNodeId()) + ", cob=" + CANOpenSubscriptionHandle.intAndHex(this.tag.getService().getMin() + this.tag.getNodeId()) + "]";
    }

    private static String intAndHex(int val) {
        return String.valueOf(val) + "(0x" + Integer.toHexString(val) + ")";
    }
}

