/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.CANOpenPayload;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CANOpenFrame
implements Message {
    public static final Byte ALIGNMENT = 0;
    protected final short nodeId;
    protected final CANOpenService service;
    protected final CANOpenPayload payload;

    public CANOpenFrame(short nodeId, CANOpenService service, CANOpenPayload payload) {
        this.nodeId = nodeId;
        this.service = service;
        this.payload = payload;
    }

    public short getNodeId() {
        return this.nodeId;
    }

    public CANOpenService getService() {
        return this.service;
    }

    public CANOpenPayload getPayload() {
        return this.payload;
    }

    public byte getAlignment() {
        return ALIGNMENT;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CANOpenFrame", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("nodeId", this.nodeId, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        FieldWriterFactory.writeSimpleEnumField("service", "CANOpenService", this.service, new DataWriterEnumDefault<CANOpenService, Byte>(CANOpenService::getValue, Enum::name, DataWriterFactory.writeUnsignedByte(writeBuffer, 4)), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        FieldWriterFactory.writeConstField("alignment", ALIGNMENT, DataWriterFactory.writeUnsignedByte(writeBuffer, 4), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        FieldWriterFactory.writeSimpleField("payload", this.payload, new DataWriterComplexDefault(writeBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        FieldWriterFactory.writePaddingField("padding", 8 - this.payload.getLengthInBytes(), (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        writeBuffer.popContext("CANOpenFrame", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        CANOpenFrame _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 4;
        lengthInBits += 4;
        lengthInBits += this.payload.getLengthInBits();
        int _timesPadding = 8 - this.payload.getLengthInBytes();
        while (_timesPadding-- > 0) {
            lengthInBits += 8;
        }
        return lengthInBits;
    }

    public static CANOpenFrame staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return CANOpenFrame.staticParse(readBuffer);
    }

    public static CANOpenFrame staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("CANOpenFrame", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short nodeId = FieldReaderFactory.readSimpleField("nodeId", DataReaderFactory.readUnsignedShort(readBuffer, 8), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        CANOpenService service = (CANOpenService)((Object)FieldReaderFactory.readEnumField("service", "CANOpenService", new DataReaderEnumDefault<CANOpenService, Byte>(CANOpenService::enumForValue, DataReaderFactory.readUnsignedByte(readBuffer, 4)), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN)));
        byte alignment = FieldReaderFactory.readConstField("alignment", DataReaderFactory.readUnsignedByte(readBuffer, 4), ALIGNMENT, WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        CANOpenPayload payload = FieldReaderFactory.readSimpleField("payload", new DataReaderComplexDefault<CANOpenPayload>(() -> CANOpenPayload.staticParse(readBuffer, service), readBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        FieldReaderFactory.readPaddingField(DataReaderFactory.readUnsignedShort(readBuffer, 8), 8 - payload.getLengthInBytes(), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        readBuffer.closeContext("CANOpenFrame", new WithReaderArgs[0]);
        CANOpenFrame _cANOpenFrame = new CANOpenFrame(nodeId, service, payload);
        return _cANOpenFrame;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CANOpenFrame)) {
            return false;
        }
        CANOpenFrame that = (CANOpenFrame)o;
        return this.getNodeId() == that.getNodeId() && this.getService() == that.getService() && this.getPayload() == that.getPayload();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getNodeId(), this.getService(), this.getPayload()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

