/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.IndexAddress;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CANOpenMPDO
implements Message {
    protected final short node;
    protected final IndexAddress address;
    protected final byte[] data;

    public CANOpenMPDO(short node, IndexAddress address, byte[] data) {
        this.node = node;
        this.address = address;
        this.data = data;
    }

    public short getNode() {
        return this.node;
    }

    public IndexAddress getAddress() {
        return this.address;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CANOpenMPDO", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("node", this.node, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("address", this.address, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("CANOpenMPDO", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        CANOpenMPDO _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += this.address.getLengthInBits();
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static CANOpenMPDO staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return CANOpenMPDO.staticParse(readBuffer);
    }

    public static CANOpenMPDO staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("CANOpenMPDO", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short node = FieldReaderFactory.readSimpleField("node", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        IndexAddress address = FieldReaderFactory.readSimpleField("address", new DataReaderComplexDefault<IndexAddress>(() -> IndexAddress.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(4L), new WithReaderArgs[0]);
        readBuffer.closeContext("CANOpenMPDO", new WithReaderArgs[0]);
        CANOpenMPDO _cANOpenMPDO = new CANOpenMPDO(node, address, data);
        return _cANOpenMPDO;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CANOpenMPDO)) {
            return false;
        }
        CANOpenMPDO that = (CANOpenMPDO)o;
        return this.getNode() == that.getNode() && this.getAddress() == that.getAddress() && this.getData() == that.getData();
    }

    public int hashCode() {
        return Objects.hash(this.getNode(), this.getAddress(), this.getData());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

