/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.CANOpenPayload;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.canopen.readwrite.NMTStateRequest;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CANOpenNetworkPayload
extends CANOpenPayload
implements Message {
    protected final NMTStateRequest request;
    protected final byte node;

    @Override
    public CANOpenService getService() {
        return CANOpenService.NMT;
    }

    public CANOpenNetworkPayload(NMTStateRequest request, byte node) {
        this.request = request;
        this.node = node;
    }

    public NMTStateRequest getRequest() {
        return this.request;
    }

    public byte getNode() {
        return this.node;
    }

    @Override
    protected void serializeCANOpenPayloadChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CANOpenNetworkPayload", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("request", "NMTStateRequest", this.request, new DataWriterEnumDefault<NMTStateRequest, Short>(NMTStateRequest::getValue, Enum::name, DataWriterFactory.writeUnsignedShort(writeBuffer, 8)), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 1), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("node", this.node, DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
        writeBuffer.popContext("CANOpenNetworkPayload", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CANOpenNetworkPayload _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        ++lengthInBits;
        return lengthInBits += 7;
    }

    public static CANOpenPayload.CANOpenPayloadBuilder staticParseCANOpenPayloadBuilder(ReadBuffer readBuffer, CANOpenService service) throws ParseException {
        readBuffer.pullContext("CANOpenNetworkPayload", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        NMTStateRequest request = (NMTStateRequest)((Object)FieldReaderFactory.readEnumField("request", "NMTStateRequest", new DataReaderEnumDefault<NMTStateRequest, Short>(NMTStateRequest::enumForValue, DataReaderFactory.readUnsignedShort(readBuffer, 8)), new WithReaderArgs[0]));
        Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 1), (byte)0, new WithReaderArgs[0]);
        byte node = FieldReaderFactory.readSimpleField("node", DataReaderFactory.readUnsignedByte(readBuffer, 7), new WithReaderArgs[0]);
        readBuffer.closeContext("CANOpenNetworkPayload", new WithReaderArgs[0]);
        return new CANOpenNetworkPayloadBuilderImpl(request, node);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CANOpenNetworkPayload)) {
            return false;
        }
        CANOpenNetworkPayload that = (CANOpenNetworkPayload)o;
        return this.getRequest() == that.getRequest() && this.getNode() == that.getNode() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getRequest(), this.getNode()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CANOpenNetworkPayloadBuilderImpl
    implements CANOpenPayload.CANOpenPayloadBuilder {
        private final NMTStateRequest request;
        private final byte node;

        public CANOpenNetworkPayloadBuilderImpl(NMTStateRequest request, byte node) {
            this.request = request;
            this.node = node;
        }

        @Override
        public CANOpenNetworkPayload build() {
            CANOpenNetworkPayload cANOpenNetworkPayload = new CANOpenNetworkPayload(this.request, this.node);
            return cANOpenNetworkPayload;
        }
    }
}

