/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CANOpenTime
implements Message {
    protected final long millis;
    protected final int days;

    public CANOpenTime(long millis, int days) {
        this.millis = millis;
        this.days = days;
    }

    public long getMillis() {
        return this.millis;
    }

    public int getDays() {
        return this.days;
    }

    public int getCleanMillis() {
        return (int)(this.getMillis() & 0xFFFFFFFL);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CANOpenTime", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("millis", this.millis, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        int cleanMillis = this.getCleanMillis();
        writeBuffer.writeVirtual("cleanMillis", cleanMillis, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("days", this.days, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        writeBuffer.popContext("CANOpenTime", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        CANOpenTime _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        return lengthInBits += 16;
    }

    public static CANOpenTime staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return CANOpenTime.staticParse(readBuffer);
    }

    public static CANOpenTime staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("CANOpenTime", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long millis = FieldReaderFactory.readSimpleField("millis", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        int cleanMillis = FieldReaderFactory.readVirtualField("cleanMillis", Integer.TYPE, millis & 0xFFFFFFFL, new WithReaderArgs[0]);
        int days = FieldReaderFactory.readSimpleField("days", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        readBuffer.closeContext("CANOpenTime", new WithReaderArgs[0]);
        CANOpenTime _cANOpenTime = new CANOpenTime(millis, days);
        return _cANOpenTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CANOpenTime)) {
            return false;
        }
        CANOpenTime that = (CANOpenTime)o;
        return this.getMillis() == that.getMillis() && this.getDays() == that.getDays();
    }

    public int hashCode() {
        return Objects.hash(this.getMillis(), this.getDays());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

