/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.math.BigInteger;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.canopen.readwrite.CANOpenDataType;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcRawByteArray;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, CANOpenDataType dataType, Integer size) throws ParseException {
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.BOOLEAN)) {
            boolean value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED8)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED16)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED24)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 24), new WithReaderArgs[0]);
            return new PlcUDINT((long)value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED32)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED40)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 40), new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED48)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 48), new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED56)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 56), new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED64)) {
            BigInteger value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER8)) {
            byte value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedByte(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER16)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedShort(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER24)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedInt(readBuffer, 24), new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER32)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER40)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 40), new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER48)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 48), new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER56)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 56), new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER64)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.REAL32)) {
            float value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readFloat(readBuffer, 32), new WithReaderArgs[0]).floatValue();
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.REAL64)) {
            double value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readDouble(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.RECORD)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(size.intValue()), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.OCTET_STRING)) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, size), new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.VISIBLE_STRING)) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, size), new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNICODE_STRING)) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, size / 8), new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        return null;
    }

    public static int getLengthInBytes(PlcValue _value, CANOpenDataType dataType, Integer size) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataType, size) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, CANOpenDataType dataType, Integer size) {
        int lengthInBits = 0;
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.BOOLEAN)) {
            ++lengthInBits;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED8)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED16)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED24)) {
            lengthInBits += 24;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED32)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED40)) {
            lengthInBits += 40;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED48)) {
            lengthInBits += 48;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED56)) {
            lengthInBits += 56;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED64)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER8)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER16)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER24)) {
            lengthInBits += 24;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER32)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER40)) {
            lengthInBits += 40;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER48)) {
            lengthInBits += 48;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER56)) {
            lengthInBits += 56;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER64)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.REAL32)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.REAL64)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.RECORD)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.OCTET_STRING)) {
            lengthInBits += size.intValue();
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.VISIBLE_STRING)) {
            lengthInBits += size.intValue();
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNICODE_STRING)) {
            lengthInBits += size / 8;
        }
        return lengthInBits;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, CANOpenDataType dataType, Integer size) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataType, size, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, CANOpenDataType dataType, Integer size, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.BOOLEAN)) {
            FieldWriterFactory.writeSimpleField("value", _value.getBoolean(), DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED8)) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED16)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED24)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 24), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED32)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED40)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 40), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED48)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 48), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED56)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 56), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNSIGNED64)) {
            FieldWriterFactory.writeSimpleField("value", _value.getBigInteger(), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER8)) {
            FieldWriterFactory.writeSimpleField("value", _value.getByte(), DataWriterFactory.writeSignedByte(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER16)) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeSignedShort(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER24)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeSignedInt(writeBuffer, 24), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER32)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER40)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 40), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER48)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 48), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER56)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 56), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.INTEGER64)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.REAL32)) {
            FieldWriterFactory.writeSimpleField("value", Float.valueOf(_value.getFloat()), DataWriterFactory.writeFloat(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.REAL64)) {
            FieldWriterFactory.writeSimpleField("value", _value.getDouble(), DataWriterFactory.writeDouble(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.RECORD)) {
            FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.OCTET_STRING)) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, size), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.VISIBLE_STRING)) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, size), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)CANOpenDataType.UNICODE_STRING)) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, size / 8), new WithWriterArgs[0]);
        }
    }
}

