/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.SDOResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOResponseCommand;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class SDOSegmentUploadResponse
extends SDOResponse
implements Message {
    protected final boolean toggle;
    protected final boolean last;
    protected final byte[] data;

    @Override
    public SDOResponseCommand getCommand() {
        return SDOResponseCommand.SEGMENT_UPLOAD;
    }

    public SDOSegmentUploadResponse(boolean toggle, boolean last, byte[] data) {
        this.toggle = toggle;
        this.last = last;
        this.data = data;
    }

    public boolean getToggle() {
        return this.toggle;
    }

    public boolean getLast() {
        return this.last;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeSDOResponseChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SDOSegmentUploadResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("toggle", this.toggle, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        byte size = (byte)(7 - StaticHelper.COUNT(this.getData()));
        FieldWriterFactory.writeImplicitField("size", size, DataWriterFactory.writeUnsignedByte(writeBuffer, 3), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("last", this.last, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writePaddingField("padding", 7 - StaticHelper.COUNT(this.data), (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("SDOSegmentUploadResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        SDOSegmentUploadResponse _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        lengthInBits += 3;
        ++lengthInBits;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        int _timesPadding = 7 - StaticHelper.COUNT(this.data);
        while (_timesPadding-- > 0) {
            lengthInBits += 8;
        }
        return lengthInBits;
    }

    public static SDOResponse.SDOResponseBuilder staticParseSDOResponseBuilder(ReadBuffer readBuffer, SDOResponseCommand command) throws ParseException {
        readBuffer.pullContext("SDOSegmentUploadResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        boolean toggle = FieldReaderFactory.readSimpleField("toggle", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        byte size = FieldReaderFactory.readImplicitField("size", DataReaderFactory.readUnsignedByte(readBuffer, 3), new WithReaderArgs[0]);
        boolean last = FieldReaderFactory.readSimpleField("last", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(7 - size), new WithReaderArgs[0]);
        FieldReaderFactory.readPaddingField(DataReaderFactory.readUnsignedShort(readBuffer, 8), 7 - StaticHelper.COUNT(data), new WithReaderArgs[0]);
        readBuffer.closeContext("SDOSegmentUploadResponse", new WithReaderArgs[0]);
        return new SDOSegmentUploadResponseBuilderImpl(toggle, last, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SDOSegmentUploadResponse)) {
            return false;
        }
        SDOSegmentUploadResponse that = (SDOSegmentUploadResponse)o;
        return this.getToggle() == that.getToggle() && this.getLast() == that.getLast() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getToggle(), this.getLast(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class SDOSegmentUploadResponseBuilderImpl
    implements SDOResponse.SDOResponseBuilder {
        private final boolean toggle;
        private final boolean last;
        private final byte[] data;

        public SDOSegmentUploadResponseBuilderImpl(boolean toggle, boolean last, byte[] data) {
            this.toggle = toggle;
            this.last = last;
            this.data = data;
        }

        @Override
        public SDOSegmentUploadResponse build() {
            SDOSegmentUploadResponse sDOSegmentUploadResponse = new SDOSegmentUploadResponse(this.toggle, this.last, this.data);
            return sDOSegmentUploadResponse;
        }
    }
}

