/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.transport;

import java.util.function.Supplier;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.canopen.readwrite.CANOpenFrame;
import org.apache.plc4x.java.canopen.readwrite.CANOpenPayload;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.canopen.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.transport.can.CANFrameBuilder;
import org.apache.plc4x.java.transport.can.CANTransport;
import org.apache.plc4x.java.transport.can.FrameData;

public class CANOpenFrameDataHandler
implements CANTransport.FrameHandler<Message, CANOpenFrame> {
    private final Supplier<CANFrameBuilder<Message>> builder;

    public CANOpenFrameDataHandler(Supplier<CANFrameBuilder<Message>> builder) {
        this.builder = builder;
    }

    @Override
    public CANOpenFrame fromCAN(FrameData frame) {
        CANOpenService service = StaticHelper.serviceId((short)frame.getNodeId());
        int nodeId = Math.abs(service.getMin() - frame.getNodeId());
        return new CANOpenFrame((short)nodeId, service, frame.read((readBuffer, objectArray) -> CANOpenPayload.staticParse(readBuffer, objectArray), new Object[]{service}));
    }

    @Override
    public Message toCAN(CANOpenFrame frame) {
        try {
            CANOpenPayload payload = frame.getPayload();
            WriteBufferByteBased buffer = new WriteBufferByteBased(payload.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
            payload.serialize(buffer);
            return this.builder.get().withId(frame.getService().getMin() + frame.getNodeId()).withData(buffer.getBytes()).create();
        }
        catch (SerializationException e) {
            throw new PlcRuntimeException(e);
        }
    }
}

