/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.base;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.eip.base.configuration.EIPConfiguration;
import org.apache.plc4x.java.eip.base.configuration.EipTcpTransportConfiguration;
import org.apache.plc4x.java.eip.base.protocol.EipProtocolLogic;
import org.apache.plc4x.java.eip.base.tag.EipTag;
import org.apache.plc4x.java.eip.base.tag.EipTagHandler;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.connection.DefaultNettyPlcConnection;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.transport.Transport;
import org.apache.plc4x.java.spi.values.PlcValueHandler;

public class EIPDriver
extends GeneratedDriverBase<EipPacket> {
    public static final int PORT = 44818;
    private static final Pattern URI_PATTERN = Pattern.compile("^(?<protocolCode>[a-z0-9\\-]*)(:(?<transportCode>[a-z0-9]*))?://(?<transportConfig>[^?]*)(\\?(?<paramString>.*))?");
    private EIPConfiguration configuration;

    @Override
    public String getProtocolCode() {
        return "eip";
    }

    @Override
    public String getProtocolName() {
        return "EthernetIP";
    }

    @Override
    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return EIPConfiguration.class;
    }

    @Override
    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(EipTcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    @Override
    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("tcp");
    }

    @Override
    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("tcp");
    }

    @Override
    protected PlcTagHandler getTagHandler() {
        return new EipTagHandler();
    }

    @Override
    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler();
    }

    @Override
    protected boolean awaitDisconnectComplete() {
        return true;
    }

    @Override
    protected boolean canRead() {
        return true;
    }

    @Override
    protected boolean canWrite() {
        return true;
    }

    @Override
    protected ProtocolStackConfigurer<EipPacket> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(EipPacket.class, (readBuffer, objectArray) -> EipPacket.staticParse(readBuffer, objectArray)).withProtocol(EipProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withParserArgs(true).withCorruptPacketRemover(CorruptPackageCleaner.class).byteOrder(this.configuration.getByteOrder()).build();
    }

    @Override
    public PlcConnection getConnection(String connectionString) throws PlcConnectionException {
        Matcher matcher = URI_PATTERN.matcher(connectionString);
        if (!matcher.matches()) {
            throw new PlcConnectionException("Connection string doesn't match the format '{protocol-code}:({transport-code})?//{transport-address}(?{parameter-string)?'");
        }
        String protocolCode = matcher.group("protocolCode");
        String transportCode = matcher.group("transportCode") != null ? matcher.group("transportCode") : this.getDefaultTransportCode().get();
        String transportConfig = matcher.group("transportConfig");
        String paramString = matcher.group("paramString");
        if (!protocolCode.equals(this.getProtocolCode())) {
            throw new PlcConnectionException("This driver is not suited to handle this connection string");
        }
        this.configuration = (EIPConfiguration)new ConfigurationFactory().createConfiguration(this.getConfigurationClass(), protocolCode, transportCode, transportConfig, paramString);
        if (this.configuration == null) {
            throw new PlcConnectionException("Unsupported configuration");
        }
        Transport transport = null;
        ServiceLoader<Transport> transportLoader = ServiceLoader.load(Transport.class, Thread.currentThread().getContextClassLoader());
        for (Transport curTransport : transportLoader) {
            if (!curTransport.getTransportCode().equals(transportCode)) continue;
            transport = curTransport;
            break;
        }
        if (transport == null) {
            throw new PlcConnectionException("Unsupported transport " + transportCode);
        }
        ConfigurationFactory.configure(this.configuration, transport);
        ChannelFactory channelFactory = transport.createChannelFactory(transportConfig);
        if (channelFactory == null) {
            throw new PlcConnectionException("Unable to get channel factory from url " + transportConfig);
        }
        ConfigurationFactory.configure(this.configuration, channelFactory);
        this.initializePipeline(channelFactory);
        boolean fireDiscoverEvent = this.fireDiscoverEvent();
        if (System.getProperty("PLC4X_FORCE_FIRE_DISCOVER_EVENT") != null) {
            fireDiscoverEvent = Boolean.parseBoolean(System.getProperty("PLC4X_FORCE_FIRE_DISCOVER_EVENT"));
        }
        boolean awaitSetupComplete = this.awaitSetupComplete();
        if (System.getProperty("PLC4X_FORCE_AWAIT_SETUP_COMPLETE") != null) {
            awaitSetupComplete = Boolean.parseBoolean(System.getProperty("PLC4X_FORCE_AWAIT_SETUP_COMPLETE"));
        }
        boolean awaitDisconnectComplete = this.awaitDisconnectComplete();
        if (System.getProperty("PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE") != null) {
            awaitDisconnectComplete = Boolean.parseBoolean(System.getProperty("PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE"));
        }
        boolean awaitDiscoverComplete = this.awaitDiscoverComplete();
        if (System.getProperty("PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE") != null) {
            awaitDiscoverComplete = Boolean.parseBoolean(System.getProperty("PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE"));
        }
        return new DefaultNettyPlcConnection(this.canPing(), this.canRead(), this.canWrite(), this.canSubscribe(), this.canBrowse(), this.getTagHandler(), this.getValueHandler(), this.configuration, channelFactory, fireDiscoverEvent, awaitSetupComplete, awaitDisconnectComplete, awaitDiscoverComplete, this.getStackConfigurer(transport), this.getOptimizer(), null);
    }

    @Override
    public EipTag prepareTag(String query) {
        return EipTag.of(query);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf>,
    HasConfiguration<EIPConfiguration> {
        private EIPConfiguration configuration;

        @Override
        public void setConfiguration(EIPConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                if (this.configuration.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                    return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 2) + 24;
                }
                return byteBuf.getUnsignedShortLE(byteBuf.readerIndex() + 2) + 24;
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (byteBuf.getUnsignedByte(0) != 0) {
                byteBuf.readByte();
            }
        }
    }
}

