/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.base.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.eip.base.configuration.EIPConfiguration;
import org.apache.plc4x.java.eip.base.tag.EipTag;
import org.apache.plc4x.java.eip.logix.configuration.LogixConfiguration;
import org.apache.plc4x.java.eip.readwrite.AnsiExtendedSymbolSegment;
import org.apache.plc4x.java.eip.readwrite.CIPClassID;
import org.apache.plc4x.java.eip.readwrite.CIPDataTypeCode;
import org.apache.plc4x.java.eip.readwrite.CIPStatus;
import org.apache.plc4x.java.eip.readwrite.CIPStructTypeCode;
import org.apache.plc4x.java.eip.readwrite.CipConnectionManagerCloseRequest;
import org.apache.plc4x.java.eip.readwrite.CipConnectionManagerRequest;
import org.apache.plc4x.java.eip.readwrite.CipConnectionManagerResponse;
import org.apache.plc4x.java.eip.readwrite.CipRRData;
import org.apache.plc4x.java.eip.readwrite.CipReadRequest;
import org.apache.plc4x.java.eip.readwrite.CipReadResponse;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.eip.readwrite.CipUnconnectedRequest;
import org.apache.plc4x.java.eip.readwrite.CipWriteRequest;
import org.apache.plc4x.java.eip.readwrite.CipWriteResponse;
import org.apache.plc4x.java.eip.readwrite.ClassID;
import org.apache.plc4x.java.eip.readwrite.ConnectedAddressItem;
import org.apache.plc4x.java.eip.readwrite.ConnectedDataItem;
import org.apache.plc4x.java.eip.readwrite.DataSegment;
import org.apache.plc4x.java.eip.readwrite.EipConnectionRequest;
import org.apache.plc4x.java.eip.readwrite.EipConnectionResponse;
import org.apache.plc4x.java.eip.readwrite.EipDisconnectRequest;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.eip.readwrite.GetAttributeAllRequest;
import org.apache.plc4x.java.eip.readwrite.GetAttributeAllResponse;
import org.apache.plc4x.java.eip.readwrite.InstanceID;
import org.apache.plc4x.java.eip.readwrite.ListServicesRequest;
import org.apache.plc4x.java.eip.readwrite.ListServicesResponse;
import org.apache.plc4x.java.eip.readwrite.LogicalSegment;
import org.apache.plc4x.java.eip.readwrite.MemberID;
import org.apache.plc4x.java.eip.readwrite.MultipleServiceRequest;
import org.apache.plc4x.java.eip.readwrite.MultipleServiceResponse;
import org.apache.plc4x.java.eip.readwrite.NetworkConnectionParameters;
import org.apache.plc4x.java.eip.readwrite.NullAddressItem;
import org.apache.plc4x.java.eip.readwrite.NullCommandRequest;
import org.apache.plc4x.java.eip.readwrite.PathSegment;
import org.apache.plc4x.java.eip.readwrite.PortSegment;
import org.apache.plc4x.java.eip.readwrite.PortSegmentExtended;
import org.apache.plc4x.java.eip.readwrite.PortSegmentNormal;
import org.apache.plc4x.java.eip.readwrite.SendUnitData;
import org.apache.plc4x.java.eip.readwrite.Services;
import org.apache.plc4x.java.eip.readwrite.ServicesResponse;
import org.apache.plc4x.java.eip.readwrite.TransportType;
import org.apache.plc4x.java.eip.readwrite.TypeId;
import org.apache.plc4x.java.eip.readwrite.UnConnectedDataItem;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EipProtocolLogic
extends Plc4xProtocolBase<EipPacket>
implements HasConfiguration<EIPConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(EipProtocolLogic.class);
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(10000L);
    private static final byte[] DEFAULT_SENDER_CONTEXT = "PLC4X   ".getBytes(StandardCharsets.US_ASCII);
    private static final long EMPTY_SESSION_HANDLE = 0L;
    private static final long EMPTY_INTERFACE_HANDLE = 0L;
    private NullAddressItem nullAddressItem;
    private byte[] senderContext;
    private long connectionId = 0L;
    private int sequenceCount = 1;
    private EIPConfiguration configuration;
    private final AtomicInteger transactionCounterGenerator = new AtomicInteger(10);
    private RequestTransactionManager tm;
    private long sessionHandle;
    private boolean useConnectionManager = false;
    private boolean cipEncapsulationAvailable = false;
    private boolean useMessageRouter = false;
    private final List<PathSegment> routingAddress = new ArrayList<PathSegment>();
    short connectionPathSize = 0;
    private final int connectionSerialNumber = ThreadLocalRandom.current().nextInt();

    @Override
    public void setConfiguration(EIPConfiguration configuration) {
        block16: {
            block14: {
                block15: {
                    this.configuration = configuration;
                    this.nullAddressItem = new NullAddressItem();
                    if (!(configuration instanceof LogixConfiguration)) break block14;
                    LogixConfiguration logixConfiguration = (LogixConfiguration)configuration;
                    if (logixConfiguration.getCommunicationPath() == null) break block15;
                    String[] splitConnectionPath = logixConfiguration.getCommunicationPath().split(",");
                    if (splitConnectionPath.length % 2 != 0) break block16;
                    int i = 0;
                    while (i + 1 < splitConnectionPath.length) {
                        switch (splitConnectionPath[i]) {
                            case "1": {
                                int backplanePortId = Integer.parseInt(splitConnectionPath[i]);
                                int slot = Integer.parseInt(splitConnectionPath[i + 1]);
                                this.routingAddress.add(new PortSegment(new PortSegmentNormal((byte)backplanePortId, (short)slot)));
                                break;
                            }
                            case "2": {
                                int ethernetPortId = Integer.parseInt(splitConnectionPath[i]);
                                String ipAddress = splitConnectionPath[i + 1];
                                int lengthString = ipAddress.length();
                                if (ipAddress.length() % 2 != 0) {
                                    ipAddress = String.valueOf(ipAddress) + "\u0000";
                                }
                                this.routingAddress.add(new PortSegment(new PortSegmentExtended((byte)ethernetPortId, (short)lengthString, ipAddress)));
                                break;
                            }
                            default: {
                                logger.error("Only backplane or Ethernet module routing is supported");
                            }
                        }
                        i += 2;
                    }
                    break block16;
                }
                this.routingAddress.add(new PortSegment(new PortSegmentNormal(1, (short)this.configuration.getSlot())));
                break block16;
            }
            this.routingAddress.add(new PortSegment(new PortSegmentNormal(1, (short)this.configuration.getSlot())));
        }
        this.routingAddress.add(new LogicalSegment(new ClassID(0, 2)));
        this.routingAddress.add(new LogicalSegment(new InstanceID(0, 1)));
        for (PathSegment segment : this.routingAddress) {
            this.connectionPathSize = (short)(this.connectionPathSize + segment.getLengthInBytes());
        }
        if (this.connectionPathSize % 2 != 0) {
            this.connectionPathSize = (short)(this.connectionPathSize + 1);
        }
        this.connectionPathSize = (short)(this.connectionPathSize / 2);
        this.tm = new RequestTransactionManager(1);
    }

    @Override
    public void close(ConversationContext<EipPacket> context) {
        this.tm.shutdown();
    }

    public CompletableFuture<Boolean> detectEndianness(ConversationContext<EipPacket> context) {
        logger.debug("Sending Unknown Command to determine Endianess");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        NullCommandRequest listServicesRequest = new NullCommandRequest(0L, CIPStatus.Success.getValue(), DEFAULT_SENDER_CONTEXT, 0L);
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = context.sendRequest(listServicesRequest).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onError((p, e) -> logger.warn("No response for initial packet. Suspect device uses Big endian")).only(NullCommandRequest.class).handle(p -> {
                logger.info("Device uses little endian");
                future.complete(true);
                transaction.endRequest();
            });
        });
        return future;
    }

    private void listServices(ConversationContext<EipPacket> context) {
        logger.debug("Sending List Services packet to confirm CIP Encapsulation is available");
        ListServicesRequest listServicesRequest = new ListServicesRequest(0L, CIPStatus.Success.getValue(), DEFAULT_SENDER_CONTEXT, 0L);
        context.sendRequest(listServicesRequest).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onError((p, e) -> {
            throw new PlcRuntimeException("List EIP Services failed");
        }).handle(p -> {
            ServicesResponse listServicesResponse;
            if (p.getStatus() == CIPStatus.Success.getValue()) {
                listServicesResponse = (ServicesResponse)((ListServicesResponse)p).getTypeIds().get(0);
                if (listServicesResponse.getSupportsCIPEncapsulation()) {
                    logger.debug("Device is capable of CIP over EIP encapsulation");
                }
            } else {
                if (p.getStatus() == CIPStatus.InvalidCommandWithWrongEndianess.getValue()) {
                    throw new PlcRuntimeException("The remote device doesn't seem to use " + this.configuration.getByteOrder().name() + " byte order.");
                }
                throw new PlcRuntimeException("Got status code while polling for supported EIP services [" + p.getStatus() + "]");
            }
            this.cipEncapsulationAvailable = listServicesResponse.getSupportsCIPEncapsulation();
            this.onConnectRegisterSession(context);
        });
    }

    private void getAllAttributes(ConversationContext<EipPacket> context) {
        logger.debug("Requesting list of supported attributes");
        LogicalSegment classSegment = new LogicalSegment(new ClassID(0, 2));
        LogicalSegment instanceSegment = new LogicalSegment(new InstanceID(0, 1));
        UnConnectedDataItem exchange = new UnConnectedDataItem(new GetAttributeAllRequest(classSegment, instanceSegment));
        List<TypeId> typeIds = Arrays.asList(this.nullAddressItem, exchange);
        CipRRData eipWrapper = new CipRRData(this.sessionHandle, CIPStatus.Success.getValue(), this.senderContext, 0L, 0L, 0, typeIds);
        context.sendRequest(eipWrapper).expectResponse(EipPacket.class, REQUEST_TIMEOUT).only(CipRRData.class).check(cipRRData -> {
            if (cipRRData.getStatus() != CIPStatus.Success.getValue()) {
                throw new PlcRuntimeException("Got status code while polling for supported CIP services [" + cipRRData.getStatus() + "]");
            }
            return true;
        }).unwrap(cipRRData -> cipRRData.getTypeIds().get(1)).only(UnConnectedDataItem.class).unwrap(UnConnectedDataItem::getService).only(GetAttributeAllResponse.class).handle(response -> {
            if ((long)response.getStatus() == CIPStatus.ServiceNotSupported.getValue()) {
                context.fireConnected();
                return;
            }
            if ((long)response.getStatus() != CIPStatus.Success.getValue()) {
                throw new PlcRuntimeException("Got status code while polling for supported CIP attributes [" + response.getStatus() + "]");
            }
            if (response.getAttributes() != null) {
                for (Integer classId : response.getAttributes().getClassId()) {
                    if (CIPClassID.enumForValue(classId) == CIPClassID.MessageRouter) {
                        this.useMessageRouter = true;
                    }
                    if (CIPClassID.enumForValue(classId) != CIPClassID.ConnectionManager) continue;
                    this.useConnectionManager = true;
                }
            }
            if (this.useConnectionManager) {
                logger.debug("Device is using a Connection Manager");
                this.onConnectOpenConnectionManager(context);
            } else {
                context.fireConnected();
            }
        });
    }

    @Override
    public void onConnect(ConversationContext<EipPacket> context) {
        this.listServices(context);
    }

    private void onConnectRegisterSession(ConversationContext<EipPacket> context) {
        logger.debug("Sending Register Session EIP Package");
        EipConnectionRequest connectionRequest = new EipConnectionRequest(0L, CIPStatus.Success.getValue(), DEFAULT_SENDER_CONTEXT, 0L);
        context.sendRequest(connectionRequest).expectResponse(EipPacket.class, REQUEST_TIMEOUT).handle(p -> {
            if (p instanceof EipConnectionResponse) {
                if (p.getStatus() != CIPStatus.Success.getValue()) throw new PlcRuntimeException("Got status code while polling for supported EIP services [" + p.getStatus() + "]");
                this.sessionHandle = p.getSessionHandle();
                this.senderContext = p.getSenderContext();
                logger.debug("Got assigned with Session handle {}", (Object)this.sessionHandle);
                this.getAllAttributes(context);
                return;
            } else {
                this.onConnectOpenConnectionManager(context);
            }
        });
    }

    public void onConnectOpenConnectionManager(ConversationContext<EipPacket> context) {
        logger.debug("Sending Open Connection Manager EIP Package");
        LogicalSegment classSegment = new LogicalSegment(new ClassID(0, 6));
        LogicalSegment instanceSegment = new LogicalSegment(new InstanceID(0, 1));
        UnConnectedDataItem exchange = new UnConnectedDataItem(new CipConnectionManagerRequest(classSegment, instanceSegment, 0, 10, 14, 0x20000002L, 33944L, this.connectionSerialNumber, 4919, 42L, 3, 2101812L, new NetworkConnectionParameters(4002, false, 2, 0, true), 2113537L, new NetworkConnectionParameters(4002, false, 2, 0, true), new TransportType(true, 2, 3), this.connectionPathSize, this.routingAddress));
        List<TypeId> typeIds = Arrays.asList(this.nullAddressItem, exchange);
        CipRRData eipWrapper = new CipRRData(this.sessionHandle, CIPStatus.Success.getValue(), this.senderContext, 0L, 0L, 0, typeIds);
        context.sendRequest(eipWrapper).expectResponse(EipPacket.class, REQUEST_TIMEOUT).only(CipRRData.class).check(cipRRData -> {
            if (cipRRData.getStatus() != 0L) {
                throw new PlcRuntimeException("Got status code while opening Connection Manager[" + cipRRData.getStatus() + "]");
            }
            return true;
        }).unwrap(CipRRData::getTypeIds).unwrap(connectionManagerExchange -> (TypeId)connectionManagerExchange.get(1)).only(UnConnectedDataItem.class).unwrap(UnConnectedDataItem::getService).only(CipConnectionManagerResponse.class).handle(connectionManagerResponse -> {
            this.connectionId = connectionManagerResponse.getOtConnectionId();
            logger.debug("Got assigned with Connection Id {}", (Object)this.connectionId);
            context.fireConnected();
        });
    }

    @Override
    public void onDisconnect(ConversationContext<EipPacket> context) {
        if (this.connectionId != 0L) {
            logger.debug("Sending Connection Manager Close Event");
            LogicalSegment classSegment = new LogicalSegment(new ClassID(0, 6));
            LogicalSegment instanceSegment = new LogicalSegment(new InstanceID(0, 1));
            UnConnectedDataItem exchange = new UnConnectedDataItem(new CipConnectionManagerCloseRequest(2, classSegment, instanceSegment, 0, 10, 14, this.connectionSerialNumber, 4919, 42L, this.connectionPathSize, this.routingAddress));
            List<TypeId> typeIds = Arrays.asList(this.nullAddressItem, exchange);
            CipRRData eipWrapper = new CipRRData(this.sessionHandle, 0L, this.senderContext, 0L, 0L, 0, typeIds);
            context.sendRequest(eipWrapper).expectResponse(EipPacket.class, REQUEST_TIMEOUT).unwrap(p -> p).check(p -> p instanceof CipRRData).handle(p -> {
                logger.debug("Un-Registering Session");
                this.onDisconnectUnregisterSession(context);
            });
        } else {
            this.onDisconnectUnregisterSession(context);
        }
    }

    public void onDisconnectUnregisterSession(ConversationContext<EipPacket> context) {
        logger.debug("Sending Un RegisterSession EIP Package");
        EipDisconnectRequest connectionRequest = new EipDisconnectRequest(this.sessionHandle, 0L, DEFAULT_SENDER_CONTEXT, 0L);
        context.sendRequest(connectionRequest).expectResponse(EipPacket.class, Duration.ofMillis(1L)).onError((p, e) -> context.fireDisconnected()).onTimeout(p -> context.fireDisconnected()).handle(p -> context.fireDisconnected());
        context.fireDisconnected();
    }

    private CompletableFuture<PlcReadResponse> readWithoutMessageRouter(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        HashMap<String, ResponseItem<PlcValue>> values = new HashMap<String, ResponseItem<PlcValue>>();
        LogicalSegment classSegment = new LogicalSegment(new ClassID(0, 6));
        LogicalSegment instanceSegment = new LogicalSegment(new InstanceID(0, 1));
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        for (String tagName : request.getTagNames()) {
            CompletableFuture internalFuture = new CompletableFuture();
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            EipTag eipTag = (EipTag)request.getTag(tagName);
            String tag = eipTag.getTag();
            try {
                CipReadRequest req = new CipReadRequest(EipProtocolLogic.toAnsi(tag), 1);
                CipUnconnectedRequest requestItem = new CipUnconnectedRequest(classSegment, instanceSegment, req, (byte)this.configuration.getBackplane(), (byte)this.configuration.getSlot());
                ArrayList<TypeId> typeIds = new ArrayList<TypeId>(2);
                typeIds.add(this.nullAddressItem);
                typeIds.add(new UnConnectedDataItem(requestItem));
                CipRRData pkt = new CipRRData(this.sessionHandle, CIPStatus.Success.getValue(), DEFAULT_SENDER_CONTEXT, 0L, 0L, 0, typeIds);
                transaction.submit(() -> {
                    ConversationContext.ContextHandler contextHandler = this.context.sendRequest(pkt).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> {
                        boolean bl = future.completeExceptionally((Throwable)e);
                    }).check(p -> p instanceof CipRRData).unwrap(p -> (CipRRData)p).check(p -> p.getSessionHandle() == this.sessionHandle).handle(p -> {
                        List<TypeId> responseTypeIds = p.getTypeIds();
                        UnConnectedDataItem dataItem = (UnConnectedDataItem)responseTypeIds.get(1);
                        Map<String, ResponseItem<PlcValue>> readResponse = this.decodeSingleReadResponse(dataItem.getService(), tagName, eipTag);
                        values.putAll(readResponse);
                        internalFuture.complete(true);
                        transaction.endRequest();
                    });
                });
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        DefaultPlcReadResponse readResponse = new DefaultPlcReadResponse(readRequest, values);
        future.complete(readResponse);
        return future;
    }

    private CompletableFuture<PlcReadResponse> readWithoutConnectionManager(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        LogicalSegment classSegment = new LogicalSegment(new ClassID(0, 6));
        LogicalSegment instanceSegment = new LogicalSegment(new InstanceID(0, 1));
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        ArrayList<CipService> requests = new ArrayList<CipService>(request.getNumberOfTags());
        for (PlcTag field : request.getTags()) {
            EipTag plcField = (EipTag)field;
            String tag = plcField.getTag();
            try {
                CipReadRequest req = new CipReadRequest(EipProtocolLogic.toAnsi(tag), 1);
                CipUnconnectedRequest unreq = new CipUnconnectedRequest(classSegment, instanceSegment, req, (byte)this.configuration.getBackplane(), (byte)this.configuration.getSlot());
                requests.add(unreq);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        ArrayList<TypeId> typeIds = new ArrayList<TypeId>(2);
        typeIds.add(this.nullAddressItem);
        if (requests.size() == 1) {
            typeIds.add(new UnConnectedDataItem((CipService)requests.get(0)));
        } else {
            ArrayList<Integer> offsets = new ArrayList<Integer>(requests.size());
            offsets.add(8);
            for (CipService cipRequest : requests) {
                if (requests.indexOf(cipRequest) == requests.size() - 1) continue;
                offsets.add((Integer)offsets.get(requests.indexOf(cipRequest)) + cipRequest.getLengthInBytes());
            }
            MultipleServiceRequest serviceRequest = new MultipleServiceRequest(new Services(offsets, requests));
            typeIds.add(new UnConnectedDataItem(serviceRequest));
        }
        CipRRData pkt = new CipRRData(this.sessionHandle, CIPStatus.Success.getValue(), DEFAULT_SENDER_CONTEXT, 0L, 0L, 0, typeIds);
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest(pkt).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).check(p -> p instanceof CipRRData).unwrap(p -> (CipRRData)p).check(p -> p.getSessionHandle() == this.sessionHandle).handle(p -> {
                List<TypeId> responseTypeIds = p.getTypeIds();
                UnConnectedDataItem dataItem = (UnConnectedDataItem)responseTypeIds.get(1);
                PlcReadResponse readResponse = this.decodeReadResponse(dataItem.getService(), request);
                future.complete(readResponse);
                transaction.endRequest();
            });
        });
        return future;
    }

    private CompletableFuture<PlcReadResponse> readWithConnectionManager(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        ArrayList<CipService> requests = new ArrayList<CipService>(request.getNumberOfTags());
        for (PlcTag field : request.getTags()) {
            EipTag plcField = (EipTag)field;
            String tag = plcField.getTag();
            try {
                CipReadRequest req = new CipReadRequest(EipProtocolLogic.toAnsi(tag), 1);
                requests.add(req);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        ConnectedAddressItem addressItem = new ConnectedAddressItem(this.connectionId);
        ArrayList<TypeId> typeIds = new ArrayList<TypeId>(2);
        typeIds.add(addressItem);
        if (requests.size() == 1) {
            typeIds.add(new ConnectedDataItem(this.sequenceCount, (CipService)requests.get(0)));
        } else {
            ArrayList<Integer> offsets = new ArrayList<Integer>(requests.size());
            offsets.add(2 + 2 * request.getNumberOfTags());
            for (CipService cipRequest : requests) {
                if (requests.indexOf(cipRequest) == requests.size() - 1) continue;
                offsets.add((Integer)offsets.get(requests.indexOf(cipRequest)) + cipRequest.getLengthInBytes());
            }
            Services services = new Services(offsets, requests);
            MultipleServiceRequest serviceRequest = new MultipleServiceRequest(services);
            typeIds.add(new ConnectedDataItem(this.sequenceCount, serviceRequest));
        }
        SendUnitData pkt = new SendUnitData(this.sessionHandle, CIPStatus.Success.getValue(), DEFAULT_SENDER_CONTEXT, 0L, 0, typeIds);
        ++this.sequenceCount;
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest(pkt).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).check(p -> p instanceof SendUnitData).unwrap(p -> (SendUnitData)p).check(p -> p.getSessionHandle() == this.sessionHandle).handle(p -> {
                List<TypeId> responseTypeIds = p.getTypeIds();
                ConnectedDataItem dataItem = (ConnectedDataItem)responseTypeIds.get(1);
                PlcReadResponse readResponse = this.decodeReadResponse(dataItem.getService(), request);
                future.complete(readResponse);
                transaction.endRequest();
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> future = !this.useMessageRouter && !this.useConnectionManager ? this.readWithoutMessageRouter(readRequest) : (this.useMessageRouter && !this.useConnectionManager ? this.readWithoutConnectionManager(readRequest) : this.readWithConnectionManager(readRequest));
        return future;
    }

    public static byte[] toAnsi(String tag) throws SerializationException {
        Pattern RESOURCE_ADDRESS_PATTERN = Pattern.compile("([.\\[\\]])*([A-Za-z_0-9]+){1}");
        Matcher matcher = RESOURCE_ADDRESS_PATTERN.matcher(tag);
        LinkedList<PathSegment> segments = new LinkedList<PathSegment>();
        int lengthBytes = 0;
        while (matcher.find()) {
            PathSegment newSegment;
            String identifier = matcher.group(2);
            String qualifier = matcher.group(1);
            if (qualifier != null) {
                if (qualifier.equals("[")) {
                    newSegment = new LogicalSegment(new MemberID(0, Short.parseShort(identifier)));
                    segments.add(newSegment);
                } else {
                    newSegment = new DataSegment(new AnsiExtendedSymbolSegment(identifier, (short)0));
                    segments.add(newSegment);
                }
            } else {
                newSegment = new DataSegment(new AnsiExtendedSymbolSegment(identifier, identifier.length() % 2 == 0 ? null : Short.valueOf((short)0)));
                segments.add(newSegment);
            }
            lengthBytes += newSegment.getLengthInBytes();
        }
        WriteBufferByteBased buffer = new WriteBufferByteBased(lengthBytes, org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
        for (PathSegment segment : segments) {
            segment.serialize(buffer);
        }
        return buffer.getBytes();
    }

    private PlcReadResponse decodeReadResponse(CipService p, PlcReadRequest readRequest) {
        HashMap<String, ResponseItem<PlcValue>> values = new HashMap<String, ResponseItem<PlcValue>>();
        if (p instanceof CipReadResponse) {
            CipReadResponse resp = (CipReadResponse)p;
            String fieldName = (String)readRequest.getTagNames().iterator().next();
            EipTag tag = (EipTag)readRequest.getTag(fieldName);
            PlcResponseCode code = this.decodeResponseCode(resp.getStatus());
            PlcValue plcValue = null;
            CIPDataTypeCode type = resp.getData().getDataType();
            ByteBuf data = Unpooled.wrappedBuffer(resp.getData().getData());
            if (code == PlcResponseCode.OK) {
                plcValue = this.parsePlcValue(tag, data, type);
            }
            ResponseItem<Object> result = new ResponseItem<Object>(code, plcValue);
            values.put(fieldName, result);
        } else if (p instanceof MultipleServiceResponse) {
            MultipleServiceResponse responses = (MultipleServiceResponse)p;
            int nb = responses.getServiceNb();
            ArrayList<CipService> arr = new ArrayList<CipService>(nb);
            ReadBufferByteBased read = new ReadBufferByteBased(responses.getServicesData(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            int total = read.getTotalBytes();
            int i = 0;
            while (i < nb) {
                int length = 0;
                int offset = responses.getOffsets().get(i) - responses.getOffsets().get(0);
                length = i == nb - 1 ? total - offset : responses.getOffsets().get(i + 1) - offset - responses.getOffsets().get(0);
                try {
                    CipService service = CipService.staticParse((ReadBuffer)read, false, length);
                    arr.add(service);
                }
                catch (ParseException e) {
                    throw new PlcRuntimeException(e);
                }
                ++i;
            }
            Services services = new Services(responses.getOffsets(), arr);
            Iterator it = readRequest.getTagNames().iterator();
            int i2 = 0;
            while (i2 < nb && it.hasNext()) {
                String fieldName = (String)it.next();
                EipTag tag = (EipTag)readRequest.getTag(fieldName);
                PlcValue plcValue = null;
                if (services.getServices().get(i2) instanceof CipReadResponse) {
                    CipReadResponse readResponse = (CipReadResponse)services.getServices().get(i2);
                    PlcResponseCode code = readResponse.getStatus() == 0 ? PlcResponseCode.OK : PlcResponseCode.INTERNAL_ERROR;
                    CIPDataTypeCode type = readResponse.getData().getDataType();
                    ByteBuf data = Unpooled.wrappedBuffer(readResponse.getData().getData());
                    if (code == PlcResponseCode.OK) {
                        plcValue = this.parsePlcValue(tag, data, type);
                    }
                    ResponseItem<Object> result = new ResponseItem<Object>(code, plcValue);
                    values.put(fieldName, result);
                }
                ++i2;
            }
        }
        return new DefaultPlcReadResponse(readRequest, values);
    }

    private Map<String, ResponseItem<PlcValue>> decodeSingleReadResponse(CipService p, String tagName, PlcTag tag) {
        HashMap<String, ResponseItem<PlcValue>> values = new HashMap<String, ResponseItem<PlcValue>>();
        CipReadResponse resp = (CipReadResponse)p;
        PlcResponseCode code = this.decodeResponseCode(resp.getStatus());
        PlcValue plcValue = null;
        CIPDataTypeCode type = resp.getData().getDataType();
        ByteBuf data = Unpooled.wrappedBuffer(resp.getData().getData());
        if (code == PlcResponseCode.OK) {
            plcValue = this.parsePlcValue((EipTag)tag, data, type);
        }
        ResponseItem<Object> result = new ResponseItem<Object>(code, plcValue);
        values.put(tagName, result);
        return values;
    }

    private PlcValue parsePlcValue(EipTag tag, ByteBuf data, CIPDataTypeCode type) {
        int STRING_LEN_OFFSET = 2;
        int STRING_DATA_OFFSET = 6;
        int nb = tag.getElementNb();
        if (nb > 1) {
            int index = 0;
            ArrayList<PlcValue> list = new ArrayList<PlcValue>();
            int i = 0;
            while (i < nb) {
                switch (type) {
                    case DINT: {
                        list.add(new PlcDINT(Integer.reverseBytes(data.getInt(index))));
                        index += type.getSize();
                        break;
                    }
                    case INT: {
                        list.add(new PlcINT(Integer.reverseBytes(data.getInt(index))));
                        index += type.getSize();
                        break;
                    }
                    case SINT: {
                        list.add(new PlcSINT(Integer.reverseBytes(data.getInt(index))));
                        index += type.getSize();
                        break;
                    }
                    case REAL: {
                        list.add(new PlcLREAL((double)this.swap(data.getFloat(index))));
                        index += type.getSize();
                        break;
                    }
                    case LINT: {
                        list.add(new PlcLINT(Long.reverseBytes(data.getLong(index))));
                        index += type.getSize();
                        break;
                    }
                    case BOOL: {
                        list.add(new PlcBOOL(data.getBoolean(index)));
                        index += type.getSize();
                        break;
                    }
                    case STRUCTURED: {
                        short structuredType = Short.reverseBytes(data.getShort(0));
                        short structuredLen = Short.reverseBytes(data.getShort(2));
                        if (structuredType == CIPStructTypeCode.STRING.getValue()) {
                            list.add(new PlcSTRING(StandardCharsets.UTF_8.decode(data.nioBuffer(6, structuredLen)).toString()));
                            index += type.getSize();
                        }
                        return null;
                    }
                    default: {
                        return null;
                    }
                }
                ++i;
            }
            return new PlcList(list);
        }
        switch (type) {
            case SINT: {
                return new PlcSINT(data.getByte(0));
            }
            case INT: {
                return new PlcINT(Short.reverseBytes(data.getShort(0)));
            }
            case DINT: {
                return new PlcDINT(Integer.reverseBytes(data.getInt(0)));
            }
            case LINT: {
                return new PlcLINT(Long.reverseBytes(data.getLong(0)));
            }
            case REAL: {
                return new PlcREAL(this.swap(data.getFloat(0)));
            }
            case BOOL: {
                return new PlcBOOL(data.getBoolean(0));
            }
            case STRING: 
            case STRUCTURED: {
                short structuredType = Short.reverseBytes(data.getShort(0));
                short structuredLen = Short.reverseBytes(data.getShort(2));
                if (structuredType == CIPStructTypeCode.STRING.getValue()) {
                    return new PlcSTRING(StandardCharsets.UTF_8.decode(data.nioBuffer(6, structuredLen)).toString());
                }
                return null;
            }
        }
        return null;
    }

    public float swap(float value) {
        int bytes = Float.floatToIntBits(value);
        int b1 = bytes & 0xFF;
        int b2 = bytes >> 8 & 0xFF;
        int b3 = bytes >> 16 & 0xFF;
        int b4 = bytes >> 24 & 0xFF;
        return Float.intBitsToFloat(b1 << 24 | b2 << 16 | b3 << 8 | b4);
    }

    public CompletableFuture<PlcWriteResponse> writeWithoutMessageRouter(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        ArrayList items = new ArrayList(writeRequest.getNumberOfTags());
        LogicalSegment classSegment = new LogicalSegment(new ClassID(0, 6));
        LogicalSegment instanceSegment = new LogicalSegment(new InstanceID(0, 1));
        HashMap<String, PlcResponseCode> values = new HashMap<String, PlcResponseCode>();
        for (String fieldName : writeRequest.getTagNames()) {
            EipTag field = (EipTag)request.getTag(fieldName);
            PlcValue value = request.getPlcValue(fieldName);
            String tag = field.getTag();
            int elements = Math.max(field.getElementNb(), 1);
            byte[] data = this.encodeValue(value, field.getType());
            CipWriteRequest writeReq = null;
            try {
                writeReq = new CipWriteRequest(EipProtocolLogic.toAnsi(tag), field.getType(), elements, data);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
            CompletableFuture internalFuture = new CompletableFuture();
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            this.tm.startRequest();
            UnConnectedDataItem exchange = new UnConnectedDataItem(new CipUnconnectedRequest(classSegment, instanceSegment, writeReq, (byte)this.configuration.getBackplane(), (byte)this.configuration.getSlot()));
            List<TypeId> typeIds = Arrays.asList(this.nullAddressItem, exchange);
            CipRRData rrdata = new CipRRData(this.sessionHandle, 0L, this.senderContext, 0L, 0L, 0, typeIds);
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.context.sendRequest(rrdata).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).check(p -> p instanceof CipRRData).unwrap(p -> (CipRRData)p).check(p -> p.getSessionHandle() == this.sessionHandle).check(p -> ((UnConnectedDataItem)p.getTypeIds().get(1)).getService() instanceof CipWriteResponse).unwrap(p -> (CipWriteResponse)((UnConnectedDataItem)p.getTypeIds().get(1)).getService()).handle(p -> {
                    Map<String, PlcResponseCode> responseItem = this.decodeSingleWriteResponse((CipWriteResponse)p, fieldName);
                    values.putAll(responseItem);
                    internalFuture.complete(true);
                    transaction.endRequest();
                });
            });
            try {
                internalFuture.get(REQUEST_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                future.completeExceptionally(new PlcRuntimeException("Failed to read field"));
            }
        }
        DefaultPlcWriteResponse response = new DefaultPlcWriteResponse(writeRequest, values);
        future.complete(response);
        return future;
    }

    public CompletableFuture<PlcWriteResponse> writeWithoutConnectionManager(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        ArrayList<CipWriteRequest> items = new ArrayList<CipWriteRequest>(writeRequest.getNumberOfTags());
        for (String fieldName : request.getTagNames()) {
            EipTag field = (EipTag)request.getTag(fieldName);
            PlcValue value = request.getPlcValue(fieldName);
            String tag = field.getTag();
            int elements = Math.max(field.getElementNb(), 1);
            byte[] data = this.encodeValue(value, field.getType());
            try {
                CipWriteRequest writeReq = new CipWriteRequest(EipProtocolLogic.toAnsi(tag), field.getType(), elements, data);
                items.add(writeReq);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        if (items.size() == 1) {
            this.tm.startRequest();
            LogicalSegment logicalSegment = new LogicalSegment(new ClassID(0, 6));
            LogicalSegment instanceSegment = new LogicalSegment(new InstanceID(0, 1));
            UnConnectedDataItem exchange = new UnConnectedDataItem(new CipUnconnectedRequest(logicalSegment, instanceSegment, (CipService)items.get(0), (byte)this.configuration.getBackplane(), (byte)this.configuration.getSlot()));
            List<TypeId> typeIds = Arrays.asList(this.nullAddressItem, exchange);
            CipRRData rrdata = new CipRRData(this.sessionHandle, 0L, this.senderContext, 0L, 0L, 0, typeIds);
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.context.sendRequest(rrdata).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).only(CipRRData.class).check(p -> p.getSessionHandle() == this.sessionHandle).unwrap(cipRRData -> cipRRData.getTypeIds().get(1)).only(UnConnectedDataItem.class).unwrap(UnConnectedDataItem::getService).only(CipWriteResponse.class).handle(p -> {
                    future.complete(this.decodeWriteResponse((CipService)p, writeRequest));
                    transaction.endRequest();
                });
            });
        } else {
            this.tm.startRequest();
            short s = items.size();
            ArrayList<Integer> offsets = new ArrayList<Integer>(s);
            int offset = 2 + s * 2;
            int i = 0;
            while (i < s) {
                offsets.add(offset);
                offset += ((CipWriteRequest)items.get(i)).getLengthInBytes();
                ++i;
            }
            ArrayList<CipService> serviceArr = new ArrayList<CipService>(s);
            short i2 = 0;
            while (i2 < s) {
                serviceArr.add((CipService)items.get(i2));
                ++i2;
            }
            Services data = new Services(offsets, serviceArr);
            LogicalSegment classSegment = new LogicalSegment(new ClassID(0, 6));
            LogicalSegment instanceSegment = new LogicalSegment(new InstanceID(0, 1));
            UnConnectedDataItem exchange = new UnConnectedDataItem(new CipUnconnectedRequest(classSegment, instanceSegment, new MultipleServiceRequest(data), (byte)this.configuration.getBackplane(), (byte)this.configuration.getSlot()));
            List<TypeId> typeIds = Arrays.asList(this.nullAddressItem, exchange);
            CipRRData pkt = new CipRRData(this.sessionHandle, 0L, DEFAULT_SENDER_CONTEXT, 0L, 0L, 0, typeIds);
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.context.sendRequest(pkt).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).check(p -> p instanceof CipRRData).check(p -> p.getSessionHandle() == this.sessionHandle).only(CipRRData.class).unwrap(cipRRData -> cipRRData.getTypeIds().get(1)).only(UnConnectedDataItem.class).unwrap(UnConnectedDataItem::getService).only(MultipleServiceResponse.class).check(p -> p.getServiceNb() == nb).handle(p -> {
                    future.complete(this.decodeWriteResponse((CipService)p, writeRequest));
                    transaction.endRequest();
                });
            });
        }
        return future;
    }

    public CompletableFuture<PlcWriteResponse> writeWithConnectionManager(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        ArrayList<CipWriteRequest> items = new ArrayList<CipWriteRequest>(writeRequest.getNumberOfTags());
        for (String fieldName : request.getTagNames()) {
            EipTag field = (EipTag)request.getTag(fieldName);
            PlcValue value = request.getPlcValue(fieldName);
            String tag = field.getTag();
            int elements = Math.max(field.getElementNb(), 1);
            byte[] data = this.encodeValue(value, field.getType());
            try {
                CipWriteRequest writeReq = new CipWriteRequest(EipProtocolLogic.toAnsi(tag), field.getType(), elements, data);
                items.add(writeReq);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        if (items.size() == 1) {
            this.tm.startRequest();
            ConnectedDataItem connectedDataItem = new ConnectedDataItem(this.sequenceCount, (CipService)items.get(0));
            ConnectedAddressItem addressItem = new ConnectedAddressItem(this.connectionId);
            List<TypeId> typeIds = Arrays.asList(addressItem, connectedDataItem);
            SendUnitData rrdata = new SendUnitData(this.sessionHandle, CIPStatus.Success.getValue(), this.senderContext, 0L, 0, typeIds);
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.context.sendRequest(rrdata).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).only(SendUnitData.class).check(sendUnitData -> sendUnitData.getSessionHandle() == this.sessionHandle).unwrap(sendUnitData -> sendUnitData.getTypeIds().get(1)).only(ConnectedDataItem.class).unwrap(ConnectedDataItem::getService).only(CipWriteResponse.class).handle(p -> {
                    future.complete(this.decodeWriteResponse((CipService)p, writeRequest));
                    transaction.endRequest();
                });
            });
        } else {
            this.tm.startRequest();
            short s = items.size();
            ArrayList<Integer> offsets = new ArrayList<Integer>(s);
            int offset = 2 + s * 2;
            int i = 0;
            while (i < s) {
                offsets.add(offset);
                offset += ((CipWriteRequest)items.get(i)).getLengthInBytes();
                ++i;
            }
            ArrayList<CipService> serviceArr = new ArrayList<CipService>(s);
            short i2 = 0;
            while (i2 < s) {
                serviceArr.add((CipService)items.get(i2));
                ++i2;
            }
            Services data = new Services(offsets, serviceArr);
            ConnectedDataItem exchange = new ConnectedDataItem(this.sequenceCount, new MultipleServiceRequest(data));
            List<TypeId> typeIds = Arrays.asList(this.nullAddressItem, exchange);
            SendUnitData pkt = new SendUnitData(this.sessionHandle, 0L, DEFAULT_SENDER_CONTEXT, 0L, 0, typeIds);
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.context.sendRequest(pkt).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).check(p -> p instanceof SendUnitData).check(p -> p.getSessionHandle() == this.sessionHandle).only(SendUnitData.class).unwrap(sendUnitData -> sendUnitData.getTypeIds().get(1)).only(ConnectedDataItem.class).unwrap(ConnectedDataItem::getService).only(MultipleServiceResponse.class).check(p -> p.getServiceNb() == nb).handle(p -> {
                    future.complete(this.decodeWriteResponse((CipService)p, writeRequest));
                    transaction.endRequest();
                });
            });
        }
        return future;
    }

    @Override
    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = !this.useMessageRouter && !this.useConnectionManager ? this.writeWithoutMessageRouter(writeRequest) : (this.useMessageRouter && !this.useConnectionManager ? this.writeWithoutConnectionManager(writeRequest) : this.writeWithConnectionManager(writeRequest));
        return future;
    }

    private Map<String, PlcResponseCode> decodeSingleWriteResponse(CipWriteResponse resp, String fieldName) {
        HashMap<String, PlcResponseCode> responses = new HashMap<String, PlcResponseCode>();
        responses.put(fieldName, this.decodeResponseCode(resp.getStatus()));
        return responses;
    }

    private PlcWriteResponse decodeWriteResponse(CipService p, PlcWriteRequest writeRequest) {
        HashMap<String, PlcResponseCode> responses = new HashMap<String, PlcResponseCode>();
        if (p instanceof CipWriteResponse) {
            CipWriteResponse resp = (CipWriteResponse)p;
            String fieldName = (String)writeRequest.getTagNames().iterator().next();
            responses.put(fieldName, this.decodeResponseCode(resp.getStatus()));
            return new DefaultPlcWriteResponse(writeRequest, responses);
        }
        if (p instanceof MultipleServiceResponse) {
            MultipleServiceResponse resp = (MultipleServiceResponse)p;
            int nb = resp.getServiceNb();
            ArrayList<CipService> arr = new ArrayList<CipService>(nb);
            ReadBufferByteBased read = new ReadBufferByteBased(resp.getServicesData());
            int total = read.getTotalBytes();
            int i = 0;
            while (i < nb) {
                int offset = resp.getOffsets().get(i);
                int length = offset == nb - 1 ? total - offset : resp.getOffsets().get(i + 1) - offset;
                try {
                    CipService service = CipService.staticParse((ReadBuffer)read, false, length);
                    arr.add(service);
                }
                catch (ParseException e) {
                    throw new PlcRuntimeException(e);
                }
                ++i;
            }
            Services services = new Services(resp.getOffsets(), arr);
            Iterator it = writeRequest.getTagNames().iterator();
            int i2 = 0;
            while (i2 < nb && it.hasNext()) {
                String fieldName = (String)it.next();
                if (services.getServices().get(i2) instanceof CipWriteResponse) {
                    CipWriteResponse writeResponse = (CipWriteResponse)services.getServices().get(i2);
                    PlcResponseCode code = this.decodeResponseCode(writeResponse.getStatus());
                    responses.put(fieldName, code);
                }
                ++i2;
            }
            return new DefaultPlcWriteResponse(writeRequest, responses);
        }
        return null;
    }

    private byte[] encodeValue(PlcValue value, CIPDataTypeCode type) {
        ByteBuffer buffer = ByteBuffer.allocate(type.getSize()).order(ByteOrder.LITTLE_ENDIAN);
        switch (type) {
            case BOOL: {
                buffer.put(value.getByte());
                break;
            }
            case SINT: {
                buffer.put(value.getByte());
                break;
            }
            case INT: {
                buffer.putShort(value.getShort());
                break;
            }
            case DINT: {
                buffer.putInt(value.getInteger());
                break;
            }
            case REAL: {
                buffer.putDouble(value.getDouble());
                break;
            }
            case LINT: {
                buffer.putLong(value.getLong());
                break;
            }
            case STRING: 
            case STRUCTURED: {
                buffer.putInt(value.getString().length());
                buffer.put(value.getString().getBytes(), 0, value.getString().length());
                break;
            }
        }
        return buffer.array();
    }

    private PlcResponseCode decodeResponseCode(int status) {
        switch (status) {
            case 0: {
                return PlcResponseCode.OK;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }
}

