/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.base.tag;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.eip.readwrite.CIPDataTypeCode;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

public class EipTag
implements PlcTag,
Serializable {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^(?<tag>[%a-zA-Z_.0-9]+\\[?[0-9]*]?):?(?<dataType>[A-Z]*):?(?<elementNb>[0-9]*)");
    private static final String GROUP_NAME_TAG = "tag";
    private static final String GROUP_NAME_GROUP_NAME_ELEMENTS = "elementNb";
    private static final String GROUP_NAME_TYPE = "dataType";
    private final String tag;
    private CIPDataTypeCode type;
    private int elementNb;

    public EipTag(String tag) {
        this.tag = tag;
        this.elementNb = 1;
    }

    public EipTag(String tag, int elementNb) {
        this.tag = tag;
        this.elementNb = elementNb;
    }

    public EipTag(String tag, CIPDataTypeCode type, int elementNb) {
        this.tag = tag;
        this.type = type;
        this.elementNb = elementNb;
    }

    public EipTag(String tag, CIPDataTypeCode type) {
        this.tag = tag;
        this.type = type;
    }

    @Override
    public String getAddressString() {
        throw new NotImplementedException("Need to implement this");
    }

    @Override
    public PlcValueType getPlcValueType() {
        return PlcValueType.valueOf(this.type.name());
    }

    @Override
    public List<ArrayInfo> getArrayInfo() {
        return PlcTag.super.getArrayInfo();
    }

    public CIPDataTypeCode getType() {
        return this.type;
    }

    public void setType(CIPDataTypeCode type) {
        this.type = type;
    }

    public int getElementNb() {
        return this.elementNb;
    }

    public void setElementNb(int elementNb) {
        this.elementNb = elementNb;
    }

    public String getTag() {
        return this.tag;
    }

    public static boolean matches(String tagQuery) {
        return ADDRESS_PATTERN.matcher(tagQuery).matches();
    }

    public static EipTag of(String tagString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            String tag = matcher.group(GROUP_NAME_TAG);
            int nb = 1;
            if (!matcher.group(GROUP_NAME_GROUP_NAME_ELEMENTS).isEmpty()) {
                nb = Integer.parseInt(matcher.group(GROUP_NAME_GROUP_NAME_ELEMENTS));
            }
            CIPDataTypeCode type = !matcher.group(GROUP_NAME_TYPE).isEmpty() ? CIPDataTypeCode.valueOf(matcher.group(GROUP_NAME_TYPE)) : CIPDataTypeCode.DINT;
            if (nb != 0) {
                return new EipTag(tag, type, nb);
            }
            return new EipTag(tag, type);
        }
        return null;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeString("node", this.tag.getBytes(StandardCharsets.UTF_8).length * 8, this.tag, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        if (this.type != null) {
            writeBuffer.writeString("type", this.type.name().getBytes(StandardCharsets.UTF_8).length * 8, this.type.name(), WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        }
        writeBuffer.writeUnsignedInt(GROUP_NAME_GROUP_NAME_ELEMENTS, 16, this.elementNb, new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

