/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.eip.readwrite.CIPDataTypeCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CIPData
implements Message {
    protected final CIPDataTypeCode dataType;
    protected final byte[] data;

    public CIPData(CIPDataTypeCode dataType, byte[] data) {
        this.dataType = dataType;
        this.data = data;
    }

    public CIPDataTypeCode getDataType() {
        return this.dataType;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CIPData", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("dataType", "CIPDataTypeCode", this.dataType, new DataWriterEnumDefault<CIPDataTypeCode, Integer>(CIPDataTypeCode::getValue, Enum::name, DataWriterFactory.writeUnsignedInt(writeBuffer, 16)), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("CIPData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        CIPData _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static CIPData staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer packetLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            packetLength = (Integer)args[0];
        } else if (args[0] instanceof String) {
            packetLength = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return CIPData.staticParse(readBuffer, packetLength);
    }

    public static CIPData staticParse(ReadBuffer readBuffer, Integer packetLength) throws ParseException {
        readBuffer.pullContext("CIPData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        CIPDataTypeCode dataType = (CIPDataTypeCode)((Object)FieldReaderFactory.readEnumField("dataType", "CIPDataTypeCode", new DataReaderEnumDefault<CIPDataTypeCode, Integer>(CIPDataTypeCode::enumForValue, DataReaderFactory.readUnsignedInt(readBuffer, 16)), new WithReaderArgs[0]));
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(packetLength - 2), new WithReaderArgs[0]);
        readBuffer.closeContext("CIPData", new WithReaderArgs[0]);
        CIPData _cIPData = new CIPData(dataType, data);
        return _cIPData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CIPData)) {
            return false;
        }
        CIPData that = (CIPData)o;
        return this.getDataType() == that.getDataType() && this.getData() == that.getData();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getDataType(), this.getData()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

