/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.eip.readwrite.PathSegment;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CipUnconnectedRequest
extends CipService
implements Message {
    public static final Integer ROUTE = 1;
    protected final PathSegment classSegment;
    protected final PathSegment instanceSegment;
    protected final CipService unconnectedService;
    protected final byte backPlane;
    protected final byte slot;

    @Override
    public Byte getService() {
        return (byte)82;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    @Override
    public Boolean getConnected() {
        return false;
    }

    public CipUnconnectedRequest(PathSegment classSegment, PathSegment instanceSegment, CipService unconnectedService, byte backPlane, byte slot) {
        this.classSegment = classSegment;
        this.instanceSegment = instanceSegment;
        this.unconnectedService = unconnectedService;
        this.backPlane = backPlane;
        this.slot = slot;
    }

    public PathSegment getClassSegment() {
        return this.classSegment;
    }

    public PathSegment getInstanceSegment() {
        return this.instanceSegment;
    }

    public CipService getUnconnectedService() {
        return this.unconnectedService;
    }

    public byte getBackPlane() {
        return this.backPlane;
    }

    public byte getSlot() {
        return this.slot;
    }

    public int getRoute() {
        return ROUTE;
    }

    @Override
    protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CipUnconnectedRequest", new WithWriterArgs[0]);
        short requestPathSize = (short)((this.getClassSegment().getLengthInBytes() + this.getInstanceSegment().getLengthInBytes()) / 2);
        FieldWriterFactory.writeImplicitField("requestPathSize", requestPathSize, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("classSegment", this.classSegment, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("instanceSegment", this.instanceSegment, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", 40197, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        int messageSize = this.getLengthInBytes() - 10 - 4;
        FieldWriterFactory.writeImplicitField("messageSize", messageSize, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("unconnectedService", this.unconnectedService, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField("route", ROUTE, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("backPlane", this.backPlane, DataWriterFactory.writeSignedByte(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("slot", this.slot, DataWriterFactory.writeSignedByte(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("CipUnconnectedRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CipUnconnectedRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += this.classSegment.getLengthInBits();
        lengthInBits += this.instanceSegment.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += this.unconnectedService.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += 8;
        return lengthInBits += 8;
    }

    public static CipService.CipServiceBuilder staticParseCipServiceBuilder(ReadBuffer readBuffer, Boolean connected, Integer serviceLen) throws ParseException {
        readBuffer.pullContext("CipUnconnectedRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short requestPathSize = FieldReaderFactory.readImplicitField("requestPathSize", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        PathSegment classSegment = FieldReaderFactory.readSimpleField("classSegment", new DataReaderComplexDefault<PathSegment>(() -> PathSegment.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PathSegment instanceSegment = FieldReaderFactory.readSimpleField("instanceSegment", new DataReaderComplexDefault<PathSegment>(() -> PathSegment.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        Integer reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedInt(readBuffer, 16), 40197, new WithReaderArgs[0]);
        int messageSize = FieldReaderFactory.readImplicitField("messageSize", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        CipService unconnectedService = FieldReaderFactory.readSimpleField("unconnectedService", new DataReaderComplexDefault<CipService>(() -> CipService.staticParse(readBuffer, false, messageSize), readBuffer), new WithReaderArgs[0]);
        int route = FieldReaderFactory.readConstField("route", DataReaderFactory.readUnsignedInt(readBuffer, 16), ROUTE, new WithReaderArgs[0]);
        byte backPlane = FieldReaderFactory.readSimpleField("backPlane", DataReaderFactory.readSignedByte(readBuffer, 8), new WithReaderArgs[0]);
        byte slot = FieldReaderFactory.readSimpleField("slot", DataReaderFactory.readSignedByte(readBuffer, 8), new WithReaderArgs[0]);
        readBuffer.closeContext("CipUnconnectedRequest", new WithReaderArgs[0]);
        return new CipUnconnectedRequestBuilderImpl(classSegment, instanceSegment, unconnectedService, backPlane, slot);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipUnconnectedRequest)) {
            return false;
        }
        CipUnconnectedRequest that = (CipUnconnectedRequest)o;
        return this.getClassSegment() == that.getClassSegment() && this.getInstanceSegment() == that.getInstanceSegment() && this.getUnconnectedService() == that.getUnconnectedService() && this.getBackPlane() == that.getBackPlane() && this.getSlot() == that.getSlot() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getClassSegment(), this.getInstanceSegment(), this.getUnconnectedService(), this.getBackPlane(), this.getSlot());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CipUnconnectedRequestBuilderImpl
    implements CipService.CipServiceBuilder {
        private final PathSegment classSegment;
        private final PathSegment instanceSegment;
        private final CipService unconnectedService;
        private final byte backPlane;
        private final byte slot;

        public CipUnconnectedRequestBuilderImpl(PathSegment classSegment, PathSegment instanceSegment, CipService unconnectedService, byte backPlane, byte slot) {
            this.classSegment = classSegment;
            this.instanceSegment = instanceSegment;
            this.unconnectedService = unconnectedService;
            this.backPlane = backPlane;
            this.slot = slot;
        }

        @Override
        public CipUnconnectedRequest build() {
            CipUnconnectedRequest cipUnconnectedRequest = new CipUnconnectedRequest(this.classSegment, this.instanceSegment, this.unconnectedService, this.backPlane, this.slot);
            return cipUnconnectedRequest;
        }
    }
}

