/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CIPDataTypeCode;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CipWriteRequest
extends CipService
implements Message {
    protected final byte[] tag;
    protected final CIPDataTypeCode dataType;
    protected final int elementNb;
    protected final byte[] data;

    @Override
    public Byte getService() {
        return (byte)77;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    @Override
    public Boolean getConnected() {
        return false;
    }

    public CipWriteRequest(byte[] tag, CIPDataTypeCode dataType, int elementNb, byte[] data) {
        this.tag = tag;
        this.dataType = dataType;
        this.elementNb = elementNb;
        this.data = data;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public CIPDataTypeCode getDataType() {
        return this.dataType;
    }

    public int getElementNb() {
        return this.elementNb;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CipWriteRequest", new WithWriterArgs[0]);
        short requestPathSize = (short)(StaticHelper.COUNT(this.getTag()) / 2);
        FieldWriterFactory.writeImplicitField("requestPathSize", requestPathSize, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("tag", this.tag, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("dataType", "CIPDataTypeCode", this.dataType, new DataWriterEnumDefault<CIPDataTypeCode, Integer>(CIPDataTypeCode::getValue, Enum::name, DataWriterFactory.writeUnsignedInt(writeBuffer, 16)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("elementNb", this.elementNb, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("CipWriteRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CipWriteRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        if (this.tag != null) {
            lengthInBits += 8 * this.tag.length;
        }
        lengthInBits += 16;
        lengthInBits += 16;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static CipService.CipServiceBuilder staticParseCipServiceBuilder(ReadBuffer readBuffer, Boolean connected, Integer serviceLen) throws ParseException {
        readBuffer.pullContext("CipWriteRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short requestPathSize = FieldReaderFactory.readImplicitField("requestPathSize", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        byte[] tag = readBuffer.readByteArray("tag", Math.toIntExact(requestPathSize * 2), new WithReaderArgs[0]);
        CIPDataTypeCode dataType = (CIPDataTypeCode)((Object)FieldReaderFactory.readEnumField("dataType", "CIPDataTypeCode", new DataReaderEnumDefault<CIPDataTypeCode, Integer>(CIPDataTypeCode::enumForValue, DataReaderFactory.readUnsignedInt(readBuffer, 16)), new WithReaderArgs[0]));
        int elementNb = FieldReaderFactory.readSimpleField("elementNb", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(dataType.getSize() * elementNb), new WithReaderArgs[0]);
        readBuffer.closeContext("CipWriteRequest", new WithReaderArgs[0]);
        return new CipWriteRequestBuilderImpl(tag, dataType, elementNb, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipWriteRequest)) {
            return false;
        }
        CipWriteRequest that = (CipWriteRequest)o;
        return this.getTag() == that.getTag() && this.getDataType() == that.getDataType() && this.getElementNb() == that.getElementNb() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getTag(), this.getDataType(), this.getElementNb(), this.getData()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CipWriteRequestBuilderImpl
    implements CipService.CipServiceBuilder {
        private final byte[] tag;
        private final CIPDataTypeCode dataType;
        private final int elementNb;
        private final byte[] data;

        public CipWriteRequestBuilderImpl(byte[] tag, CIPDataTypeCode dataType, int elementNb, byte[] data) {
            this.tag = tag;
            this.dataType = dataType;
            this.elementNb = elementNb;
            this.data = data;
        }

        @Override
        public CipWriteRequest build() {
            CipWriteRequest cipWriteRequest = new CipWriteRequest(this.tag, this.dataType, this.elementNb, this.data);
            return cipWriteRequest;
        }
    }
}

